/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionCacheEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.CollectionEntry;
import org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
extends AbstractEventListener
implements InitializeCollectionEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultInitializeCollectionEventListener == null ? (class$org$hibernate$event$DefaultInitializeCollectionEventListener = DefaultInitializeCollectionEventListener.class$("org.hibernate.event.DefaultInitializeCollectionEventListener")) : class$org$hibernate$event$DefaultInitializeCollectionEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultInitializeCollectionEventListener;

    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        SessionEventSource source = event.getSource();
        CollectionEntry ce = source.getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!ce.isInitialized()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + MessageHelper.infoString((CollectionPersister)ce.getLoadedPersister(), (Serializable)ce.getLoadedKey())));
            }
            log.trace((Object)"checking second-level cache");
            boolean foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedPersister(), collection, source);
            if (foundInCache) {
                log.trace((Object)"collection initialized from cache");
            } else {
                log.trace((Object)"collection not cached");
                ce.getLoadedPersister().initialize(ce.getLoadedKey(), source);
                log.trace((Object)"collection initialized");
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().fetchCollection(ce.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable id, CollectionPersister persister, PersistentCollection collection, SessionEventSource source) throws HibernateException {
        boolean useCache;
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        Object ce = persister.getCache().get(new CacheKey(id, persister.getKeyType(), persister.getRole()), source.getTimestamp());
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCache().getRegionName());
            } else {
                factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCache().getRegionName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        cacheEntry.assemble(collection, persister, source.getCollectionOwner(id, persister));
        source.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

