/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.PersistentObjectException;
import org.hibernate.event.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;

public class DefaultSaveEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        EntityEntry entry = event.getSource().getEntry(event.getEntity());
        if (entry != null && entry.getStatus() != Status.DELETED) {
            return this.entityIsPersistent(event);
        }
        return this.entityIsTransient(event);
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        if (event.getRequestedId() == null) {
            return super.saveWithGeneratedOrRequestedId(event);
        }
        return this.saveWithRequestedId(event.getEntity(), event.getRequestedId(), event.getEntityName(), null, event.getSource());
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionEventSource source) {
        if (!Hibernate.isInitialized(object)) {
            throw new PersistentObjectException("uninitialized proxy passed to save()");
        }
        return false;
    }
}

