/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractSaveEventListener;
import org.hibernate.event.OnUpdateVisitor;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultSaveOrUpdateEventListener == null ? (class$org$hibernate$event$DefaultSaveOrUpdateEventListener = DefaultSaveOrUpdateEventListener.class$("org.hibernate.event.DefaultSaveOrUpdateEventListener")) : class$org$hibernate$event$DefaultSaveOrUpdateEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultSaveOrUpdateEventListener;

    public Serializable onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        SessionEventSource source = event.getSource();
        Object object = event.getObject();
        Serializable requestedId = event.getRequestedId();
        if (requestedId != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(requestedId);
        }
        if (this.reassociateIfUninitializedProxy(object, source)) {
            log.trace((Object)"reassociated uninitialized proxy");
            return null;
        }
        Object entity = source.unproxyAndReassociate(object);
        event.setEntity(entity);
        event.setEntry(source.getEntry(entity));
        return this.performSaveOrUpdate(event);
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionEventSource source) {
        return source.reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        int entityState = this.getEntityState(event.getEntity(), event.getEntityName(), event.getEntry(), event.getSource());
        switch (entityState) {
            case 2: {
                this.entityIsDetached(event);
                return null;
            }
            case 0: {
                return this.entityIsPersistent(event);
            }
        }
        return this.entityIsTransient(event);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent event) throws HibernateException {
        Serializable savedId;
        log.trace((Object)"ignoring persistent instance");
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            savedId = entityEntry.getId();
        } else {
            if (!requestedId.equals(entityEntry.getId())) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString((EntityPersister)entityEntry.getPersister(), (Serializable)requestedId));
            }
            savedId = requestedId;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object already associated with session with id: " + savedId));
        }
        return savedId;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent event) throws HibernateException {
        log.trace((Object)"saving transient instance");
        SessionEventSource source = event.getSource();
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                source.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable id = this.saveWithGeneratedOrRequestedId(event);
        source.reassociateProxy(event.getObject(), id);
        return id;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        return this.saveWithGeneratedId(event.getEntity(), event.getEntityName(), null, event.getSource());
    }

    protected void entityIsDetached(SaveOrUpdateEvent event) throws HibernateException {
        log.trace((Object)"updating detached instance");
        if (event.getSource().isEntryFor(event.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object entity = event.getEntity();
        EntityPersister persister = event.getSource().getEntityPersister(event.getEntityName(), entity);
        event.setRequestedId(this.getUpdateId(entity, persister, event.getRequestedId()));
        this.performUpdate(event, entity, persister);
    }

    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId) throws HibernateException {
        Serializable id = persister.getIdentifier(entity);
        if (id == null) {
            throw new TransientObjectException("The given object has a null identifier: " + MessageHelper.infoString((EntityPersister)persister));
        }
        return id;
    }

    protected void performUpdate(SaveOrUpdateEvent event, Object entity, EntityPersister persister) throws HibernateException {
        if (!persister.isMutable()) {
            log.trace((Object)"immutable instance passed to doUpdate(), locking");
            this.reassociate(event, entity, event.getRequestedId(), persister);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString((EntityPersister)persister, (Serializable)event.getRequestedId())));
            }
            SessionEventSource source = event.getSource();
            source.checkUniqueness(event.getRequestedId(), persister, entity);
            if (persister.implementsLifecycle()) {
                log.debug((Object)"calling onUpdate()");
                if (((Lifecycle)entity).onUpdate(source)) {
                    log.debug((Object)"update vetoed by onUpdate()");
                    this.reassociate(event, event.getObject(), event.getRequestedId(), persister);
                    return;
                }
            }
            new OnUpdateVisitor(source, event.getRequestedId()).process(entity, persister);
            source.addEntity(entity, Status.MANAGED, null, event.getRequestedId(), persister.getVersion(entity), LockMode.NONE, true, persister, false);
            persister.afterReassociate(entity, source);
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString((EntityPersister)persister, (Serializable)event.getRequestedId())));
            }
            this.cascadeOnUpdate(event, persister, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent event, EntityPersister persister, Object entity) {
        SessionEventSource source = event.getSource();
        source.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)Cascades.ACTION_SAVE_UPDATE, (int)0);
        }
        finally {
            source.decrementCascadeLevel();
        }
    }

    protected Cascades.CascadingAction getCascadeAction() {
        return Cascades.ACTION_SAVE_UPDATE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

