/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.event.AbstractVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.CollectionEntry;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public class EvictVisitor
extends AbstractVisitor {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$EvictVisitor == null ? (class$org$hibernate$event$EvictVisitor = EvictVisitor.class$("org.hibernate.event.EvictVisitor")) : class$org$hibernate$event$EvictVisitor));
    static /* synthetic */ Class class$org$hibernate$event$EvictVisitor;

    EvictVisitor(SessionEventSource session) {
        super(session);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, type);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void evictCollection(Object value, CollectionType type) {
        void var3_3;
        Object pc;
        if (type.isArrayType()) {
            pc = this.getSession().removeArrayHolder(value);
        } else if (value instanceof PersistentCollection) {
            pc = value;
        } else {
            return;
        }
        PersistentCollection collection = (PersistentCollection)var3_3;
        if (collection.unsetSession(this.getSession())) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.getSession().getCollectionEntries().remove(collection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("evicting collection: " + MessageHelper.infoString((CollectionPersister)ce.getLoadedPersister(), (Serializable)ce.getLoadedKey())));
        }
        if (ce.getLoadedPersister() != null && ce.getLoadedKey() != null) {
            this.getSession().getCollectionsByKey().remove(new CollectionKey(ce.getLoadedPersister(), ce.getLoadedKey()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

