/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.event.ReattachVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.type.CollectionType;

public class OnLockVisitor
extends ReattachVisitor {
    public OnLockVisitor(SessionEventSource session, Serializable key) {
        super(session, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        SessionEventSource session = this.getSession();
        CollectionPersister persister = session.getCollectionPersister(type.getRole());
        if (collection == null) return null;
        if (!(collection instanceof PersistentCollection)) throw new HibernateException("reassociated object has dirty collection reference (or an array)");
        PersistentCollection coll = (PersistentCollection)collection;
        if (!coll.setCurrentSession(session)) throw new HibernateException("reassociated object has dirty collection reference");
        CollectionSnapshot snapshot = coll.getCollectionSnapshot();
        if (!OnLockVisitor.isOwnerUnchanged(snapshot, persister, this.getKey())) throw new HibernateException("reassociated object has dirty collection reference");
        if (snapshot.getDirty()) {
            throw new HibernateException("reassociated object has dirty collection");
        }
        this.reattachCollection(coll, snapshot);
        return null;
    }
}

