/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.ReattachVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.type.CollectionType;

public class OnReplicateVisitor
extends ReattachVisitor {
    OnReplicateVisitor(SessionEventSource session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        SessionEventSource session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getCollectionPersister(type.getRole());
        session.removeCollection(persister, key);
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            wrapper.setCurrentSession(session);
            if (wrapper.wasInitialized()) {
                session.addNewCollection(wrapper, persister);
            } else {
                this.reattachCollection(wrapper, wrapper.getCollectionSnapshot());
            }
        }
        return null;
    }
}

