/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultAutoFlushEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean onAutoFlush(AutoFlushEvent event) throws HibernateException {
        boolean flushMightBeNeeded;
        SessionImplementor source = event.getSession();
        boolean bl = flushMightBeNeeded = !source.getFlushMode().lessThan(FlushMode.AUTO) && source.getDontFlushFromFind() == 0 && source.getPersistenceContext().hasNonReadOnlyEntities();
        if (flushMightBeNeeded) {
            boolean flushIsReallyNeeded;
            int oldSize = source.getActionQueue().numberOfCollectionRemovals();
            this.flushEverythingToExecutions(event);
            boolean bl2 = flushIsReallyNeeded = source.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces()) || source.getFlushMode() == FlushMode.ALWAYS;
            if (flushIsReallyNeeded) {
                log.trace((Object)"Need to execute flush");
                this.performExecutions(source);
                this.postFlush(source);
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().flush();
                }
            } else {
                log.trace((Object)"Dont need to execute flush");
                source.getActionQueue().clearFromFlushNeededCheck(oldSize);
            }
            return flushIsReallyNeeded;
        }
        return false;
    }
}

