/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.CallbackException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.def.AbstractEventListener;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultDeleteEventListener
extends AbstractEventListener
implements DeleteEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultDeleteEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void onDelete(DeleteEvent event) throws HibernateException {
        Object version;
        Serializable id;
        EntityPersister persister;
        Object entity;
        SessionImplementor source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity = persistenceContext.unproxyAndReassociate(event.getObject()));
        if (entityEntry == null) {
            log.trace((Object)"deleting a transient instance");
            persister = source.getEntityPersister(event.getEntityName(), entity);
            id = persister.getIdentifier(entity, source.getEntityMode());
            if (id == null) {
                throw new TransientObjectException("the transient instance passed to delete() had a null identifier");
            }
            persistenceContext.checkUniqueness(id, persister, entity);
            new OnUpdateVisitor(source, id).process(entity, persister);
            version = persister.getVersion(entity, source.getEntityMode());
            entityEntry = persistenceContext.addEntity(entity, Status.MANAGED, persister.getPropertyValues(entity, source.getEntityMode()), id, version, LockMode.NONE, true, persister, false);
        } else {
            log.trace((Object)"deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                log.trace((Object)"object was already deleted");
                return;
            }
            persister = entityEntry.getPersister();
            id = entityEntry.getId();
            version = entityEntry.getVersion();
        }
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to delete an object of immutable class: " + MessageHelper.infoString(persister));
        }
        this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), persister);
        if (source.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            persister.resetIdentifier(entity, id, version, source.getEntityMode());
        }
    }

    protected final void deleteEntity(SessionImplementor session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, EntityPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + MessageHelper.infoString(persister, entityEntry.getId(), session.getFactory())));
        }
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getPropertyValues(entity, session.getEntityMode()) : entityEntry.getLoadedState();
        Object[] deletedState = new Object[propTypes.length];
        TypeFactory.deepCopy(currentState, propTypes, persister.getPropertyUpdateability(), deletedState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, persister.getPropertyNames(), propTypes);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = new EntityKey(entityEntry.getId(), persister, session.getEntityMode());
        HashSet nullifiablesAfterOnDelete = null;
        List suspendedDeletions = null;
        if (persister.implementsLifecycle(session.getEntityMode())) {
            HashSet oldNullifiables = (HashSet)persistenceContext.getNullifiableEntityKeys().clone();
            ArrayList oldDeletions = session.getActionQueue().cloneDeletions();
            persistenceContext.getNullifiableEntityKeys().add(key);
            try {
                log.debug((Object)"calling onDelete()");
                if (((Lifecycle)entity).onDelete(session)) {
                    persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
                    entityEntry.setDeletedState(null);
                    persistenceContext.setNullifiableEntityKeys(oldNullifiables);
                    log.debug((Object)"deletion vetoed by onDelete()");
                    return;
                }
            }
            catch (CallbackException ce) {
                persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
                entityEntry.setDeletedState(null);
                persistenceContext.setNullifiableEntityKeys(oldNullifiables);
                throw ce;
            }
            if (oldDeletions.size() > session.getActionQueue().numberOfDeletions()) {
                throw new HibernateException("session was flushed during onDelete()");
            }
            suspendedDeletions = session.getActionQueue().suspendNewDeletions(oldDeletions);
            nullifiablesAfterOnDelete = persistenceContext.getNullifiableEntityKeys();
            persistenceContext.setNullifiableEntityKeys(oldNullifiables);
        }
        this.cascadeBeforeDelete(session, persister, entity, entityEntry);
        new ForeignKeys.Nullifier(entity, true, false, session).nullifyTransientReferences(entityEntry.getDeletedState(), propTypes);
        new Nullability(session).checkNullability(entityEntry.getDeletedState(), persister, true);
        persistenceContext.getNullifiableEntityKeys().add(key);
        session.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, session));
        if (persister.implementsLifecycle(session.getEntityMode())) {
            persistenceContext.getNullifiableEntityKeys().addAll(nullifiablesAfterOnDelete);
            session.getActionQueue().resumeSuspendedDeletions(suspendedDeletions);
        }
        this.cascadeAfterDelete(session, persister, entity);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cascadeBeforeDelete(SessionImplementor session, EntityPersister persister, Object entity, EntityEntry entityEntry) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(session, persister, entity, Cascades.ACTION_DELETE, 1);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
            throw throwable;
        }
        {
            Object var6_8 = null;
            session.getPersistenceContext().decrementCascadeLevel();
        }
        session.setCacheMode(cacheMode);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cascadeAfterDelete(SessionImplementor session, EntityPersister persister, Object entity) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(session, persister, entity, Cascades.ACTION_DELETE, 2);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
            throw throwable;
        }
        {
            Object var5_7 = null;
            session.getPersistenceContext().decrementCascadeLevel();
        }
        session.setCacheMode(cacheMode);
    }
}

