/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.def.AbstractEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultEvictEventListener
extends AbstractEventListener
implements EvictEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultEvictEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void onEvict(EvictEvent event) throws HibernateException {
        SessionImplementor source = event.getSession();
        Object object = event.getObject();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        if (object instanceof HibernateProxy) {
            Object entity;
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            Serializable id = li.getIdentifier();
            EntityPersister persister = source.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            persistenceContext.removeProxy(key);
            if (!li.isUninitialized() && (entity = persistenceContext.removeEntity(key)) != null) {
                EntityEntry e = event.getSession().getPersistenceContext().removeEntry(entity);
                this.doEvict(entity, key, e.getPersister(), event.getSession());
            }
        } else {
            EntityEntry e = persistenceContext.removeEntry(object);
            if (e != null) {
                EntityKey key = new EntityKey(e.getId(), e.getPersister(), source.getEntityMode());
                persistenceContext.removeEntity(key);
                this.doEvict(object, key, e.getPersister(), source);
            }
        }
    }

    protected void doEvict(Object object, EntityKey key, EntityPersister persister, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("evicting " + MessageHelper.infoString(persister)));
        }
        if (persister.hasCollections()) {
            new EvictVisitor(session).process(object, persister);
        }
        Cascades.cascade(session, persister, object, Cascades.ACTION_EVICT, 0);
    }
}

