/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.def.AbstractEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
extends AbstractEventListener
implements InitializeCollectionEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultInitializeCollectionEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        SessionImplementor source = event.getSession();
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!ce.isInitialized()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), source.getFactory())));
            }
            log.trace((Object)"checking second-level cache");
            boolean foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedPersister(), collection, source);
            if (foundInCache) {
                log.trace((Object)"collection initialized from cache");
            } else {
                log.trace((Object)"collection not cached");
                ce.getLoadedPersister().initialize(ce.getLoadedKey(), source);
                log.trace((Object)"collection initialized");
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().fetchCollection(ce.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable id, CollectionPersister persister, PersistentCollection collection, SessionImplementor source) throws HibernateException {
        boolean useCache;
        if (!source.getEnabledFilters().isEmpty() && persister.isAffectedByEnabledFilters(source)) {
            log.trace((Object)"disregarding cached version (if any) of collection due to enabled filters ");
            return false;
        }
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        Object ce = persister.getCache().get(new CacheKey(id, persister.getKeyType(), persister.getRole(), source.getEntityMode()), source.getTimestamp());
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCache().getRegionName());
            } else {
                factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCache().getRegionName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(id, persister));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }
}

