/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultSaveOrUpdateEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Serializable onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        SessionImplementor source = event.getSession();
        Object object = event.getObject();
        Serializable requestedId = event.getRequestedId();
        if (requestedId != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(requestedId);
        }
        if (this.reassociateIfUninitializedProxy(object, source)) {
            log.trace((Object)"reassociated uninitialized proxy");
            return null;
        }
        Object entity = source.getPersistenceContext().unproxyAndReassociate(object);
        event.setEntity(entity);
        event.setEntry(source.getPersistenceContext().getEntry(entity));
        return this.performSaveOrUpdate(event);
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor source) {
        return source.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        int entityState = this.getEntityState(event.getEntity(), event.getEntityName(), event.getEntry(), event.getSession());
        switch (entityState) {
            case 2: {
                this.entityIsDetached(event);
                return null;
            }
            case 0: {
                return this.entityIsPersistent(event);
            }
        }
        return this.entityIsTransient(event);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent event) throws HibernateException {
        Serializable savedId;
        log.trace((Object)"ignoring persistent instance");
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor factory = event.getSession().getFactory();
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            savedId = entityEntry.getId();
        } else {
            boolean isEqual;
            boolean bl = isEqual = !entityEntry.getPersister().getIdentifierType().isEqual(requestedId, entityEntry.getId(), event.getSession().getEntityMode(), factory);
            if (isEqual) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getPersister(), requestedId, factory));
            }
            savedId = requestedId;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object already associated with session: " + MessageHelper.infoString(entityEntry.getPersister(), savedId, factory)));
        }
        return savedId;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent event) throws HibernateException {
        log.trace((Object)"saving transient instance");
        SessionImplementor source = event.getSession();
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                source.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable id = this.saveWithGeneratedOrRequestedId(event);
        source.getPersistenceContext().reassociateProxy(event.getObject(), id);
        return id;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        return this.saveWithGeneratedId(event.getEntity(), event.getEntityName(), null, event.getSession());
    }

    protected void entityIsDetached(SaveOrUpdateEvent event) throws HibernateException {
        log.trace((Object)"updating detached instance");
        if (event.getSession().getPersistenceContext().isEntryFor(event.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object entity = event.getEntity();
        EntityPersister persister = event.getSession().getEntityPersister(event.getEntityName(), entity);
        event.setRequestedId(this.getUpdateId(entity, persister, event.getRequestedId(), event.getSession().getEntityMode()));
        this.performUpdate(event, entity, persister);
    }

    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId, EntityMode entityMode) throws HibernateException {
        Serializable id = persister.getIdentifier(entity, entityMode);
        if (id == null) {
            throw new TransientObjectException("The given object has a null identifier: " + persister.getEntityName());
        }
        return id;
    }

    protected void performUpdate(SaveOrUpdateEvent event, Object entity, EntityPersister persister) throws HibernateException {
        if (!persister.isMutable()) {
            log.trace((Object)"immutable instance passed to doUpdate(), locking");
            this.reassociate(event, entity, event.getRequestedId(), persister);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString(persister, event.getRequestedId(), event.getSession().getFactory())));
            }
            SessionImplementor source = event.getSession();
            source.getPersistenceContext().checkUniqueness(event.getRequestedId(), persister, entity);
            if (persister.implementsLifecycle(source.getEntityMode())) {
                log.debug((Object)"calling onUpdate()");
                if (((Lifecycle)entity).onUpdate(source)) {
                    log.debug((Object)"update vetoed by onUpdate()");
                    this.reassociate(event, event.getObject(), event.getRequestedId(), persister);
                    return;
                }
            }
            new OnUpdateVisitor(source, event.getRequestedId()).process(entity, persister);
            source.getPersistenceContext().addEntity(entity, Status.MANAGED, null, event.getRequestedId(), persister.getVersion(entity, source.getEntityMode()), LockMode.NONE, true, persister, false);
            persister.afterReassociate(entity, source);
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString(persister, event.getRequestedId(), source.getFactory())));
            }
            this.cascadeOnUpdate(event, persister, entity);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent event, EntityPersister persister, Object entity) {
        SessionImplementor source = event.getSession();
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(source, persister, entity, Cascades.ACTION_SAVE_UPDATE, 0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            source.getPersistenceContext().decrementCascadeLevel();
            throw throwable;
        }
        {
            Object var5_7 = null;
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Cascades.CascadingAction getCascadeAction() {
        return Cascades.ACTION_SAVE_UPDATE;
    }
}

