/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.event.def.ReattachVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(SessionImplementor session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        SessionImplementor session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getFactory().getCollectionPersister(type.getRole());
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            if (wrapper.setCurrentSession(session)) {
                CollectionSnapshot snapshot = wrapper.getCollectionSnapshot();
                if (!ProxyVisitor.isOwnerUnchanged(snapshot, persister, key)) {
                    this.removeCollection(persister, key, session);
                }
                this.reattachCollection(wrapper, snapshot);
            } else {
                this.removeCollection(persister, key, session);
            }
        } else {
            this.removeCollection(persister, key, session);
        }
        return null;
    }
}

