/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QuerySyntaxError;

public class ErrorCounter
implements ParseErrorHandler {
    private Log log;
    private Log hqlLog;
    private List errorList;
    private List warningList;
    private List recognitionExceptions;
    static /* synthetic */ Class class$0;

    public ErrorCounter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.ErrorCounter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.hqlLog = LogFactory.getLog((String)"org.hibernate.hql.PARSER");
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.recognitionExceptions = new ArrayList();
    }

    public void reportError(RecognitionException e) {
        this.reportError(e.toString());
        this.recognitionExceptions.add(e);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)e, (Throwable)e);
        }
    }

    public void reportError(String s) {
        String message = "*** ERROR: " + s;
        this.hqlLog.error((Object)message);
        this.errorList.add(message);
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public void reportWarning(String s) {
        String message = "*** WARNING: " + s;
        this.hqlLog.warn((Object)message);
        this.warningList.add(message);
    }

    private String getErrorString() {
        StringBuffer buf = new StringBuffer();
        Iterator iterator = this.errorList.iterator();
        while (iterator.hasNext()) {
            buf.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public void throwQueryException() throws QueryException {
        if (this.getErrorCount() > 0) {
            if (this.recognitionExceptions.size() > 0) {
                throw new QuerySyntaxError((RecognitionException)((Object)this.recognitionExceptions.get(0)));
            }
            throw new QueryException(this.getErrorString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"throwQueryException() : no errors");
        }
    }
}

