/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.SelectClause;
import org.hibernate.impl.IteratorImpl;
import org.hibernate.loader.Loader;
import org.hibernate.persister.Loadable;
import org.hibernate.persister.Queryable;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

class QueryLoader
extends Loader {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$QueryLoader == null ? (class$org$hibernate$hql$ast$QueryLoader = QueryLoader.class$("org.hibernate.hql.ast.QueryLoader")) : class$org$hibernate$hql$ast$QueryLoader));
    private QueryTranslatorImpl queryTranslator;
    private Queryable[] entityPersisters;
    private String[] entityAliases;
    private String[] sqlAliases;
    private String[] sqlAliasSuffixes;
    private boolean[] includeInSelect;
    private boolean hasScalars;
    private String[][] scalarColumnNames;
    private Type[] sqlResultTypes;
    private Type[] queryReturnTypes;
    private String[] uniqueKeyReferences;
    private int[] owners;
    private int collectionOwner = -1;
    private QueryableCollection collectionPersister;
    private int selectLength;
    private Constructor holderConstructor;
    static /* synthetic */ Class class$org$hibernate$hql$ast$QueryLoader;

    public QueryLoader(QueryTranslatorImpl queryTranslator, SessionFactoryImplementor factory, SelectClause selectClause) {
        super(factory);
        this.queryTranslator = queryTranslator;
        this.initialize(selectClause);
        this.postInstantiate();
    }

    private void initialize(SelectClause selectClause) {
        List fromElementList = selectClause.getFromElementsForLoad();
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumnNames = selectClause.getColumnNames();
        this.sqlResultTypes = selectClause.getSqlResultTypes();
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.holderConstructor = selectClause.getConstructor();
        int size = fromElementList.size();
        this.entityPersisters = new Queryable[size];
        this.entityAliases = new String[size];
        this.sqlAliases = new String[size];
        this.sqlAliasSuffixes = new String[size];
        this.includeInSelect = new boolean[size];
        this.owners = new int[size];
        this.uniqueKeyReferences = new String[size];
        for (int i = 0; i < size; ++i) {
            FromElement element = (FromElement)fromElementList.get(i);
            this.entityPersisters[i] = (Queryable)element.getEntityPersister();
            if (this.entityPersisters[i] == null) {
                throw new IllegalStateException("No entity persister for " + element.toString());
            }
            this.sqlAliases[i] = element.getTableAlias();
            this.entityAliases[i] = element.getClassAlias();
            this.sqlAliasSuffixes[i] = size == 1 ? "" : Integer.toString(i) + "_";
            boolean bl = this.includeInSelect[i] = !element.isFetch();
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            if (!element.isFetch()) continue;
            if (element.isCollectionJoin() || element.getQueryableCollection() != null) {
                if (this.collectionPersister != null) continue;
                this.collectionPersister = element.getQueryableCollection();
                this.collectionOwner = fromElementList.indexOf(element.getOrigin());
                continue;
            }
            if (!element.getDataType().isEntityType()) continue;
            EntityType entityType = (EntityType)element.getDataType();
            if (entityType.isOneToOne()) {
                this.owners[i] = fromElementList.indexOf(element.getOrigin());
            }
            this.uniqueKeyReferences[i] = entityType.getRHSUniqueKeyPropertyName();
        }
    }

    public Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    public String[] getEntityAliases() {
        return this.entityAliases;
    }

    public String[] getAliases() {
        return this.getEntityAliases();
    }

    public String[] getSqlAliases() {
        return this.sqlAliases;
    }

    public String[] getSqlAliasSuffixes() {
        return this.sqlAliasSuffixes;
    }

    public String[] getSuffixes() {
        return this.getSqlAliasSuffixes();
    }

    protected String getQueryIdentifier() {
        return this.queryTranslator.getQueryString();
    }

    protected String getSQLString() {
        return this.queryTranslator.getSQLString();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected int getCollectionOwner() {
        return this.collectionOwner;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected String[] getUniqueKeyReferences() {
        return this.uniqueKeyReferences;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        HashMap nameLockModes = new HashMap();
        if (lockModes != null) {
            Iterator iter = lockModes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                nameLockModes.put(this.getAliasName((String)me.getKey()), me.getValue());
            }
        }
        LockMode[] lockModeArray = new LockMode[this.entityAliases.length];
        for (int i = 0; i < this.entityAliases.length; ++i) {
            LockMode lm = (LockMode)nameLockModes.get(this.entityAliases[i]);
            if (lm == null) {
                lm = LockMode.NONE;
            }
            lockModeArray[i] = lm;
        }
        return lockModeArray;
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i] + start) + "]"));
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sql;
        }
        HashMap aliasedLockModes = new HashMap();
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            aliasedLockModes.put(this.getAliasName((String)me.getKey()), me.getValue());
        }
        HashMap<String, String[]> keyColumnNames = null;
        if (dialect.forUpdateOfColumns()) {
            Loadable[] persisters = this.getEntityPersisters();
            keyColumnNames = new HashMap<String, String[]>();
            for (int i = 0; i < this.sqlAliases.length; ++i) {
                keyColumnNames.put(this.sqlAliases[i], persisters[i].getIdentifierColumnNames());
            }
        }
        return sql + new ForUpdateFragment(dialect, aliasedLockModes, keyColumnNames).toFragmentString();
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        row = this.toResultRow(row);
        if (this.hasScalars) {
            String[][] scalarColumns = this.scalarColumnNames;
            int queryCols = this.sqlResultTypes.length;
            if (this.holderConstructor == null && queryCols == 1) {
                return this.sqlResultTypes[0].nullSafeGet(rs, scalarColumns[0], session, null);
            }
            row = new Object[queryCols];
            for (int i = 0; i < queryCols; ++i) {
                row[i] = this.sqlResultTypes[i].nullSafeGet(rs, scalarColumns[i], session, null);
            }
            return row;
        }
        if (this.holderConstructor == null) {
            return row.length == 1 ? row[0] : row;
        }
        return row;
    }

    protected List getResultList(List results) throws QueryException {
        if (this.holderConstructor != null) {
            for (int i = 0; i < results.size(); ++i) {
                Object[] row = (Object[])results.get(i);
                try {
                    results.set(i, this.holderConstructor.newInstance(row));
                    continue;
                }
                catch (Exception e) {
                    throw new QueryException("could not instantiate: " + this.holderConstructor.getDeclaringClass().getName(), e);
                }
            }
        }
        return results;
    }

    List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.queryTranslator.getQuerySpaces(), this.queryReturnTypes);
    }

    Iterator iterate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            PreparedStatement st = this.prepareQueryStatement(queryParameters, false, session);
            ResultSet rs = this.getResultSet(st, queryParameters.getRowSelection(), session);
            IteratorImpl result = new IteratorImpl(rs, st, session, this.sqlResultTypes, this.queryTranslator.getColumnNames(), this.holderConstructor == null ? null : this.holderConstructor.getDeclaringClass());
            if (stats) {
                session.getFactory().getStatisticsImplementor().queryExecuted("HQL: " + this.queryTranslator.getQueryString(), 0, System.currentTimeMillis() - startTime);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not execute query using iterate", this.getSQLString());
        }
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.sqlResultTypes, null, session);
    }

    private Object[] toResultRow(Object[] row) {
        if (this.selectLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.selectLength];
        int j = 0;
        for (int i = 0; i < row.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            result[j++] = row[i];
        }
        return result;
    }

    private int[] getNamedParameterLocs(String name) throws QueryException {
        return this.queryTranslator.getNamedParameterLocs(name);
    }

    private String getAliasName(String alias) {
        return this.queryTranslator.getAliasName(alias);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

