/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ANTLRException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.QueryNode;
import org.hibernate.hql.ast.QuerySyntaxError;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.UpdateStatementExecutor;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.type.Type;

public class QueryTranslatorImpl
implements FilterTranslator {
    private static final Log log;
    private static final Log AST_LOG;
    private String hql;
    private boolean shallowQuery;
    private Map tokenReplacements;
    private Map enabledFilters;
    private SessionFactoryImplementor factory;
    private boolean compiled;
    private QueryLoader queryLoader;
    private UpdateStatementExecutor updateStatementExecutor;
    private QueryNode sqlAst;
    private String sql;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.QueryTranslatorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        AST_LOG = LogFactory.getLog((String)"org.hibernate.hql.AST");
    }

    public QueryTranslatorImpl(String query, Map enabledFilters, SessionFactoryImplementor factory) {
        this.hql = query;
        this.compiled = false;
        this.shallowQuery = false;
        this.enabledFilters = enabledFilters;
        this.factory = factory;
    }

    public void compile(Map replacements, boolean shallow) throws QueryException, MappingException {
        this.doCompile(replacements, shallow, null);
    }

    public void compile(String collectionRole, Map replacements, boolean shallow) throws QueryException, MappingException {
        this.doCompile(replacements, shallow, collectionRole);
    }

    private synchronized void doCompile(Map replacements, boolean shallow, String collectionRole) {
        if (this.compiled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"compile() : The query is already compiled, skipping...");
            }
            return;
        }
        this.tokenReplacements = replacements;
        if (this.tokenReplacements == null) {
            this.tokenReplacements = new HashMap();
        }
        this.shallowQuery = shallow;
        try {
            HqlParser parser = this.parse(true);
            HqlSqlWalker w = this.analyze(parser, collectionRole);
            this.sqlAst = (QueryNode)w.getAST();
            this.generate((AST)this.sqlAst);
            if (this.sqlAst.isDML()) {
                this.updateStatementExecutor = new UpdateStatementExecutor(this.sql, this.getWalker(), this.factory);
            } else {
                this.queryLoader = new QueryLoader(this, this.factory, w.getSelectClause());
            }
            this.compiled = true;
        }
        catch (QueryException qe) {
            qe.setQueryString(this.hql);
            throw qe;
        }
        catch (RecognitionException e) {
            throw new QuerySyntaxError(e, this.hql);
        }
        catch (ANTLRException e) {
            QueryException qe = new QueryException(e.getMessage(), e);
            qe.setQueryString(this.hql);
            throw qe;
        }
    }

    private void generate(AST sqlAst) throws QueryException, RecognitionException {
        if (this.sql == null) {
            SqlGenerator gen = new SqlGenerator();
            gen.statement(sqlAst);
            this.sql = gen.getSQL();
            if (log.isDebugEnabled()) {
                log.debug((Object)("HQL: " + this.hql));
                log.debug((Object)("SQL: " + this.sql));
            }
            gen.getParseErrorHandler().throwQueryException();
        }
    }

    private HqlSqlWalker analyze(HqlParser parser, String collectionRole) throws QueryException, RecognitionException {
        HqlSqlWalker w = new HqlSqlWalker(this, this.factory, parser, this.tokenReplacements, collectionRole);
        AST hqlAst = parser.getAST();
        w.statement(hqlAst);
        if (AST_LOG.isDebugEnabled()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.hibernate.hql.antlr.SqlTokenTypes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            QueryTranslatorImpl.logAst("--- SQL AST ---", clazz, w.getAST());
        }
        w.getParseErrorHandler().throwQueryException();
        return w;
    }

    private HqlParser parse(boolean filter) throws TokenStreamException, RecognitionException {
        HqlParser parser = HqlParser.getInstance(this.hql);
        parser.setFilter(filter);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse() - HQL: " + this.hql));
        }
        parser.statement();
        AST hqlAst = parser.getAST();
        this.showHqlAst(hqlAst);
        parser.getParseErrorHandler().throwQueryException();
        return parser;
    }

    void showHqlAst(AST hqlAst) {
        if (AST_LOG.isDebugEnabled()) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.hibernate.hql.antlr.HqlTokenTypes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            QueryTranslatorImpl.logAst("--- HQL AST ---", clazz, hqlAst);
        }
    }

    private static void logAst(String header, Class tokenTypeConstants, AST ast) {
        ASTPrinter printer = new ASTPrinter(tokenTypeConstants);
        AST_LOG.debug((Object)printer.showAsString(ast, header));
    }

    private void errorIfDML() throws HibernateException {
        if (this.sqlAst.isDML()) {
            throw new HibernateException("Not supported for DML operations");
        }
    }

    private void errorIfSelect() throws HibernateException {
        if (!this.sqlAst.isDML()) {
            throw new HibernateException("Not supported for select queries");
        }
    }

    private HqlSqlWalker getWalker() {
        return this.sqlAst.getWalker();
    }

    public Type[] getReturnTypes() {
        this.errorIfDML();
        return this.getWalker().getReturnTypes();
    }

    public String[][] getColumnNames() {
        this.errorIfDML();
        return this.getWalker().getSelectClause().getColumnNames();
    }

    public Set getQuerySpaces() {
        return this.getWalker().getQuerySpaces();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.list(session, queryParameters);
    }

    public Iterator iterate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.iterate(queryParameters, session);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.scroll(queryParameters, session);
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.errorIfSelect();
        return this.updateStatementExecutor.execute(queryParameters, session);
    }

    public String getSQLString() {
        return this.sql;
    }

    boolean isShallowQuery() {
        return this.shallowQuery;
    }

    public String getQueryString() {
        return this.hql;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    public int[] getNamedParameterLocs(String name) {
        return this.getWalker().getNamedParameterLocs(name);
    }
}

