/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.QueryNode;
import org.hibernate.hql.ast.SqlFragment;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final Log log;
    private ASTFactory astFactory;
    private AST thetaJoins;
    private AST filters;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.SyntheticAndFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SyntheticAndFactory(ASTFactory astFactory) {
        this.astFactory = astFactory;
    }

    void addWhereFragment(JoinFragment joinFragment, String whereFragment, QueryNode query, FromElement fromElement) {
        if (whereFragment != null) {
            whereFragment = whereFragment.trim();
        }
        if (StringHelper.isEmpty(whereFragment)) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using WHERE fragment [" + whereFragment + "]"));
        }
        SqlFragment fragment = (SqlFragment)ASTUtil.create(this.astFactory, 123, whereFragment);
        fragment.setJoinFragment(joinFragment);
        fragment.setFromElement(fromElement);
        if (fragment.getFromElement().isFilter() || fragment.hasFilterCondition()) {
            if (this.filters == null) {
                AST where = query.getWhereClause();
                this.filters = this.astFactory.create(127, "{filter conditions}");
                ASTUtil.insertChild(where, this.filters);
            }
            this.filters.addChild((AST)fragment);
        } else {
            if (this.thetaJoins == null) {
                AST where = query.getWhereClause();
                this.thetaJoins = this.astFactory.create(126, "{theta joins}");
                if (where.getFirstChild() == null) {
                    where.setFirstChild(this.thetaJoins);
                } else {
                    where.addChild(this.thetaJoins);
                }
            }
            ASTUtil.insertChild(this.thetaJoins, (AST)fragment);
        }
    }

    public void addDiscriminatorWhereFragment(QueryNode query, SingleTableEntityPersister persister, String alias) {
        String whereFragment = persister.filterFragment(alias).trim();
        if ("".equals(whereFragment)) {
            return;
        }
        if (whereFragment.startsWith("and")) {
            whereFragment = whereFragment.substring(4);
        }
        AST subtree = this.parseEqFragmentToSubtree(whereFragment);
        if (query.getWhereClause().getFirstChild() == null) {
            query.getWhereClause().setFirstChild(subtree);
        } else {
            AST and = this.astFactory.create(6, "{and}");
            AST currentFirstChild = query.getWhereClause().getFirstChild();
            and.setFirstChild(subtree);
            and.addChild(currentFirstChild);
            query.getWhereClause().setFirstChild(and);
        }
    }

    private AST parseEqFragmentToSubtree(String whereFragment) {
        int chunkPos = whereFragment.lastIndexOf("=");
        String check = whereFragment.substring(0, chunkPos).trim();
        String test = whereFragment.substring(chunkPos + 1).trim();
        AST eq = this.astFactory.create(86, "{discriminator}");
        eq.setFirstChild(this.astFactory.create(109, check));
        eq.addChild(this.astFactory.create(123, test));
        return eq;
    }
}

