/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.type.Type;

public class UpdateStatementExecutor {
    private static final Log log;
    private String sql;
    private HqlSqlWalker walker;
    private SessionFactoryImplementor factory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.UpdateStatementExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public UpdateStatementExecutor(String sql, HqlSqlWalker walker, SessionFactoryImplementor factory) {
        this.sql = sql;
        this.walker = walker;
        this.factory = factory;
    }

    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        PreparedStatement st = null;
        try {
            int n;
            block5: {
                try {
                    st = session.getBatcher().prepareStatement(this.sql);
                    int col = 1;
                    col += this.bindPositionalParameters(st, parameters, col, session);
                    col += this.bindNamedParameters(st, parameters.getNamedParameters(), col, session);
                    n = st.executeUpdate();
                    Object var5_7 = null;
                    if (st == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (st != null) {
                        session.getBatcher().closeStatement(st);
                    }
                    throw throwable;
                }
                session.getBatcher().closeStatement(st);
            }
            return n;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute update query", this.sql);
        }
    }

    private int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getPositionalParameterValues();
        Type[] types = queryParameters.getPositionalParameterTypes();
        int span = 0;
        int i = 0;
        while (i < values.length) {
            types[i].nullSafeSet(st, values[i], start + span, session);
            span += types[i].getColumnSpan(this.factory);
            ++i;
        }
        return span;
    }

    private int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.walker.getNamedParameterLocs(name);
                int i = 0;
                while (i < locs.length) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i] + start) + "]"));
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                    ++i;
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }
}

