/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class IdentifierGeneratorFactory {
    private static final Log log;
    private static final HashMap GENERATORS;
    public static final String SHORT_CIRCUIT_INDICATOR;
    public static final String POST_INSERT_INDICATOR;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.id.IdentifierGeneratorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        GENERATORS = new HashMap();
        SHORT_CIRCUIT_INDICATOR = new String();
        POST_INSERT_INDICATOR = new String();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.hibernate.id.UUIDHexGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("uuid", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.hibernate.id.TableHiLoGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("hilo", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.hibernate.id.Assigned");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("assigned", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.hibernate.id.IdentityGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("identity", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.hibernate.id.SelectGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("select", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.hibernate.id.SequenceGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("sequence", clazz7);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.hibernate.id.SequenceHiLoGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("seqhilo", clazz8);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.hibernate.id.IncrementGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("increment", clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.hibernate.id.ForeignGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("foreign", clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.hibernate.id.GUIDGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("guid", clazz11);
        Class<?> clazz12 = class$1;
        if (clazz12 == null) {
            try {
                clazz12 = class$1 = Class.forName("org.hibernate.id.UUIDHexGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GENERATORS.put("uuid.hex", clazz12);
    }

    public static Serializable getGeneratedIdentity(ResultSet rs, Type type) throws SQLException, HibernateException, IdentifierGenerationException {
        if (!rs.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable id = IdentifierGeneratorFactory.get(rs, type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Natively generated identity: " + id));
        }
        return id;
    }

    public static Serializable get(ResultSet rs, Type type) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new Long(rs.getLong(1));
        }
        Class<?> clazz3 = class$12;
        if (clazz3 == null) {
            try {
                clazz3 = class$12 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new Integer(rs.getInt(1));
        }
        Class<?> clazz4 = class$13;
        if (clazz4 == null) {
            try {
                clazz4 = class$13 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return new Short(rs.getShort(1));
        }
        Class<?> clazz5 = class$14;
        if (clazz5 == null) {
            try {
                clazz5 = class$14 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz5) {
            return rs.getString(1);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short or string");
    }

    public static IdentifierGenerator create(String strategy, Type type, Properties params, Dialect dialect) throws MappingException {
        try {
            IdentifierGenerator idgen;
            Class clazz = (Class)GENERATORS.get(strategy);
            if ("native".equals(strategy)) {
                clazz = dialect.getNativeIdentifierGeneratorClass();
            }
            if (clazz == null) {
                clazz = ReflectHelper.classForName(strategy);
            }
            if ((idgen = (IdentifierGenerator)clazz.newInstance()) instanceof Configurable) {
                ((Configurable)((Object)idgen)).configure(type, params, dialect);
            }
            return idgen;
        }
        catch (Exception e) {
            throw new MappingException("could not instantiate id generator", e);
        }
    }

    public static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new Long(value);
        }
        Class<?> clazz3 = class$12;
        if (clazz3 == null) {
            try {
                clazz3 = class$12 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new Integer((int)value);
        }
        Class<?> clazz4 = class$13;
        if (clazz4 == null) {
            try {
                clazz4 = class$13 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorFactory() {
    }
}

