/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentArrayHolder;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionCacheEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Subquery;
import org.hibernate.impl.CollectionEntry;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.MarkerObject;

public class PersistenceContext
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$impl$PersistenceContext == null ? (class$org$hibernate$impl$PersistenceContext = PersistenceContext.class$("org.hibernate.impl.PersistenceContext")) : class$org$hibernate$impl$PersistenceContext));
    public static final Object NO_ROW = new MarkerObject("NO_ROW");
    public static final Object MARKER = new MarkerObject("MARKER");
    private SessionImplementor session;
    private final Map entitiesByKey;
    private final Map entitiesByUniqueKey;
    private transient Map proxiesByKey;
    private final Map entitySnapshotsByKey;
    private transient Map entityEntries;
    private transient Map arrayHolders;
    private transient Map collectionEntries;
    private final Map collectionsByKey;
    private HashSet nullifiables = new HashSet();
    private final HashSet nonExists;
    private final HashSet uniqueKeyNonExists;
    private transient Map loadingCollections;
    private transient List nonlazyCollections;
    private transient Map batchLoadableEntityKeys;
    private transient Map subqueriesByEntityKey;
    private transient int cascading = 0;
    private transient int loadCounter = 0;
    private transient boolean flushing = false;
    private boolean hasNonReadOnlyEntities = false;
    static /* synthetic */ Class class$org$hibernate$impl$PersistenceContext;

    public PersistenceContext(SessionImplementor session) {
        this.session = session;
        this.entitiesByKey = new HashMap(50);
        this.entitiesByUniqueKey = new HashMap(10);
        this.proxiesByKey = new ReferenceMap(0, 2);
        this.entitySnapshotsByKey = new HashMap(10);
        this.nonExists = new HashSet(10);
        this.uniqueKeyNonExists = new HashSet(10);
        this.entityEntries = IdentityMap.instantiateSequenced(50);
        this.collectionEntries = IdentityMap.instantiateSequenced(30);
        this.collectionsByKey = new HashMap(30);
        this.arrayHolders = IdentityMap.instantiate(10);
        this.initTransientState();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object e;
        log.trace((Object)"deserializing persistent-context");
        ois.defaultReadObject();
        this.entityEntries = IdentityMap.deserialize(ois.readObject());
        this.collectionEntries = IdentityMap.deserialize(ois.readObject());
        this.arrayHolders = IdentityMap.deserialize(ois.readObject());
        this.initTransientState();
        this.proxiesByKey = new ReferenceMap(0, 2);
        Map map = (Map)ois.readObject();
        this.proxiesByKey.putAll(map);
        Iterator iter = this.collectionEntries.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                e = iter.next();
                ((PersistentCollection)e.getKey()).setCurrentSession(this.session);
                CollectionEntry ce = (CollectionEntry)e.getValue();
                if (ce.getRole() == null) continue;
                ce.setLoadedPersister(this.session.getFactory().getCollectionPersister(ce.getRole()));
            }
            catch (HibernateException he) {
                throw new InvalidObjectException(he.getMessage());
            }
        }
        iter = this.proxiesByKey.values().iterator();
        while (iter.hasNext()) {
            Map.Entry proxy = iter.next();
            if (proxy instanceof HibernateProxy) {
                ((HibernateProxy)((Object)proxy)).getHibernateLazyInitializer().setSession(this.session);
                continue;
            }
            iter.remove();
        }
        iter = this.entityEntries.entrySet().iterator();
        while (iter.hasNext()) {
            e = (EntityEntry)iter.next().getValue();
            try {
                ((EntityEntry)e).setPersister(this.session.getFactory().getEntityPersister(((EntityEntry)e).getEntityName()));
            }
            catch (MappingException me) {
                throw new InvalidObjectException(me.getMessage());
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        log.trace((Object)"serializing persistent-context");
        oos.defaultWriteObject();
        oos.writeObject(IdentityMap.serialize(this.entityEntries));
        oos.writeObject(IdentityMap.serialize(this.collectionEntries));
        oos.writeObject(IdentityMap.serialize(this.arrayHolders));
        HashMap map = new HashMap();
        map.putAll(this.proxiesByKey);
        oos.writeObject(map);
    }

    private void initTransientState() {
        this.batchLoadableEntityKeys = new SequencedHashMap(30);
        this.subqueriesByEntityKey = new HashMap(30);
        this.loadingCollections = new HashMap();
        this.nonlazyCollections = new ArrayList(20);
    }

    public void clear() {
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntries.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        this.proxiesByKey.clear();
        this.batchLoadableEntityKeys.clear();
        this.subqueriesByEntityKey.clear();
        this.nonExists.clear();
        this.uniqueKeyNonExists.clear();
        this.hasNonReadOnlyEntities = false;
    }

    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    public void setEntryStatus(EntityEntry entry, Status status) {
        entry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    public void afterTransactionCompletion(boolean success) {
        Iterator iter = this.entityEntries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).setLockMode(LockMode.NONE);
        }
    }

    public Object[] getDatabaseSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        EntityKey key = new EntityKey(id, persister);
        Object cached = this.entitySnapshotsByKey.get(key);
        if (cached != null) {
            return cached == NO_ROW ? null : (Object[])cached;
        }
        Object[] snapshot = persister.getDatabaseSnapshot(id, this.session);
        this.entitySnapshotsByKey.put(key, snapshot == null ? NO_ROW : snapshot);
        return snapshot;
    }

    public Object[] getCachedDatabaseSnapshot(EntityKey key) {
        return (Object[])this.entitySnapshotsByKey.get(key);
    }

    public void removeDatabaseSnapshot(EntityKey key) {
        this.entitySnapshotsByKey.remove(key);
    }

    public Subquery getSubquery(EntityKey key) {
        return (Subquery)this.subqueriesByEntityKey.get(key);
    }

    public void addSubquery(EntityKey key, Subquery subquery) {
        this.subqueriesByEntityKey.put(key, subquery);
    }

    public void clearSubqueries() {
        this.subqueriesByEntityKey.clear();
    }

    public void addEntity(EntityKey key, Object object) {
        this.entitiesByKey.put(key, object);
        this.batchLoadableEntityKeys.remove(key);
    }

    public Object getEntity(EntityKey key) {
        return this.entitiesByKey.get(key);
    }

    public boolean containsEntity(EntityKey key) {
        return this.entitiesByKey.containsKey(key);
    }

    public Object removeEntity(EntityKey key) {
        return this.entitiesByKey.remove(key);
    }

    public Object getEntity(EntityUniqueKey euk) {
        return this.entitiesByUniqueKey.get(euk);
    }

    public void addEntity(EntityUniqueKey euk, Object entity) {
        this.entitiesByUniqueKey.put(euk, entity);
    }

    public EntityEntry getEntry(Object object) {
        return (EntityEntry)this.entityEntries.get(object);
    }

    public EntityEntry removeEntry(Object object) {
        return (EntityEntry)this.entityEntries.remove(object);
    }

    public boolean isEntryFor(Object object) {
        return this.entityEntries.containsKey(object);
    }

    public CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collectionEntries.get(coll);
    }

    public EntityEntry addEntity(Object object, Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement) {
        this.addEntity(new EntityKey(id, persister), object);
        return this.addEntry(object, status, loadedState, null, id, version, lockMode, existsInDatabase, persister, disableVersionIncrement);
    }

    public EntityEntry addEntry(Object object, Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement) {
        EntityEntry e = new EntityEntry(status, loadedState, rowId, id, version, lockMode, existsInDatabase, persister, disableVersionIncrement);
        this.entityEntries.put(object, e);
        this.setHasNonReadOnlyEnties(status);
        return e;
    }

    public void setLockMode(Object entity, LockMode lockMode) {
        this.getEntry(entity).setLockMode(lockMode);
    }

    public boolean containsProxy(Object object) {
        return this.proxiesByKey.values().contains(object);
    }

    public boolean reassociateIfUninitializedProxy(Object value) throws MappingException {
        if (!Hibernate.isInitialized(value)) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return true;
        }
        return false;
    }

    public void reassociateProxy(Object value, Serializable id) throws MappingException {
        if (value instanceof HibernateProxy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generated identifier: " + id));
            }
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            li.setIdentifier(id);
            this.reassociateProxy(li, proxy);
        }
    }

    public void reassociateProxy(LazyInitializer li, HibernateProxy proxy) throws HibernateException {
        if (li.getSession() != this) {
            EntityPersister persister = this.session.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = new EntityKey(li.getIdentifier(), persister);
            if (!this.proxiesByKey.containsKey(key)) {
                this.proxiesByKey.put(key, proxy);
            }
            proxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    public Object unproxy(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for: " + li.getEntityName());
            }
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public void checkUniqueness(Serializable id, EntityPersister persister, Object object) throws HibernateException {
        Object entity = this.getEntity(new EntityKey(id, persister));
        if (entity == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (entity != null) {
            throw new NonUniqueObjectException(id, persister.getEntityName());
        }
    }

    public Object narrowProxy(Object proxy, EntityPersister persister, EntityKey key, Object object) throws HibernateException {
        if (!persister.getConcreteProxyClass().isAssignableFrom(proxy.getClass())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Narrowing proxy to " + persister.getConcreteProxyClass() + " - this operation breaks =="));
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = persister.createProxy(key.getIdentifier(), this.session);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return proxy;
    }

    public Object proxyFor(EntityPersister persister, EntityKey key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        EntityPersister p = e.getPersister();
        return this.proxyFor(p, new EntityKey(e.getId(), p), impl);
    }

    public Object getCollectionOwner(Serializable key, CollectionPersister collectionPersister) throws MappingException {
        return this.getEntity(new EntityKey(key, collectionPersister.getOwnerEntityPersister()));
    }

    public void addUninitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        CollectionEntry ce = new CollectionEntry(persister, id, this.flushing);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
    }

    public void addUninitializedDetachedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        CollectionEntry ce = new CollectionEntry(persister, id);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
    }

    public void addNewCollection(PersistentCollection collection, CollectionPersister persister) throws HibernateException {
        CollectionEntry ce = this.addCollection(collection);
        if (persister.hasOrphanDelete()) {
            ce.initSnapshot(collection, persister);
        }
    }

    private void addCollection(PersistentCollection coll, CollectionEntry entry, Serializable key) {
        this.collectionEntries.put(coll, entry);
        PersistentCollection old = this.collectionsByKey.put(new CollectionKey(entry.getLoadedPersister(), key), coll);
        if (old != null) {
            if (old == coll) {
                throw new AssertionFailure("bug adding collection twice");
            }
            old.unsetSession(this.session);
            this.collectionEntries.remove(old);
        }
    }

    private CollectionEntry addCollection(PersistentCollection collection) throws HibernateException {
        CollectionEntry ce = new CollectionEntry();
        this.collectionEntries.put(collection, ce);
        collection.setCollectionSnapshot(ce);
        return ce;
    }

    public void addInitializedDetachedCollection(PersistentCollection collection, CollectionSnapshot cs) throws HibernateException {
        if (cs.wasDereferenced()) {
            this.addCollection(collection);
        } else {
            CollectionEntry ce = new CollectionEntry(cs, this.session.getFactory());
            collection.setCollectionSnapshot(ce);
            this.addCollection(collection, ce, cs.getKey());
        }
    }

    private CollectionEntry addInitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(persister, id, this.flushing);
        ce.postInitialize(collection);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
        return ce;
    }

    private PersistentCollection getCollection(CollectionKey collectionKey) {
        return (PersistentCollection)this.collectionsByKey.get(collectionKey);
    }

    private void addLoadingCollectionEntry(CollectionKey collectionKey, PersistentCollection collection, Object resultSetId) {
        this.loadingCollections.put(collectionKey, new LoadingCollectionEntry(collection, collectionKey.getKey(), resultSetId));
    }

    private LoadingCollectionEntry getLoadingCollectionEntry(CollectionKey collectionKey) {
        return (LoadingCollectionEntry)this.loadingCollections.get(collectionKey);
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable id) {
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(new CollectionKey(persister, id));
        return lce != null ? lce.collection : null;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable key, Object resultSetId) throws HibernateException {
        CollectionKey ckey = new CollectionKey(persister, key);
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(ckey);
        if (lce == null) {
            PersistentCollection pc = this.getCollection(ckey);
            if (pc != null) {
                CollectionEntry ce = this.getCollectionEntry(pc);
                if (ce.isInitialized()) {
                    log.trace((Object)"collection already initialized: ignoring");
                    return null;
                }
                log.trace((Object)"uninitialized collection: initializing");
            } else {
                Object entity = this.getCollectionOwner(key, persister);
                if (entity != null && this.getEntry(entity).getStatus() != Status.LOADING) {
                    log.trace((Object)"owning entity already loaded: ignoring");
                    return null;
                }
                log.trace((Object)"new collection: instantiating");
                pc = persister.getCollectionType().instantiate(this.session, persister);
            }
            pc.beforeInitialize(persister);
            pc.beginRead();
            this.addLoadingCollectionEntry(ckey, pc, resultSetId);
            return pc;
        }
        if (lce.resultSetId == resultSetId) {
            log.trace((Object)"reading row");
            return lce.collection;
        }
        log.trace((Object)"collection is already being initialized: ignoring row");
        return null;
    }

    public void addNonLazyCollection(PersistentCollection collection) {
        this.nonlazyCollections.add(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            log.debug((Object)"initializing non-lazy collections");
            ++this.loadCounter;
            try {
                int size;
                while ((size = this.nonlazyCollections.size()) > 0) {
                    ((PersistentCollection)this.nonlazyCollections.remove(size - 1)).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
            }
        }
    }

    public void endLoadingCollections(CollectionPersister persister, Object resultSetId) throws HibernateException {
        ArrayList<LoadingCollectionEntry> resultSetCollections = null;
        Iterator iter = this.loadingCollections.values().iterator();
        while (iter.hasNext()) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)iter.next();
            if (lce.resultSetId != resultSetId) continue;
            if (resultSetCollections == null) {
                resultSetCollections = new ArrayList<LoadingCollectionEntry>();
            }
            resultSetCollections.add(lce);
            iter.remove();
        }
        this.endLoadingCollections(persister, resultSetCollections);
    }

    private void endLoadingCollections(CollectionPersister persister, List resultSetCollections) throws HibernateException {
        int count;
        int n = count = resultSetCollections == null ? 0 : resultSetCollections.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections were found in result set"));
        }
        for (int i = 0; i < count; ++i) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)resultSetCollections.get(i);
            this.endLoadingCollection(lce, persister);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections initialized"));
        }
    }

    private void endLoadingCollection(LoadingCollectionEntry lce, CollectionPersister persister) {
        boolean addToCache;
        boolean hasNoQueuedAdds = lce.collection.endRead();
        CollectionEntry ce = this.getCollectionEntry(lce.collection);
        if (ce == null) {
            ce = this.addInitializedCollection(lce.collection, persister, lce.key);
        } else {
            ce.postInitialize(lce.collection);
        }
        boolean bl = addToCache = hasNoQueuedAdds && persister.hasCache() && this.session.getCacheMode().isPutEnabled() && !ce.isDoremove();
        if (addToCache) {
            this.addCollectionToCache(lce, persister);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("collection fully initialized: " + MessageHelper.infoString((CollectionPersister)persister, (Serializable)lce.key)));
        }
        if (this.session.getFactory().getStatistics().isStatisticsEnabled()) {
            this.session.getFactory().getStatisticsImplementor().loadCollection(persister.getRole());
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry lce, CollectionPersister persister) {
        Object version;
        Comparator versionComparator;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching collection: " + MessageHelper.infoString((CollectionPersister)persister, (Serializable)lce.key)));
        }
        if (persister.isVersioned()) {
            versionComparator = persister.getOwnerEntityPersister().getVersionType().getComparator();
            version = this.getEntry(this.getCollectionOwner(lce.key, persister)).getVersion();
        } else {
            version = null;
            versionComparator = null;
        }
        CollectionCacheEntry entry = new CollectionCacheEntry(lce.collection, persister);
        SessionFactoryImplementor factory = this.session.getFactory();
        boolean put = persister.getCache().put(new CacheKey(lce.key, persister.getKeyType(), persister.getRole()), persister.getCacheEntryStructure().structure(entry), this.session.getTimestamp(), version, versionComparator, factory.getSettings().isMinimalPutsEnabled() && this.session.getCacheMode() != CacheMode.REFRESH);
        if (put && factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().secondLevelCachePut(persister.getCache().getRegionName());
        }
    }

    public PersistentArrayHolder getArrayHolder(Object array) {
        return (PersistentArrayHolder)this.arrayHolders.get(array);
    }

    public void addArrayHolder(PersistentArrayHolder holder) {
        this.arrayHolders.put(holder.getArray(), holder);
    }

    public PersistentArrayHolder removeArrayHolder(Object array) {
        return (PersistentArrayHolder)this.arrayHolders.remove(array);
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry(coll).getSnapshot();
    }

    public Serializable getLoadedCollectionKey(PersistentCollection coll) {
        return this.getCollectionEntry(coll).getLoadedKey();
    }

    public boolean isInverseCollection(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        return ce != null && ce.getLoadedPersister().isInverse();
    }

    public CollectionEntry getCollectionEntryOrNull(Object collection) {
        PersistentCollection coll;
        if (collection instanceof PersistentCollection) {
            coll = (PersistentCollection)collection;
        } else {
            coll = this.getArrayHolder(collection);
            if (coll == null) {
                Iterator wrappers = IdentityMap.keyIterator(this.collectionEntries);
                while (wrappers.hasNext()) {
                    PersistentCollection pc = (PersistentCollection)wrappers.next();
                    if (!pc.isWrapper(collection)) continue;
                    coll = pc;
                    break;
                }
            }
        }
        return coll == null ? null : this.getCollectionEntry(coll);
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable id, int batchSize) {
        Serializable[] keys = new Serializable[batchSize];
        keys[0] = id;
        int i = 0;
        Iterator iter = this.collectionEntries.values().iterator();
        while (iter.hasNext()) {
            CollectionEntry ce = (CollectionEntry)iter.next();
            if (ce.isInitialized() || ce.getLoadedPersister() != collectionPersister || collectionPersister.getKeyType().isEqual(id, ce.getLoadedKey())) continue;
            keys[++i] = ce.getLoadedKey();
            if (i != batchSize - 1) continue;
            return keys;
        }
        return keys;
    }

    public Serializable[] getEntityBatch(String entityName, Serializable id, int batchSize) {
        Serializable[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i = 0;
        Iterator iter = this.batchLoadableEntityKeys.keySet().iterator();
        while (iter.hasNext()) {
            EntityKey key = (EntityKey)iter.next();
            if (!key.getEntityName().equals(entityName) || id.equals(key.getIdentifier())) continue;
            ids[++i] = key.getIdentifier();
            if (i != batchSize - 1) continue;
            return ids;
        }
        return ids;
    }

    public void scheduleBatchLoad(String entityName, Serializable id) throws MappingException {
        EntityPersister persister = this.session.getFactory().getEntityPersister(entityName);
        if (persister.isBatchLoadable()) {
            this.batchLoadableEntityKeys.put(new EntityKey(id, persister), MARKER);
        }
    }

    public Object getProxy(EntityKey key) {
        return this.proxiesByKey.get(key);
    }

    public void addProxy(EntityKey key, Object proxy) {
        this.proxiesByKey.put(key, proxy);
    }

    public Object removeProxy(EntityKey key) {
        return this.proxiesByKey.remove(key);
    }

    public void addNonExist(EntityKey key) {
        this.nonExists.add(key);
    }

    public void addNonExist(EntityUniqueKey key) {
        this.uniqueKeyNonExists.add(key);
    }

    public void removeNonExist(EntityKey key) {
        this.nonExists.remove(key);
    }

    public HashSet getNullifiables() {
        return this.nullifiables;
    }

    public void setNullifiables(HashSet nullifiables) {
        this.nullifiables = nullifiables;
    }

    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getEntityEntries() {
        return this.entityEntries;
    }

    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    public Map getBatchLoadableEntityKeys() {
        return this.batchLoadableEntityKeys;
    }

    public boolean isNonExistant(EntityKey key) {
        return this.nonExists.contains(key);
    }

    public boolean isNonExistant(EntityUniqueKey key) {
        return this.uniqueKeyNonExists.contains(key);
    }

    public int getCascadeLevel() {
        return this.cascading;
    }

    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void setFlushing(boolean flushing) {
        this.flushing = flushing;
    }

    public void beforeLoad() {
        ++this.loadCounter;
    }

    public void afterLoad() {
        --this.loadCounter;
    }

    public String toString() {
        return "PersistentContext[entitiesByKey=" + this.entitiesByKey + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LoadingCollectionEntry {
        final PersistentCollection collection;
        final Serializable key;
        final Object resultSetId;

        LoadingCollectionEntry(PersistentCollection collection, Serializable key, Object resultSetId) {
            this.collection = collection;
            this.key = key;
            this.resultSetId = resultSetId;
        }
    }
}

