/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;

public class QueryImpl
extends AbstractQueryImpl {
    private Map lockModes = new HashMap(2);

    public QueryImpl(String queryString, FlushMode flushMode, SessionImplementor session) {
        super(queryString, flushMode, session);
    }

    public QueryImpl(String queryString, SessionImplementor session) {
        super(queryString, null, session);
    }

    public Iterator iterate() throws HibernateException {
        Iterator iterator;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            iterator = this.getSession().iterate(this.bindParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return iterator;
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        ScrollableResults scrollableResults;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            scrollableResults = this.getSession().scroll(this.bindParameterLists(namedParams), qp);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return scrollableResults;
    }

    public List list() throws HibernateException {
        List list;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            list = this.getSession().list(this.bindParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return list;
    }

    public int executeUpdate() throws HibernateException {
        int n;
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        this.before();
        try {
            n = this.getSession().executeUpdate(this.bindParameterLists(namedParams), this.getQueryParameters(namedParams));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.after();
            throw throwable;
        }
        this.after();
        return n;
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
        return this;
    }

    protected Map getLockModes() {
        return this.lockModes;
    }
}

