/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.jdbc.AbstractBatcher;
import org.hibernate.jdbc.JDBCContext;

public class BatchingBatcher
extends AbstractBatcher {
    private int batchSize;
    private int[] expectedRowCounts = new int[this.getFactory().getSettings().getJdbcBatchSize()];

    public BatchingBatcher(JDBCContext jdbcContext) {
        super(jdbcContext);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        AbstractBatcher.log.trace((Object)"Adding to batch");
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        this.expectedRowCounts[this.batchSize++] = expectedRowCount;
        if (this.batchSize == this.getFactory().getSettings().getJdbcBatchSize()) {
            this.doExecuteBatch(batchUpdate);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (this.batchSize == 0) {
            AbstractBatcher.log.debug((Object)"no batched statements to execute");
            return;
        }
        if (AbstractBatcher.log.isDebugEnabled()) {
            AbstractBatcher.log.debug((Object)("Executing batch size: " + this.batchSize));
        }
        try {
            try {
                this.checkRowCounts(ps.executeBatch());
            }
            catch (RuntimeException re) {
                AbstractBatcher.log.error((Object)"Exception executing batch: ", (Throwable)re);
                throw re;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.batchSize = 0;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.batchSize = 0;
            return;
        }
    }

    private void checkRowCounts(int[] rowCounts) {
        int i = 0;
        while (i < this.batchSize) {
            this.checkRowCount(rowCounts[i], this.expectedRowCounts[i], i);
            ++i;
        }
    }

    private void checkRowCount(int rowCount, int expectedRowCount, int i) {
        if (rowCount == -2) {
            if (AbstractBatcher.log.isDebugEnabled()) {
                AbstractBatcher.log.debug((Object)("success of batch update unknown: " + i));
            }
        } else {
            if (rowCount == -3) {
                throw new HibernateException("Batch update failed: " + i);
            }
            if (expectedRowCount >= 0) {
                if (rowCount < expectedRowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update: " + i + " actual row count: " + rowCount + " expected: " + expectedRowCount);
                }
                if (rowCount > expectedRowCount) {
                    throw new HibernateException("Batch update returned unexpected row count from update: " + i + " actual row count: " + rowCount + " expected: " + expectedRowCount);
                }
            }
        }
    }
}

