/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionInitializer;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.Loadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$CollectionLoader == null ? (class$org$hibernate$loader$CollectionLoader = CollectionLoader.class$("org.hibernate.loader.CollectionLoader")) : class$org$hibernate$loader$CollectionLoader));
    private final QueryableCollection collectionPersister;
    private final Type keyType;
    static /* synthetic */ Class class$org$hibernate$loader$CollectionLoader;

    public CollectionLoader(QueryableCollection persister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(persister, 1, session, enabledFilters);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(persister, batchSize, null, factory, enabledFilters);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.keyType = persister.getKeyType();
        this.collectionPersister = persister;
        String alias = this.generateRootAlias(persister.getRole());
        List associations = this.walkCollectionTree(persister, alias);
        this.initStatementString(persister, alias, associations, batchSize, subquery);
        this.initPersisters(associations);
        this.postInstantiate();
        log.debug((Object)("Static select for collection " + persister.getRole() + ": " + this.getSQLString()));
    }

    private void initPersisters(List associations) throws MappingException {
        int joins = associations.size();
        this.lockModeArray = ArrayHelper.fillArray(LockMode.NONE, joins);
        this.persisters = new Loadable[joins];
        this.owners = new int[joins];
        this.uniqueKeyReferences = new String[joins];
        for (int i = 0; i < joins; ++i) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)associations.get(i);
            this.persisters[i] = (Loadable)((Object)oj.getJoinable());
            this.owners[i] = oj.getOwner(associations);
            this.uniqueKeyReferences[i] = oj.getRHSUniqueKeyName();
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollection(session, id, this.keyType);
    }

    private void initStatementString(QueryableCollection persister, String alias, List associations, int batchSize, String subquery) throws MappingException {
        int joins = associations.size();
        this.suffixes = CollectionLoader.generateSuffixes(joins);
        StringBuffer whereString = this.whereString(alias, persister.getKeyColumnNames(), batchSize, null);
        String filter = persister.filterFragment(alias, this.getEnabledFilters());
        if (filter.trim().length() > 0) {
            filter = filter + " and ";
        }
        if (filter.startsWith(" and ")) {
            filter = filter.substring(4);
        }
        whereString.insert(0, filter);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setSelectClause(persister.selectFragment(alias) + this.selectString(associations)).setFromClause(persister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        if (persister.hasOrdering()) {
            select.setOrderByClause(persister.getSQLOrderByString(alias));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load collection " + persister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path) throws MappingException {
        int joinType = super.getJoinType(type, config, path);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }

    protected Type getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.collectionPersister.getRole() + ')';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

