/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.persister.OuterJoinLoadable;
import org.hibernate.persister.PropertyMapping;
import org.hibernate.persister.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class CriteriaQueryTranslator
implements CriteriaQuery {
    public static final String ROOT_SQL_ALIAS = "this_";
    private final CriteriaImpl criteria;
    private final Map aliasEntityNames;
    private final Map aliasMap;
    private final SessionFactoryImplementor sessionFactory;

    public CriteriaQueryTranslator(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria) throws HibernateException {
        this.criteria = criteria;
        this.sessionFactory = factory;
        this.aliasEntityNames = this.createAliasEntityNameMap();
        this.aliasMap = this.createAliasMap();
    }

    private Map createAliasEntityNameMap() {
        HashMap result = new HashMap();
        String rootEntityName = this.criteria.getRootEntityName();
        result.put(this.criteria.getAlias(), rootEntityName);
        Iterator iter = this.criteria.getAssociationPathAliasMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            result.put(me.getValue(), this.getPathEntityName((String)me.getKey()));
        }
        return result;
    }

    private String getPathEntityName(String path) {
        Queryable persister = (Queryable)this.sessionFactory.getEntityPersister(this.criteria.getRootEntityName());
        StringTokenizer tokens = new StringTokenizer(path, ".");
        String componentPath = "";
        while (tokens.hasMoreTokens()) {
            Type type = persister.toType(componentPath = componentPath + tokens.nextToken());
            if (type.isAssociationType()) {
                AssociationType atype = (AssociationType)type;
                persister = (Queryable)this.sessionFactory.getEntityPersister(atype.getAssociatedEntityName(this.sessionFactory));
                componentPath = "";
                continue;
            }
            if (type.isComponentType()) {
                componentPath = componentPath + '.';
                continue;
            }
            throw new QueryException("not an association: " + componentPath);
        }
        return persister.getEntityName();
    }

    private Map createAliasMap() {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        int i = 0;
        Iterator aliasIterator = this.aliasEntityNames.keySet().iterator();
        while (aliasIterator.hasNext()) {
            String alias = (String)aliasIterator.next();
            aliasMap.put(alias, StringHelper.generateAlias(alias, i++));
        }
        aliasMap.put(this.criteria.getAlias(), ROOT_SQL_ALIAS);
        return aliasMap;
    }

    public CriteriaImpl getCriteria() {
        return this.criteria;
    }

    public QueryParameters getQueryParameters() {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator iter = this.criteria.iterateExpressionEntries();
        while (iter.hasNext()) {
            CriteriaImpl.CriterionEntry ce = (CriteriaImpl.CriterionEntry)iter.next();
            TypedValue[] tv = ce.getCriterion().getTypedValues((String)this.aliasEntityNames.get(ce.getAlias()), this);
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
            }
        }
        Object[] valueArray = values.toArray();
        Type[] typeArray = ArrayHelper.toTypeArray(types);
        RowSelection selection = new RowSelection();
        selection.setFirstRow(this.criteria.getFirstResult());
        selection.setMaxRows(this.criteria.getMaxResults());
        selection.setTimeout(this.criteria.getTimeout());
        selection.setFetchSize(this.criteria.getFetchSize());
        HashMap lockModes = new HashMap();
        iter = this.criteria.getLockModes().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            lockModes.put(this.getSQLAlias((String)me.getKey()), me.getValue());
        }
        return new QueryParameters(typeArray, valueArray, lockModes, selection, this.criteria.getCacheable(), this.criteria.getCacheRegion(), this.criteria.getComment());
    }

    public boolean hasProjection() {
        return this.criteria.getProjection() != null;
    }

    public String getSelect() {
        return this.criteria.getProjection().toSqlString(this.getEntityName(this.criteria.getProjectionAlias()), this.criteria.getProjectionAlias(), 0, this);
    }

    public Type[] getProjectedTypes() {
        return this.criteria.getProjection().getTypes(this.criteria.getRootEntityName(), this);
    }

    public String[] getProjectedColumnAliases() {
        return this.criteria.getProjection().getColumnAliases();
    }

    public String[] getProjectedAliases() {
        return this.criteria.getProjection().getAliases();
    }

    public String getWhereCondition() {
        StringBuffer condition = new StringBuffer(30);
        Iterator criterionIterator = this.criteria.iterateExpressionEntries();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.CriterionEntry entry = (CriteriaImpl.CriterionEntry)criterionIterator.next();
            String sqlString = entry.getCriterion().toSqlString(this.getEntityName(entry.getAlias()), entry.getAlias(), this);
            condition.append(sqlString);
            if (!criterionIterator.hasNext()) continue;
            condition.append(" and ");
        }
        return condition.toString();
    }

    public String getOrderBy() {
        StringBuffer orderBy = new StringBuffer(30);
        Iterator criterionIterator = this.criteria.iterateOrderings();
        while (criterionIterator.hasNext()) {
            CriteriaImpl.OrderEntry oe = (CriteriaImpl.OrderEntry)criterionIterator.next();
            orderBy.append(oe.getOrder().toSqlString(this.getEntityName(oe.getAlias()), oe.getAlias(), this));
            if (!criterionIterator.hasNext()) continue;
            orderBy.append(", ");
        }
        return orderBy.toString();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sessionFactory;
    }

    public String getSQLAlias(String alias) {
        return (String)this.aliasMap.get(alias);
    }

    public String getEntityName(String alias) {
        return (String)this.aliasEntityNames.get(alias);
    }

    public String getColumn(String entityName, String propertyName, String alias) {
        String[] cols = this.getColumns(entityName, propertyName, alias);
        if (cols.length != 1) {
            throw new QueryException("property does not map to a single column: " + propertyName);
        }
        return cols[0];
    }

    public String[] getColumns(String entityName, String propertyName, String alias) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(entityName, propertyName)).toColumns(this.getSQLAlias(alias, propertyName), this.getPropertyName(propertyName));
    }

    public Type getType(String entityName, String propertyName) throws HibernateException {
        return this.getPropertyMapping(this.getEntityName(entityName, propertyName)).toType(this.getPropertyName(propertyName));
    }

    public TypedValue getTypedValue(String entityName, String propertyName, Object value) throws HibernateException {
        return new TypedValue(this.getType(entityName, propertyName), value);
    }

    private PropertyMapping getPropertyMapping(String entityName) throws MappingException {
        return (PropertyMapping)((Object)this.sessionFactory.getEntityPersister(entityName));
    }

    public String getEntityName(String entityName, String propertyName) {
        String root;
        String rooEntityName;
        if (propertyName.indexOf(46) > 0 && (rooEntityName = this.getEntityName(root = StringHelper.root(propertyName))) != null) {
            return rooEntityName;
        }
        return entityName;
    }

    public String getSQLAlias(String alias, String propertyName) {
        String root;
        String entityName;
        if (propertyName.indexOf(46) > 0 && (entityName = this.getEntityName(root = StringHelper.root(propertyName))) != null) {
            return this.getSQLAlias(root);
        }
        return this.getSQLAlias(alias);
    }

    public String getPropertyName(String propertyName) {
        String root;
        String entityName;
        if (propertyName.indexOf(46) > 0 && (entityName = this.getEntityName(root = StringHelper.root(propertyName))) != null) {
            return propertyName.substring(root.length() + 1);
        }
        return propertyName;
    }
}

