/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.loader.EntityDescriptor;
import org.hibernate.persister.Loadable;

public class GeneratedEntityDescriptor
implements EntityDescriptor {
    private final String[] suffixedKeyColumns;
    private final String[] suffixedVersionColumn;
    private final String[][] suffixedPropertyColumns;
    private final String suffixedDiscriminatorColumn;
    private final String suffix;

    public GeneratedEntityDescriptor(Loadable persister, String suffix) {
        this.suffix = suffix;
        this.suffixedKeyColumns = persister.getIdentifierAliases(suffix);
        this.suffixedPropertyColumns = this.getSuffixedPropertyAliases(persister);
        this.suffixedDiscriminatorColumn = persister.getDiscriminatorAlias(suffix);
        this.suffixedVersionColumn = persister.isVersioned() ? this.suffixedPropertyColumns[persister.getVersionProperty()] : null;
    }

    public String[][] getSuffixedPropertyAliases(Loadable persister) {
        int size = persister.getPropertyNames().length;
        String[][] suffixedPropertyAliases = new String[size][];
        for (int j = 0; j < size; ++j) {
            suffixedPropertyAliases[j] = persister.getPropertyAliases(this.suffix, j);
        }
        return suffixedPropertyAliases;
    }

    public String[] getSuffixedVersionAliases() {
        return this.suffixedVersionColumn;
    }

    public String[][] getSuffixedPropertyAliases() {
        return this.suffixedPropertyColumns;
    }

    public String getSuffixedDiscriminatorAlias() {
        return this.suffixedDiscriminatorColumn;
    }

    public String[] getSuffixedKeyAliases() {
        return this.suffixedKeyColumns;
    }

    public String getRowIdAlias() {
        return "rowid_" + this.suffix;
    }
}

