/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Subquery;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.impl.ScrollableResultsImpl;
import org.hibernate.jdbc.ColumnNameCache;
import org.hibernate.jdbc.ResultSetWrapper;
import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.util.StringHelper;

public abstract class Loader {
    private static final Log log;
    private final SessionFactoryImplementor factory;
    private ColumnNameCache columnNameCache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.loader.Loader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Loader(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    protected abstract String getSQLString();

    protected abstract Loadable[] getEntityPersisters();

    protected int[] getOwners() {
        return null;
    }

    protected AssociationType[] getOwnerAssociationTypes() {
        return null;
    }

    protected CollectionPersister getCollectionPersister() {
        return null;
    }

    protected int getCollectionOwner() {
        return -1;
    }

    protected abstract LockMode[] getLockModes(Map var1);

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws HibernateException {
        return sql;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    protected String[] getAliases() {
        return null;
    }

    protected String preprocessSQL(String sql, QueryParameters parameters, Dialect dialect) throws HibernateException {
        sql = this.applyLocks(sql, parameters.getLockModes(), dialect);
        String comment = parameters.getComment();
        if (comment == null) {
            return sql;
        }
        return new StringBuffer(comment.length() + sql.length() + 5).append("/*").append(comment).append("*/ ").append(sql).toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List doQueryAndInitializeNonLazyCollections(SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException, SQLException {
        List result;
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.beforeLoad();
        try {
            result = this.doQuery(session, queryParameters, returnProxies);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            persistenceContext.afterLoad();
            throw throwable;
        }
        {
            Object var6_8 = null;
            persistenceContext.afterLoad();
        }
        persistenceContext.initializeNonLazyCollections();
        return result;
    }

    public Object loadSingleRow(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException {
        Object result;
        int entitySpan = this.getEntityPersisters().length;
        ArrayList hydratedObjects = entitySpan == 0 ? null : new ArrayList(entitySpan);
        try {
            result = this.getRowFromResultSet(resultSet, session, queryParameters, this.getLockModes(queryParameters.getLockModes()), null, hydratedObjects, new EntityKey[entitySpan], returnProxies);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not read next row of results", this.getSQLString());
        }
        this.initializeEntitiesAndCollections(hydratedObjects, resultSet, session, queryParameters.isReadOnly());
        session.getPersistenceContext().initializeNonLazyCollections();
        return result;
    }

    private static EntityKey getOptionalObjectKey(QueryParameters queryParameters, SessionImplementor session) {
        Object optionalObject = queryParameters.getOptionalObject();
        Serializable optionalId = queryParameters.getOptionalId();
        String optionalEntityName = queryParameters.getOptionalEntityName();
        if (optionalObject != null && optionalEntityName != null) {
            return new EntityKey(optionalId, session.getEntityPersister(optionalEntityName, optionalObject), session.getEntityMode());
        }
        return null;
    }

    private Object getRowFromResultSet(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, LockMode[] lockModeArray, EntityKey optionalObjectKey, List hydratedObjects, EntityKey[] keys, boolean returnProxies) throws SQLException, HibernateException {
        Loadable[] persisters = this.getEntityPersisters();
        int entitySpan = persisters.length;
        int i = 0;
        while (i < entitySpan) {
            keys[i] = this.getKeyFromResultSet(i, persisters[i], i == entitySpan - 1 ? queryParameters.getOptionalId() : null, resultSet, session);
            ++i;
        }
        this.registerNonExists(keys, persisters, session);
        Object[] row = this.getRow(resultSet, persisters, keys, queryParameters.getOptionalObject(), optionalObjectKey, lockModeArray, hydratedObjects, session);
        this.readCollectionElements(row, resultSet, session);
        if (returnProxies) {
            int i2 = 0;
            while (i2 < entitySpan) {
                row[i2] = session.getPersistenceContext().proxyFor(persisters[i2], keys[i2], row[i2]);
                Hibernate.initialize(row[i2]);
                ++i2;
            }
        }
        return this.getResultColumnOrRow(row, resultSet, session);
    }

    private void readCollectionElements(Object[] row, ResultSet resultSet, SessionImplementor session) throws SQLException, HibernateException {
        CollectionPersister collectionPersister = this.getCollectionPersister();
        if (collectionPersister != null) {
            int collectionOwner = this.getCollectionOwner();
            boolean hasCollectionOwners = collectionOwner >= 0;
            Object owner = hasCollectionOwners ? row[collectionOwner] : null;
            Serializable key = owner == null ? null : collectionPersister.getCollectionType().getKeyOfOwner(owner, session);
            this.readCollectionElement(owner, key, resultSet, session);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List doQuery(SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws SQLException, HibernateException {
        RowSelection selection = queryParameters.getRowSelection();
        int maxRows = Loader.hasMaxRows(selection) ? selection.getMaxRows() : Integer.MAX_VALUE;
        int entitySpan = this.getEntityPersisters().length;
        ArrayList hydratedObjects = entitySpan == 0 ? null : new ArrayList(entitySpan * 10);
        ArrayList<Object> results = new ArrayList<Object>();
        PreparedStatement st = this.prepareQueryStatement(queryParameters, false, session);
        ResultSet rs = this.getResultSet(st, queryParameters.isCallable(), selection, session);
        LockMode[] lockModeArray = this.getLockModes(queryParameters.getLockModes());
        EntityKey optionalObjectKey = Loader.getOptionalObjectKey(queryParameters, session);
        boolean createSubqueries = this.isSubqueryCreationRequired();
        HashSet<EntityKey> subqueryResultKeys = createSubqueries ? new HashSet<EntityKey>() : null;
        try {
            this.handleEmptyCollections(queryParameters.getCollectionKeys(), rs, session);
            EntityKey[] keys = new EntityKey[entitySpan];
            if (log.isTraceEnabled()) {
                log.trace((Object)"processing result set");
            }
            int count = 0;
            while (true) {
                block9: {
                    if (count < maxRows && rs.next()) break block9;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("done processing result set (" + count + " rows)"));
                    }
                    break;
                }
                if (log.isTraceEnabled()) {
                    log.debug((Object)("result set row: " + count));
                }
                Object result = this.getRowFromResultSet(rs, session, queryParameters, lockModeArray, optionalObjectKey, hydratedObjects, keys, returnProxies);
                results.add(result);
                if (createSubqueries && keys[0] != null) {
                    subqueryResultKeys.add(keys[0]);
                }
                ++count;
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            session.getBatcher().closeQueryStatement(st, rs);
            throw throwable;
        }
        {
            Object var18_20 = null;
        }
        session.getBatcher().closeQueryStatement(st, rs);
        this.initializeEntitiesAndCollections(hydratedObjects, rs, session, queryParameters.isReadOnly());
        if (createSubqueries) {
            this.createSubquery(subqueryResultKeys, queryParameters, session);
        }
        return results;
    }

    protected boolean isSubqueryCreationRequired() {
        return false;
    }

    private void createSubquery(Set keys, QueryParameters queryParameters, SessionImplementor session) {
        if (keys.size() > 1) {
            Loadable loadable = this.getEntityPersisters()[0];
            String alias = this.getAliases()[0];
            Subquery subquery = new Subquery(this.getSQLString(), alias, loadable, queryParameters, keys);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                session.getPersistenceContext().getBatchFetchQueue().addSubquery((EntityKey)iter.next(), subquery);
            }
        }
    }

    private void initializeEntitiesAndCollections(List hydratedObjects, Object resultSetId, SessionImplementor session, boolean readOnly) throws HibernateException {
        CollectionPersister collectionPersister;
        PreLoadEvent pre = new PreLoadEvent(session);
        PostLoadEvent post = new PostLoadEvent(session);
        if (this.getEntityPersisters().length > 0) {
            int hydratedObjectsSize = hydratedObjects.size();
            if (log.isTraceEnabled()) {
                log.trace((Object)("total objects hydrated: " + hydratedObjectsSize));
            }
            int i = 0;
            while (i < hydratedObjectsSize) {
                TwoPhaseLoad.initializeEntity(hydratedObjects.get(i), readOnly, session, pre, post);
                ++i;
            }
        }
        if ((collectionPersister = this.getCollectionPersister()) != null) {
            session.getPersistenceContext().getCollectionLoadContext().endLoadingCollections(collectionPersister, resultSetId, session.getEntityMode());
        }
    }

    protected List getResultList(List results) throws QueryException {
        return results;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row;
    }

    private void registerNonExists(EntityKey[] keys, Loadable[] persisters, SessionImplementor session) {
        int[] owners = this.getOwners();
        if (owners != null) {
            AssociationType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
            int i = 0;
            while (i < keys.length) {
                int owner = owners[i];
                if (owner > -1) {
                    EntityKey ownerKey = keys[owner];
                    if (keys[i] == null && ownerKey != null) {
                        boolean isSpecialOneToOne;
                        boolean isPrimaryKey;
                        PersistenceContext persistenceContext = session.getPersistenceContext();
                        if (ownerAssociationTypes == null || ownerAssociationTypes[i] == null) {
                            isPrimaryKey = true;
                            isSpecialOneToOne = false;
                        } else {
                            isPrimaryKey = ownerAssociationTypes[i].getRHSUniqueKeyPropertyName() == null;
                            boolean bl = isSpecialOneToOne = ownerAssociationTypes[i].getLHSPropertyName() != null;
                        }
                        if (isPrimaryKey && !isSpecialOneToOne) {
                            persistenceContext.addNonExistantEntityKey(new EntityKey(ownerKey.getIdentifier(), persisters[i], session.getEntityMode()));
                        } else if (isSpecialOneToOne) {
                            persistenceContext.addNullProperty(ownerKey, ownerAssociationTypes[i].getLHSPropertyName());
                        } else {
                            persistenceContext.addNonExistantEntityUniqueKey(new EntityUniqueKey(persisters[i].getEntityName(), ownerAssociationTypes[i].getRHSUniqueKeyPropertyName(), ownerKey.getIdentifier(), persisters[owner].getIdentifierType(), session.getEntityMode()));
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void readCollectionElement(Object optionalOwner, Serializable optionalKey, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        CollectionPersister collectionPersister = this.getCollectionPersister();
        Serializable collectionRowKey = (Serializable)collectionPersister.readKey(rs, session);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (collectionRowKey != null) {
            PersistentCollection rowCollection;
            Object owner;
            if (log.isDebugEnabled()) {
                log.debug((Object)("found row of collection: " + MessageHelper.collectionInfoString(collectionPersister, collectionRowKey, this.getFactory())));
            }
            if ((owner = optionalOwner) == null) {
                owner = persistenceContext.getCollectionOwner(collectionRowKey, collectionPersister);
            }
            if ((rowCollection = persistenceContext.getCollectionLoadContext().getLoadingCollection(collectionPersister, collectionRowKey, rs, session.getEntityMode())) != null) {
                rowCollection.readFrom(rs, collectionPersister, owner);
            }
        } else if (optionalKey != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(collectionPersister, optionalKey, this.getFactory())));
            }
            persistenceContext.getCollectionLoadContext().getLoadingCollection(collectionPersister, optionalKey, rs, session.getEntityMode());
        }
    }

    private void handleEmptyCollections(Serializable[] keys, Object resultSetId, SessionImplementor session) throws HibernateException {
        if (keys != null) {
            CollectionPersister collectionPersister = this.getCollectionPersister();
            int i = 0;
            while (i < keys.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("result set contains (possibly empty) collection: " + MessageHelper.collectionInfoString(collectionPersister, keys[i], this.getFactory())));
                }
                session.getPersistenceContext().getCollectionLoadContext().getLoadingCollection(collectionPersister, keys[i], resultSetId, session.getEntityMode());
                ++i;
            }
        }
    }

    private EntityKey getKeyFromResultSet(int i, Loadable persister, Serializable id, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Serializable resultId;
        if (this.isSingleRowLoader() && id != null) {
            resultId = id;
        } else {
            boolean idIsResultId;
            Type idType = persister.getIdentifierType();
            resultId = (Serializable)idType.nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedKeyAliases(), session, null);
            boolean bl = idIsResultId = id != null && resultId != null && idType.isEqual(id, resultId, session.getEntityMode(), this.factory);
            if (idIsResultId) {
                resultId = id;
            }
        }
        return resultId == null ? null : new EntityKey(resultId, persister, session.getEntityMode());
    }

    private void checkVersion(int i, Loadable persister, Serializable id, Object entity, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object currentVersion;
        VersionType versionType;
        Object version = session.getPersistenceContext().getEntry(entity).getVersion();
        if (version != null && !(versionType = persister.getVersionType()).isEqual(version, currentVersion = versionType.nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedVersionAliases(), session, null))) {
            throw new StaleObjectStateException(persister.getEntityName(), id);
        }
    }

    private Object[] getRow(ResultSet rs, Loadable[] persisters, EntityKey[] keys, Object optionalObject, EntityKey optionalObjectKey, LockMode[] lockModes, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        int cols = persisters.length;
        EntityAliases[] descriptors = this.getEntityAliases();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result row: " + StringHelper.toString(keys)));
        }
        Object[] rowResults = new Object[cols];
        int i = 0;
        while (i < cols) {
            Object object = null;
            EntityKey key = keys[i];
            if (keys[i] != null) {
                object = session.getEntityUsingInterceptor(key);
                if (object != null) {
                    this.instanceAlreadyLoaded(rs, i, persisters[i], key, object, lockModes[i], session);
                } else {
                    object = this.instanceNotYetLoaded(rs, i, persisters[i], descriptors[i].getRowIdAlias(), key, lockModes[i], optionalObjectKey, optionalObject, hydratedObjects, session);
                }
            }
            rowResults[i] = object;
            ++i;
        }
        return rowResults;
    }

    private void instanceAlreadyLoaded(ResultSet rs, int i, Loadable persister, EntityKey key, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (!persister.isInstance(object, session.getEntityMode())) {
            throw new WrongClassException("loaded object was of wrong class", key.getIdentifier(), persister.getEntityName());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks()) {
            boolean isVersionCheckNeeded;
            boolean bl = isVersionCheckNeeded = persister.isVersioned() && session.getPersistenceContext().getLockMode(object).lessThan(lockMode);
            if (isVersionCheckNeeded) {
                this.checkVersion(i, persister, key.getIdentifier(), object, rs, session);
                session.getPersistenceContext().setLockMode(object, lockMode);
            }
        }
    }

    private Object instanceNotYetLoaded(ResultSet rs, int i, Loadable persister, String rowIdAlias, EntityKey key, LockMode lockMode, EntityKey optionalObjectKey, Object optionalObject, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        String instanceClass = this.getInstanceClass(rs, i, persister, key.getIdentifier(), session);
        Object object = optionalObjectKey != null && key.equals(optionalObjectKey) ? optionalObject : session.instantiate(instanceClass, key.getIdentifier());
        LockMode acquiredLockMode = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(rs, i, object, instanceClass, key, rowIdAlias, acquiredLockMode, persister, session);
        hydratedObjects.add(object);
        return object;
    }

    private void loadFromResultSet(ResultSet rs, int i, Object object, String instanceEntityName, EntityKey key, String rowIdAlias, LockMode lockMode, Loadable rootPersister, SessionImplementor session) throws SQLException, HibernateException {
        String ukName;
        Serializable id = key.getIdentifier();
        Loadable persister = (Loadable)this.getFactory().getEntityPersister(instanceEntityName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing object from ResultSet: " + MessageHelper.infoString((EntityPersister)persister, id, this.getFactory())));
        }
        TwoPhaseLoad.addUninitializedEntity(id, object, persister, lockMode, session);
        String[][] cols = persister == rootPersister ? this.getEntityAliases()[i].getSuffixedPropertyAliases() : this.getEntityAliases()[i].getSuffixedPropertyAliases(persister);
        Object[] values = persister.hydrate(rs, id, object, rootPersister, session, cols);
        Object rowId = persister.hasRowId() ? rs.getObject(rowIdAlias) : null;
        AssociationType[] ownerAssociationTypes = this.getOwnerAssociationTypes();
        if (ownerAssociationTypes != null && ownerAssociationTypes[i] != null && (ukName = ownerAssociationTypes[i].getRHSUniqueKeyPropertyName()) != null) {
            int index = ((UniqueKeyLoadable)persister).getPropertyIndex(ukName);
            Type type = persister.getPropertyTypes()[index];
            EntityUniqueKey euk = new EntityUniqueKey(rootPersister.getEntityName(), ukName, type.semiResolve(values[index], session, object), type, session.getEntityMode());
            session.getPersistenceContext().addEntity(euk, object);
        }
        TwoPhaseLoad.postHydrate(persister, id, values, rowId, object, lockMode, session);
    }

    private String getInstanceClass(ResultSet rs, int i, Loadable persister, Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        if (persister.hasSubclasses()) {
            Object discriminatorValue = persister.getDiscriminatorType().nullSafeGet(rs, this.getEntityAliases()[i].getSuffixedDiscriminatorAlias(), session, null);
            String result = persister.getSubclassForDiscriminatorValue(discriminatorValue);
            if (result == null) {
                throw new WrongClassException("Discriminator: " + discriminatorValue, id, persister.getEntityName());
            }
            return result;
        }
        return persister.getEntityName();
    }

    private void advance(ResultSet rs, RowSelection selection) throws SQLException {
        int firstRow = Loader.getFirstRow(selection);
        if (firstRow != 0) {
            if (this.getFactory().getSettings().isScrollableResultSetsEnabled()) {
                rs.absolute(firstRow);
            } else {
                int m = 0;
                while (m < firstRow) {
                    rs.next();
                    ++m;
                }
            }
        }
    }

    private static boolean hasMaxRows(RowSelection selection) {
        return selection != null && selection.getMaxRows() != null;
    }

    private static int getFirstRow(RowSelection selection) {
        if (selection == null || selection.getFirstRow() == null) {
            return 0;
        }
        return selection.getFirstRow();
    }

    private static boolean useLimit(RowSelection selection, Dialect dialect) {
        return dialect.supportsLimit() && Loader.hasMaxRows(selection);
    }

    protected int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getPositionalParameterValues();
        Type[] types = queryParameters.getPositionalParameterTypes();
        int span = 0;
        int i = 0;
        while (i < values.length) {
            types[i].nullSafeSet(st, values[i], start + span, session);
            span += types[i].getColumnSpan(this.getFactory());
            ++i;
        }
        return span;
    }

    private String processFilterParameters(String sql, QueryParameters queryParameters, SessionImplementor session) {
        if (session.getEnabledFilters().size() == 0) {
            return sql;
        }
        Dialect dialect = this.getFactory().getDialect();
        String symbols = " =><!+-*/()'," + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sql, symbols, true);
        StringBuffer result = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.startsWith(":")) {
                String filterParameterName = token.substring(1);
                Object value = session.getFilterParameterValue(filterParameterName);
                Type type = session.getFilterParameterType(filterParameterName);
                if (value != null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.util.Collection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(value.getClass())) {
                        Iterator itr = ((Collection)value).iterator();
                        while (itr.hasNext()) {
                            Object elementValue = itr.next();
                            result.append('?');
                            parameters.add(elementValue);
                            parameterTypes.add(type);
                            if (!itr.hasNext()) continue;
                            result.append(", ");
                        }
                        continue;
                    }
                }
                result.append('?');
                parameters.add(value);
                parameterTypes.add(type);
                continue;
            }
            result.append(token);
        }
        parameters.addAll(Arrays.asList(queryParameters.getPositionalParameterValues()));
        parameterTypes.addAll(Arrays.asList(queryParameters.getPositionalParameterTypes()));
        queryParameters.setPositionalParameterValues(parameters.toArray());
        queryParameters.setPositionalParameterTypes(parameterTypes.toArray(new Type[0]));
        return result.toString();
    }

    protected final PreparedStatement prepareQueryStatement(QueryParameters queryParameters, boolean scroll, SessionImplementor session) throws SQLException, HibernateException {
        ScrollMode scrollMode;
        String sql = this.processFilterParameters(this.getSQLString(), queryParameters, session);
        Dialect dialect = this.getFactory().getDialect();
        RowSelection selection = queryParameters.getRowSelection();
        boolean useLimit = Loader.useLimit(selection, dialect);
        boolean hasFirstRow = Loader.getFirstRow(selection) > 0;
        boolean useOffset = hasFirstRow && useLimit && dialect.supportsLimitOffset();
        boolean callable = queryParameters.isCallable();
        boolean useScrollableResultSetToSkip = hasFirstRow && !useOffset && this.getFactory().getSettings().isScrollableResultSetsEnabled();
        ScrollMode scrollMode2 = scrollMode = scroll ? queryParameters.getScrollMode() : ScrollMode.SCROLL_INSENSITIVE;
        if (useLimit) {
            sql = dialect.getLimitString(sql.trim(), useOffset ? Loader.getFirstRow(selection) : 0, Loader.getMaxOrLimit(selection, dialect));
        }
        sql = this.preprocessSQL(sql, queryParameters, dialect);
        PreparedStatement st = null;
        st = callable ? session.getBatcher().prepareCallableQueryStatement(sql, scroll || useScrollableResultSetToSkip, scrollMode) : session.getBatcher().prepareQueryStatement(sql, scroll || useScrollableResultSetToSkip, scrollMode);
        try {
            int col = 1;
            if (useLimit && dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection);
            }
            if (callable) {
                col = dialect.registerResultSetOutParameter((CallableStatement)st, col);
            }
            col += this.bindPositionalParameters(st, queryParameters, col, session);
            col += this.bindNamedParameters(st, queryParameters.getNamedParameters(), col, session);
            if (useLimit && !dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection);
            }
            if (!useLimit) {
                this.setMaxRows(st, selection);
            }
            if (selection != null) {
                if (selection.getTimeout() != null) {
                    st.setQueryTimeout(selection.getTimeout());
                }
                if (selection.getFetchSize() != null) {
                    st.setFetchSize(selection.getFetchSize());
                }
            }
        }
        catch (SQLException sqle) {
            session.getBatcher().closeQueryStatement(st, null);
            throw sqle;
        }
        catch (HibernateException he) {
            session.getBatcher().closeQueryStatement(st, null);
            throw he;
        }
        return st;
    }

    private static int getMaxOrLimit(RowSelection selection, Dialect dialect) {
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = selection.getMaxRows();
        if (dialect.useMaxForLimit()) {
            return lastRow + firstRow;
        }
        return lastRow;
    }

    private int bindLimitParameters(PreparedStatement st, int index, RowSelection selection) throws SQLException {
        Dialect dialect = this.getFactory().getDialect();
        if (!dialect.supportsVariableLimit()) {
            return 0;
        }
        if (!Loader.hasMaxRows(selection)) {
            throw new AssertionFailure("no max results set");
        }
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = Loader.getMaxOrLimit(selection, dialect);
        boolean hasFirstRow = firstRow > 0 && dialect.supportsLimitOffset();
        boolean reverse = dialect.bindLimitParametersInReverseOrder();
        if (hasFirstRow) {
            st.setInt(index + (reverse ? 1 : 0), firstRow);
        }
        st.setInt(index + (reverse || !hasFirstRow ? 0 : 1), lastRow);
        return hasFirstRow ? 2 : 1;
    }

    private void setMaxRows(PreparedStatement st, RowSelection selection) throws SQLException {
        if (Loader.hasMaxRows(selection)) {
            st.setMaxRows(selection.getMaxRows() + Loader.getFirstRow(selection));
        }
    }

    protected final ResultSet getResultSet(PreparedStatement st, RowSelection selection, SessionImplementor session) throws HibernateException, SQLException {
        return this.getResultSet(st, false, selection, session);
    }

    protected final ResultSet getResultSet(PreparedStatement st, boolean callable, RowSelection selection, SessionImplementor session) throws SQLException, HibernateException {
        ResultSet rs = null;
        try {
            rs = callable ? session.getBatcher().getResultSet((CallableStatement)st) : session.getBatcher().getResultSet(st);
            rs = this.wrapResultSetIfEnabled(rs, session);
            Dialect dialect = this.getFactory().getDialect();
            if (!dialect.supportsLimitOffset() || !Loader.useLimit(selection, dialect)) {
                this.advance(rs, selection);
            }
            return rs;
        }
        catch (SQLException sqle) {
            session.getBatcher().closeQueryStatement(st, rs);
            throw sqle;
        }
    }

    private synchronized ResultSet wrapResultSetIfEnabled(ResultSet rs, SessionImplementor session) {
        if (session.getFactory().getSettings().isWrapResultSetsEnabled()) {
            try {
                log.debug((Object)("Wrapping result set [" + rs + "]"));
                return new ResultSetWrapper(rs, this.retreiveColumnNameToIndexCache(rs));
            }
            catch (SQLException e) {
                log.info((Object)"Error wrapping result set", (Throwable)e);
                return rs;
            }
        }
        return rs;
    }

    private ColumnNameCache retreiveColumnNameToIndexCache(ResultSet rs) throws SQLException {
        if (this.columnNameCache == null) {
            log.trace((Object)"Building columnName->columnIndex cache");
            this.columnNameCache = new ColumnNameCache(rs.getMetaData().getColumnCount());
        }
        return this.columnNameCache;
    }

    protected int bindNamedParameters(PreparedStatement st, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        return 0;
    }

    protected final List loadEntity(SessionImplementor session, Object id, Type identifierType, Object optionalObject, String optionalEntityName, Serializable optionalIdentifier, EntityPersister persister) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading entity: " + MessageHelper.infoString(persister, id, identifierType, this.getFactory())));
        }
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(new Type[]{identifierType}, new Object[]{id}, optionalObject, optionalEntityName, optionalIdentifier), false);
        }
        catch (SQLException sqle) {
            Loadable[] persisters = this.getEntityPersisters();
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load an entity: " + MessageHelper.infoString(persisters[persisters.length - 1], id, identifierType, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done entity load");
        return result;
    }

    public final List loadEntityBatch(SessionImplementor session, Serializable[] ids, Type idType, Object optionalObject, String optionalEntityName, Serializable optionalId, EntityPersister persister) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debug((Object)("batch loading entity: " + MessageHelper.infoString(persister, ids, this.getFactory())));
        }
        Object[] types = new Type[ids.length];
        Arrays.fill(types, idType);
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters((Type[])types, ids, optionalObject, optionalEntityName, optionalId), false);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], ids, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done entity batch load");
        return result;
    }

    public final void loadCollection(SessionImplementor session, Serializable id, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("batch loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersister(), id, this.getFactory())));
        }
        Object[] ids = new Serializable[]{id};
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(new Type[]{type}, ids, (Serializable[])ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not initialize a collection: " + MessageHelper.collectionInfoString(this.getCollectionPersister(), id, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done loading collection");
    }

    public final void loadCollectionBatch(SessionImplementor session, Serializable[] ids, Type type) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("batch loading collection: " + MessageHelper.collectionInfoString(this.getCollectionPersister(), ids, this.getFactory())));
        }
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters((Type[])idTypes, ids, ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not initialize a collection batch: " + MessageHelper.collectionInfoString(this.getCollectionPersister(), ids, this.getFactory()), this.getSQLString());
        }
        log.debug((Object)"done batch load");
    }

    protected final void loadCollectionSubselect(SessionImplementor session, Serializable[] ids, Object[] parameterValues, Type[] parameterTypes, Map namedParameters, Type type) throws HibernateException {
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        try {
            this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(parameterTypes, parameterValues, namedParameters, ids), true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not load collection by subselect: " + MessageHelper.collectionInfoString(this.getCollectionPersister(), ids, this.getFactory()), this.getSQLString());
        }
    }

    protected List list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws HibernateException {
        boolean cacheable;
        boolean bl = cacheable = this.factory.getSettings().isQueryCacheEnabled() && queryParameters.isCacheable();
        if (cacheable) {
            boolean queryStatisticsEnabled = this.getQueryIdentifier() != null && this.factory.getStatistics().isStatisticsEnabled();
            QueryCache queryCache = this.factory.getQueryCache(queryParameters.getCacheRegion());
            QueryKey key = new QueryKey(this.getSQLString(), queryParameters, session.getEntityMode());
            List result = null;
            if (session.getCacheMode().isGetEnabled()) {
                result = queryCache.get(key, resultTypes, querySpaces, session);
                if (queryStatisticsEnabled) {
                    if (result == null) {
                        this.factory.getStatisticsImplementor().queryCacheMiss(this.getQueryIdentifier(), queryCache.getRegionName());
                    } else {
                        this.factory.getStatisticsImplementor().queryCacheHit(this.getQueryIdentifier(), queryCache.getRegionName());
                    }
                }
            }
            if (result == null) {
                result = this.doList(session, queryParameters);
                if (cacheable && session.getCacheMode().isPutEnabled()) {
                    queryCache.put(key, resultTypes, result, session);
                    if (queryStatisticsEnabled) {
                        this.factory.getStatisticsImplementor().queryCachePut(this.getQueryIdentifier(), queryCache.getRegionName());
                    }
                }
            }
            return this.getResultList(result);
        }
        return this.getResultList(this.doList(session, queryParameters));
    }

    protected List doList(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        List result;
        boolean stats = this.getQueryIdentifier() != null && this.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            result = this.doQueryAndInitializeNonLazyCollections(session, queryParameters, true);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute query", this.getSQLString());
        }
        if (stats) {
            this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), result.size(), System.currentTimeMillis() - startTime);
        }
        return result;
    }

    protected ScrollableResults scroll(QueryParameters queryParameters, Type[] returnTypes, Class holderClass, SessionImplementor session) throws HibernateException {
        if (this.getCollectionPersister() != null) {
            throw new HibernateException("Cannot scroll queries which initialize collections");
        }
        boolean stats = this.getQueryIdentifier() != null && this.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            PreparedStatement st = this.prepareQueryStatement(queryParameters, true, session);
            ResultSet rs = this.getResultSet(st, queryParameters.getRowSelection(), session);
            if (stats) {
                this.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - startTime);
            }
            ScrollableResultsImpl result = new ScrollableResultsImpl(rs, st, session, this, queryParameters, returnTypes, holderClass);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute query using scroll", this.getSQLString());
        }
    }

    protected void postInstantiate() {
    }

    protected abstract EntityAliases[] getEntityAliases();

    protected String getQueryIdentifier() {
        return null;
    }

    public final SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + this.getSQLString() + ')';
    }
}

