/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.SQLQueryReturn;
import org.hibernate.engine.SQLQueryScalarReturn;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.CustomQuery;
import org.hibernate.loader.EntityDescriptor;
import org.hibernate.loader.GeneratedEntityDescriptor;
import org.hibernate.loader.SQLQueryParser;
import org.hibernate.loader.SQLQueryReturnProcessor;
import org.hibernate.persister.SQLLoadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class SQLCustomQuery
implements CustomQuery {
    private final String[] entityNames;
    private final String collectionRole;
    private int collectionOwner;
    private final int[] entityOwners;
    private final LockMode[] lockModes;
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameters;
    private final Type[] scalarTypes;
    private final String[] scalarColumnAliases;
    private final EntityDescriptor[] entityDescriptors;

    public String getSQL() {
        return this.sql;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameters;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public String[] getEntityNames() {
        return this.entityNames;
    }

    public LockMode[] getLockModes() {
        return this.lockModes;
    }

    public EntityDescriptor[] getEntityDescriptors() {
        return this.entityDescriptors;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public int getCollectionOwner() {
        return this.collectionOwner;
    }

    public int[] getEntityOwners() {
        return this.entityOwners;
    }

    public String[] getScalarColumnAliases() {
        return this.scalarColumnAliases;
    }

    public Type[] getScalarTypes() {
        return this.scalarTypes;
    }

    public SQLCustomQuery(SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarQueryReturns, String sqlQuery, Collection additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, scalarQueryReturns, factory);
        processor.process();
        this.collectionOwner = processor.getCollectionOwner();
        this.collectionRole = processor.getCollectionPersister() == null ? null : processor.getCollectionPersister().getRole();
        QueryableCollection collectionPersister = processor.getCollectionPersister();
        String[] aliases = ArrayHelper.toStringArray(processor.getAliases());
        SQLLoadable[] entityPersisters = processor.getPersisters().toArray(new SQLLoadable[0]);
        this.lockModes = processor.getLockModes().toArray(new LockMode[0]);
        this.scalarColumnAliases = ArrayHelper.toStringArray(processor.getScalarColumnAliases());
        this.scalarTypes = ArrayHelper.toTypeArray(processor.getScalarTypes());
        String[] suffixes = BasicLoader.generateSuffixes(entityPersisters.length);
        SQLQueryParser parser = new SQLQueryParser(sqlQuery, processor.getAlias2Persister(), aliases, processor.getCollectionAlias(), collectionPersister, suffixes);
        if (!processor.isCollectionInitializer() && StringHelper.isNotEmpty(processor.getCollectionOwnerAlias())) {
            this.collectionOwner = parser.getPersisterIndex(processor.getCollectionOwnerAlias());
        }
        this.sql = parser.process();
        this.namedParameters = parser.getNamedParameters();
        this.entityNames = new String[entityPersisters.length];
        this.entityDescriptors = new EntityDescriptor[entityPersisters.length];
        for (int i = 0; i < entityPersisters.length; ++i) {
            SQLLoadable persister = entityPersisters[i];
            ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
            this.entityNames[i] = persister.getEntityName();
            this.entityDescriptors[i] = new GeneratedEntityDescriptor(entityPersisters[i], suffixes[i]);
        }
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
        Map alias2OwnerAlias = processor.getAlias2OwnerAlias();
        int[] ownersArray = new int[entityPersisters.length];
        for (int j = 0; j < aliases.length; ++j) {
            String ownerAlias = (String)alias2OwnerAlias.get(aliases[j]);
            ownersArray[j] = StringHelper.isNotEmpty(ownerAlias) ? parser.getPersisterIndex(ownerAlias) : -1;
        }
        if (ArrayHelper.isAllNegative(ownersArray)) {
            ownersArray = null;
        }
        this.entityOwners = ownersArray;
    }
}

