/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionLoader;
import org.hibernate.util.StringHelper;

public class SubqueryCollectionLoader
extends CollectionLoader {
    private final Serializable[] keys;
    private final QueryParameters queryParameters;

    public SubqueryCollectionLoader(QueryableCollection persister, String subquery, Collection entityKeys, QueryParameters queryParameters, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(persister, 1, subquery, factory, enabledFilters);
        this.keys = new Serializable[entityKeys.size()];
        Iterator iter = entityKeys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.keys[i++] = ((EntityKey)iter.next()).getIdentifier();
        }
        this.queryParameters = queryParameters;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollectionSubselect(session, this.keys, this.queryParameters.getPositionalParameterValues(), this.queryParameters.getPositionalParameterTypes(), this.queryParameters.getNamedParameters(), this.getKeyType());
    }

    protected StringBuffer whereString(String alias, String[] columnNames, int batchSize, String subquery) {
        return new StringBuffer().append(StringHelper.join(", ", StringHelper.qualify(alias, columnNames))).append(" in ").append('(').append(subquery).append(')');
    }
}

