/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private static final Log log;
    private final QueryableCollection collectionPersister;
    private final Type keyType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.loader.collection.CollectionLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public CollectionLoader(QueryableCollection persister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(persister, 1, session, enabledFilters);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(persister, batchSize, null, factory, enabledFilters);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.keyType = persister.getKeyType();
        this.collectionPersister = persister;
        String alias = this.generateRootAlias(persister.getRole());
        List associations = this.walkCollectionTree(persister, alias);
        this.initStatementString(persister, alias, associations, batchSize, subquery);
        this.initPersisters(associations);
        this.postInstantiate();
        log.debug((Object)("Static select for collection " + persister.getRole() + ": " + this.getSQLString()));
    }

    private void initPersisters(List associations) throws MappingException {
        int joins = associations.size();
        this.lockModeArray = ArrayHelper.fillArray(LockMode.NONE, joins);
        this.persisters = new Loadable[joins];
        this.owners = new int[joins];
        this.ownerAssociationType = new AssociationType[joins];
        int i = 0;
        while (i < joins) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)associations.get(i);
            this.persisters[i] = (Loadable)((Object)oj.getJoinable());
            this.owners[i] = oj.getOwner(associations);
            this.ownerAssociationType[i] = oj.getJoinableType();
            ++i;
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollection(session, id, this.keyType);
    }

    private void initStatementString(QueryableCollection persister, String alias, List associations, int batchSize, String subquery) throws MappingException {
        int joins = associations.size();
        this.suffixes = BasicLoader.generateSuffixes(joins);
        StringBuffer whereString = this.whereString(alias, persister.getKeyColumnNames(), batchSize, null);
        String filter = persister.filterFragment(alias, this.getEnabledFilters());
        if (filter.trim().length() > 0) {
            filter = String.valueOf(filter) + " and ";
        }
        if (filter.startsWith(" and ")) {
            filter = filter.substring(4);
        }
        whereString.insert(0, filter);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setSelectClause(String.valueOf(persister.selectFragment(alias)) + this.selectString(associations)).setFromClause(persister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        if (persister.hasOrdering()) {
            select.setOrderByClause(persister.getSQLOrderByString(alias));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load collection " + persister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path, Set visitedAssociations, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        int joinType = super.getJoinType(type, config, path, visitedAssociations, lhsTable, lhsColumns, nullable, currentDepth);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }

    protected Type getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + this.collectionPersister.getRole() + ')';
    }
}

