/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedEntityAliases;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.SQLQueryParser;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryReturnProcessor;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class SQLCustomQuery
implements CustomQuery {
    private final String[] entityNames;
    private final String collectionRole;
    private int collectionOwner;
    private final int[] entityOwners;
    private final LockMode[] lockModes;
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameters;
    private final Type[] scalarTypes;
    private final String[] scalarColumnAliases;
    private final EntityAliases[] entityDescriptors;

    public String getSQL() {
        return this.sql;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameters;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public String[] getEntityNames() {
        return this.entityNames;
    }

    public LockMode[] getLockModes() {
        return this.lockModes;
    }

    public EntityAliases[] getEntityAliases() {
        return this.entityDescriptors;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public int getCollectionOwner() {
        return this.collectionOwner;
    }

    public int[] getEntityOwners() {
        return this.entityOwners;
    }

    public String[] getScalarColumnAliases() {
        return this.scalarColumnAliases;
    }

    public Type[] getScalarTypes() {
        return this.scalarTypes;
    }

    public SQLCustomQuery(SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarQueryReturns, String sqlQuery, Collection additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, scalarQueryReturns, factory);
        processor.process();
        this.collectionOwner = processor.getCollectionOwner();
        this.collectionRole = processor.getCollectionPersister() == null ? null : processor.getCollectionPersister().getRole();
        QueryableCollection collectionPersister = processor.getCollectionPersister();
        String[] aliases = ArrayHelper.toStringArray(processor.getAliases());
        SQLLoadable[] entityPersisters = processor.getPersisters().toArray(new SQLLoadable[0]);
        this.lockModes = processor.getLockModes().toArray(new LockMode[0]);
        this.scalarColumnAliases = ArrayHelper.toStringArray(processor.getScalarColumnAliases());
        this.scalarTypes = ArrayHelper.toTypeArray(processor.getScalarTypes());
        String[] suffixes = BasicLoader.generateSuffixes(entityPersisters.length);
        SQLQueryParser parser = new SQLQueryParser(sqlQuery, processor.getAlias2Persister(), aliases, processor.getCollectionAlias(), collectionPersister, suffixes);
        if (!processor.isCollectionInitializer() && StringHelper.isNotEmpty(processor.getCollectionOwnerAlias())) {
            this.collectionOwner = parser.getPersisterIndex(processor.getCollectionOwnerAlias());
        }
        this.sql = parser.process();
        this.namedParameters = parser.getNamedParameters();
        this.entityNames = new String[entityPersisters.length];
        this.entityDescriptors = new EntityAliases[entityPersisters.length];
        int i = 0;
        while (i < entityPersisters.length) {
            SQLLoadable persister = entityPersisters[i];
            ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
            this.entityNames[i] = persister.getEntityName();
            this.entityDescriptors[i] = new GeneratedEntityAliases(entityPersisters[i], suffixes[i]);
            ++i;
        }
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
        Map alias2OwnerAlias = processor.getAlias2OwnerAlias();
        int[] ownersArray = new int[entityPersisters.length];
        int j = 0;
        while (j < aliases.length) {
            String ownerAlias = (String)alias2OwnerAlias.get(aliases[j]);
            ownersArray[j] = StringHelper.isNotEmpty(ownerAlias) ? parser.getPersisterIndex(ownerAlias) : -1;
            ++j;
        }
        if (ArrayHelper.isAllNegative(ownersArray)) {
            ownersArray = null;
        }
        this.entityOwners = ownersArray;
    }
}

