/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public final class PersisterFactory {
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS;
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.mapping.PersistentClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.hibernate.cache.CacheConcurrencyStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.hibernate.engine.SessionFactoryImplementor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.hibernate.engine.Mapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        PERSISTER_CONSTRUCTOR_ARGS = classArray;
        Class[] classArray2 = new Class[4];
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.hibernate.mapping.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz5;
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("org.hibernate.cache.CacheConcurrencyStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz6;
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("org.hibernate.cfg.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz7;
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            try {
                clazz8 = class$2 = Class.forName("org.hibernate.engine.SessionFactoryImplementor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz8;
        COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = classArray2;
    }

    private PersisterFactory() {
    }

    public static EntityPersister createClassPersister(PersistentClass model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Class persisterClass;
        block18: {
            block17: {
                persisterClass = model.getEntityPersisterClass();
                if (persisterClass == null) break block17;
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("org.hibernate.persister.entity.SingleTableEntityPersister");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (persisterClass != clazz) break block18;
            }
            return new SingleTableEntityPersister(model, cache, factory, cfg);
        }
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.hibernate.persister.entity.JoinedSubclassEntityPersister");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (persisterClass == clazz) {
            return new JoinedSubclassEntityPersister(model, cache, factory, cfg);
        }
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("org.hibernate.persister.entity.UnionSubclassEntityPersister");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (persisterClass == clazz2) {
            return new UnionSubclassEntityPersister(model, cache, factory, cfg);
        }
        return PersisterFactory.create(persisterClass, model, cache, factory, cfg);
    }

    public static CollectionPersister createCollectionPersister(Configuration cfg, Collection model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        Class persisterClass = model.getCollectionPersisterClass();
        if (persisterClass == null) {
            return model.isOneToMany() ? new OneToManyPersister(model, cache, cfg, factory) : new BasicCollectionPersister(model, cache, cfg, factory);
        }
        return PersisterFactory.create(persisterClass, cfg, model, cache, factory);
    }

    private static EntityPersister create(Class persisterClass, PersistentClass model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (EntityPersister)pc.newInstance(model, cache, factory, cfg);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    private static CollectionPersister create(Class persisterClass, Configuration cfg, Collection model, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (CollectionPersister)pc.newInstance(model, cache, cfg, factory);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)e;
            }
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
    }
}

