/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import java.security.Permission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.secure.HibernatePermission;

public class JACCConfiguration {
    private static final Log log;
    private final PolicyConfiguration policyConfiguration;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.secure.JACCConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public JACCConfiguration(String contextId) throws HibernateException {
        try {
            this.policyConfiguration = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(contextId, false);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("JACC provider class not found", cnfe);
        }
        catch (PolicyContextException pce) {
            throw new HibernateException("policy context exception occurred", pce);
        }
    }

    public void addPermission(String role, String entityName, String action) {
        HibernatePermission permission = new HibernatePermission(entityName, action);
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding permission to role " + role + ": " + permission));
        }
        try {
            this.policyConfiguration.addToRole(role, (Permission)permission);
        }
        catch (PolicyContextException pce) {
            throw new HibernateException("policy context exception occurred", pce);
        }
    }
}

