/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Assigned;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.EntityTuplizer;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.VersionProperty;
import org.hibernate.type.AbstractComponentType;

public abstract class AbstractTuplizer
implements EntityTuplizer {
    private final EntityMetamodel entityMetamodel;
    private final Getter idGetter;
    private final Setter idSetter;
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final boolean hasCustomAccessors;
    private final Instantiator instantiator;
    private final ProxyFactory proxyFactory;

    protected abstract EntityMode getEntityMode();

    protected abstract Getter buildPropertyGetter(Property var1, PersistentClass var2);

    protected abstract Setter buildPropertySetter(Property var1, PersistentClass var2);

    protected abstract Instantiator buildInstantiator(PersistentClass var1);

    protected abstract ProxyFactory buildProxyFactory(PersistentClass var1, Getter var2, Setter var3);

    public AbstractTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        this.entityMetamodel = entityMetamodel;
        if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
            this.idGetter = this.buildPropertyGetter(mappedEntity.getIdentifierProperty(), mappedEntity);
            this.idSetter = this.buildPropertySetter(mappedEntity.getIdentifierProperty(), mappedEntity);
        } else {
            this.idGetter = null;
            this.idSetter = null;
        }
        this.propertySpan = entityMetamodel.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator iter = mappedEntity.getPropertyClosureIterator();
        boolean foundCustomAccessor = false;
        int i = 0;
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            this.getters[i] = this.buildPropertyGetter(property, mappedEntity);
            this.setters[i] = this.buildPropertySetter(property, mappedEntity);
            if (!property.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            ++i;
        }
        this.hasCustomAccessors = foundCustomAccessor;
        this.instantiator = this.buildInstantiator(mappedEntity);
        this.proxyFactory = entityMetamodel.isLazy() ? this.buildProxyFactory(mappedEntity, this.idGetter, this.idSetter) : null;
    }

    public String getEntityName() {
        return this.entityMetamodel.getName();
    }

    public Serializable getIdentifier(Object entity) throws HibernateException {
        Object id;
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            id = entity;
        } else {
            if (this.idGetter == null) {
                throw new HibernateException("The class has no identifier property: " + this.getEntityName());
            }
            id = this.idGetter.get(entity);
        }
        try {
            return (Serializable)id;
        }
        catch (ClassCastException cce) {
            StringBuffer msg = new StringBuffer("Identifier classes must be serializable. ");
            if (id != null) {
                msg.append(String.valueOf(id.getClass().getName()) + " is not serializable. ");
            }
            if (cce.getMessage() != null) {
                msg.append(cce.getMessage());
            }
            throw new ClassCastException(msg.toString());
        }
    }

    public void setIdentifier(Object entity, Serializable id) throws HibernateException {
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            if (entity != id) {
                AbstractComponentType copier = (AbstractComponentType)this.entityMetamodel.getIdentifierProperty().getType();
                copier.setPropertyValues(entity, copier.getPropertyValues((Object)id, this.getEntityMode()), this.getEntityMode());
            }
        } else if (this.idSetter != null) {
            this.idSetter.set(entity, id, this.getFactory());
        }
    }

    public void resetIdentifier(Object entity, Serializable currentId, Object currentVersion) {
        if (!(this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator() instanceof Assigned)) {
            Serializable result = this.entityMetamodel.getIdentifierProperty().getUnsavedValue().getDefaultValue(currentId);
            this.setIdentifier(entity, result);
            VersionProperty versionProperty = this.entityMetamodel.getVersionProperty();
            if (this.entityMetamodel.isVersioned()) {
                this.setPropertyValue(entity, this.entityMetamodel.getVersionPropertyIndex(), versionProperty.getUnsavedValue().getDefaultValue(currentVersion));
            }
        }
    }

    public Object getVersion(Object entity) throws HibernateException {
        if (!this.entityMetamodel.isVersioned()) {
            return null;
        }
        return this.getters[this.entityMetamodel.getVersionPropertyIndex()].get(entity);
    }

    protected boolean shouldGetAllProperties(Object entity) {
        return !this.hasUninitializedLazyProperties(entity);
    }

    public Object[] getPropertyValues(Object entity) throws HibernateException {
        boolean getAll = this.shouldGetAllProperties(entity);
        int span = this.entityMetamodel.getPropertySpan();
        Object[] result = new Object[span];
        int j = 0;
        while (j < span) {
            StandardProperty property = this.entityMetamodel.getProperties()[j];
            result[j] = getAll || !property.isLazy() ? this.getters[j].get(entity) : LazyPropertyInitializer.UNFETCHED_PROPERTY;
            ++j;
        }
        return result;
    }

    public Object[] getPropertyValuesToInsert(Object entity, SessionImplementor session) throws HibernateException {
        int span = this.entityMetamodel.getPropertySpan();
        Object[] result = new Object[span];
        int j = 0;
        while (j < span) {
            result[j] = this.getters[j].getForInsert(entity, session);
            ++j;
        }
        return result;
    }

    public Object getPropertyValue(Object entity, int i) throws HibernateException {
        return this.getters[i].get(entity);
    }

    public Object getPropertyValue(Object entity, String propertyName) throws HibernateException {
        return this.getPropertyValue(entity, this.entityMetamodel.getPropertyIndex(propertyName));
    }

    public void setPropertyValues(Object entity, Object[] values) throws HibernateException {
        boolean setAll = !this.entityMetamodel.hasLazyProperties();
        int j = 0;
        while (j < this.entityMetamodel.getPropertySpan()) {
            if (setAll || values[j] != LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                this.setters[j].set(entity, values[j], this.getFactory());
            }
            ++j;
        }
    }

    public void setPropertyValue(Object entity, int i, Object value) throws HibernateException {
        this.setters[i].set(entity, value, this.getFactory());
    }

    public void setPropertyValue(Object entity, String propertyName, Object value) throws HibernateException {
        this.setters[this.entityMetamodel.getPropertyIndex(propertyName)].set(entity, value, this.getFactory());
    }

    public final Object instantiate(Serializable id) throws HibernateException {
        Object result = this.instantiator.instantiate(id);
        if (id != null) {
            this.setIdentifier(result, id);
        }
        return result;
    }

    public final Object instantiate() throws HibernateException {
        return this.instantiator.instantiate(null);
    }

    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
    }

    public boolean hasUninitializedLazyProperties(Object entity) {
        return false;
    }

    public final boolean isInstance(Object object) {
        return this.instantiator.isInstance(object);
    }

    public boolean hasProxy() {
        return this.entityMetamodel.isLazy();
    }

    public Object createProxy(Serializable id, SessionImplementor session) throws HibernateException {
        return this.getProxyFactory().getProxy(id, session);
    }

    public boolean isLifecycleImplementor() {
        return false;
    }

    public boolean isValidatableImplementor() {
        return false;
    }

    protected final EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    protected final SessionFactoryImplementor getFactory() {
        return this.entityMetamodel.getSessionFactory();
    }

    protected final Instantiator getInstantiator() {
        return this.instantiator;
    }

    protected final ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + this.getEntityMetamodel().getName() + ')';
    }
}

