/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.proxy.Dom4jProxyFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.AbstractTuplizer;
import org.hibernate.tuple.Dom4jInstantiator;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.Instantiator;
import org.hibernate.type.AbstractComponentType;

public class Dom4jTuplizer
extends AbstractTuplizer {
    static final Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.tuple.Dom4jTuplizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    Dom4jTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
    }

    public EntityMode getEntityMode() {
        return EntityMode.DOM4J;
    }

    private PropertyAccessor buildPropertyAccessor(Property mappedProperty) {
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getPropertyAccessor(null);
        }
        return PropertyAccessorFactory.getDom4jPropertyAccessor(mappedProperty.getNodeName(), mappedProperty.getType(), this.getEntityMetamodel().getSessionFactory());
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return this.buildPropertyAccessor(mappedProperty).getSetter(null, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new Dom4jInstantiator(persistentClass.getNodeName());
    }

    public Serializable getIdentifier(Object entityOrId) throws HibernateException {
        if (entityOrId instanceof Element) {
            return super.getIdentifier(entityOrId);
        }
        return (Serializable)entityOrId;
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        HashSet proxyInterfaces = new HashSet();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.hibernate.proxy.HibernateProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        proxyInterfaces.add(clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.dom4j.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        proxyInterfaces.add(clazz2);
        Dom4jProxyFactory pf = new Dom4jProxyFactory();
        try {
            String string = this.getEntityName();
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.dom4j.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            pf.postInstantiate(string, clazz3, proxyInterfaces, null, null, mappingInfo.hasEmbeddedIdentifier() ? (AbstractComponentType)mappingInfo.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            log.warn((Object)("could not create proxy factory for:" + this.getEntityName()), (Throwable)he);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.dom4j.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getConcreteProxyClass() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.dom4j.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isLazyPropertyLoadingAvailable() {
        return false;
    }
}

