/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;

public class DateType
extends MutableType
implements IdentifierType,
LiteralType {
    static /* synthetic */ Class class$0;

    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getDate(name);
    }

    public Class getReturnedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        java.sql.Date sqlDate = value instanceof java.sql.Date ? (java.sql.Date)value : new java.sql.Date(((Date)value).getTime());
        st.setDate(index, sqlDate);
    }

    public int sqlType() {
        return 91;
    }

    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime((Date)x);
        calendar2.setTime((Date)y);
        return Hibernate.CALENDAR_DATE.isEqual(calendar1, calendar2);
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)x);
        return Hibernate.CALENDAR_DATE.getHashCode(calendar, entityMode);
    }

    public String getName() {
        return "date";
    }

    public String toString(Object val) {
        return new SimpleDateFormat("dd MMMM yyyy").format((Date)val);
    }

    public Object deepCopyNotNull(Object value) {
        return new java.sql.Date(((Date)value).getTime());
    }

    public Object stringToObject(String xml) throws Exception {
        return DateFormat.getDateInstance().parse(xml);
    }

    public String objectToSQLString(Object value) throws Exception {
        return String.valueOf('\'') + value.toString() + '\'';
    }

    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new SimpleDateFormat().parse(xml);
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse XML", pe);
        }
    }
}

