/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class DynamicComponentType
extends AbstractType
implements AbstractComponentType {
    private String[] propertyNames;
    private final boolean[] propertyNullability;
    private Type[] propertyTypes;
    private int propertySpan;
    private final Cascades.CascadeStyle[] cascade;
    private final FetchMode[] joinedFetch;
    static /* synthetic */ Class class$0;

    public DynamicComponentType(String[] propertyNames, Type[] propertyTypes, boolean[] nullabilities, FetchMode[] joinedFetch, Cascades.CascadeStyle[] cascade) {
        this.propertyNames = propertyNames;
        this.propertyNullability = nullabilities;
        this.propertyTypes = propertyTypes;
        this.joinedFetch = joinedFetch;
        this.cascade = cascade;
        this.propertySpan = propertyTypes.length;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public Cascades.CascadeStyle getCascadeStyle(int i) {
        return this.cascade[i];
    }

    public FetchMode getFetchMode(int i) {
        return this.joinedFetch[i];
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component, session.getEntityMode());
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return ((Map)component).get(this.propertyNames[i]);
    }

    public Object[] getPropertyValues(Object component, EntityMode entityMode) throws HibernateException {
        Map bean = (Map)component;
        Object[] result = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            result[i] = bean.get(this.propertyNames[i]);
            ++i;
        }
        return result;
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public Object instantiate() throws HibernateException {
        return new HashMap();
    }

    public void setPropertyValues(Object component, Object[] values, EntityMode entityMode) throws HibernateException {
        Map map = (Map)component;
        int i = 0;
        while (i < this.propertySpan) {
            map.put(this.propertyNames[i], values[i]);
            ++i;
        }
    }

    public Object deepCopy(Object component, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component, entityMode);
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.propertyTypes[i].deepCopy(values[i], entityMode, factory);
            ++i;
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, values, entityMode);
        return result;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (original == target) {
            return target;
        }
        EntityMode entityMode = session.getEntityMode();
        Object[] values = TypeFactory.replace(this.getPropertyValues(original, entityMode), this.getPropertyValues(target, entityMode), this.propertyTypes, session, owner, copyCache);
        Object result = target == null ? this.instantiate() : target;
        this.setPropertyValues(result, values, entityMode);
        return result;
    }

    public boolean isSame(Object x, Object y, EntityMode entityMode) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (!this.propertyTypes[i].isSame(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), entityMode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (!this.propertyTypes[i].isEqual(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), entityMode, factory)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (!this.propertyTypes[i].isEqual(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), entityMode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        if (x == y) {
            return 0;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        int i = 0;
        while (i < this.propertySpan) {
            int propertyCompare = this.propertyTypes[i].compare(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), entityMode);
            if (propertyCompare != 0) {
                return propertyCompare;
            }
            ++i;
        }
        return 0;
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        int result = 17;
        Map xbean = (Map)x;
        int i = 0;
        while (i < this.propertySpan) {
            Object y = xbean.get(this.propertyNames[i]);
            result *= 37;
            if (y != null) {
                result += this.propertyTypes[i].getHashCode(y, entityMode);
            }
            ++i;
        }
        return result;
    }

    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor factory) {
        int result = 17;
        Map xbean = (Map)x;
        int i = 0;
        while (i < this.propertySpan) {
            Object y = xbean.get(this.propertyNames[i]);
            result *= 37;
            if (y != null) {
                result += this.propertyTypes[i].getHashCode(y, entityMode, factory);
            }
            ++i;
        }
        return result;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (this.propertyTypes[i].isDirty(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), session)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        int i = 0;
        while (i < this.propertySpan) {
            span += this.propertyTypes[i].getColumnSpan(mapping);
            ++i;
        }
        return span;
    }

    public String getName() {
        return "dynamic-component" + ArrayHelper.toString(this.propertyNames);
    }

    public boolean isMutable() {
        return true;
    }

    private Object[] nullSafeGetValues(Object value, EntityMode entityMode) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value, entityMode);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value, session.getEntityMode());
        int i = 0;
        while (i < this.propertySpan) {
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.propertyTypes[i].getColumnSpan(session.getFactory());
            ++i;
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value, session.getEntityMode());
        int loc = 0;
        int i = 0;
        while (i < this.propertySpan) {
            int len = this.propertyTypes[i].getColumnSpan(session.getFactory());
            boolean[] subsettable = new boolean[len];
            System.arraycopy(settable, loc, subsettable, 0, len);
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, subsettable, session);
            begin += len;
            loc += len;
            ++i;
        }
    }

    public Class getReturnedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        int i = 0;
        while (i < this.propertySpan) {
            int[] subtypes = this.propertyTypes[i].sqlTypes(mapping);
            int j = 0;
            while (j < subtypes.length) {
                sqlTypes[n++] = subtypes[j];
                ++j;
            }
            ++i;
        }
        return sqlTypes;
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            int length = this.propertyTypes[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i].hydrate(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
            ++i;
        }
        return notNull ? values : null;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value != null) {
            Object[] values = (Object[])value;
            Map result = (Map)this.instantiate();
            int i = 0;
            while (i < this.propertySpan) {
                result.put(this.propertyNames[i], this.propertyTypes[i].resolve(values[i], session, owner));
                ++i;
            }
            return result;
        }
        return null;
    }

    public Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(value, session, owner);
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        Object[] currentValues = this.getPropertyValues(current, session);
        Object[] oldValues = (Object[])old;
        int i = 0;
        while (i < currentValues.length) {
            if (this.propertyTypes[i].isModified(oldValues[i], currentValues[i], session)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean isComponentType() {
        return true;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return xml;
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        AbstractType.replaceNode(node, (Element)value);
    }
}

