/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.util.ArrayHelper;

public class OneToOneType
extends EntityType {
    private final ForeignKeyDirection foreignKeyType;

    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    public OneToOneType(String entityName, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean isEmbeddedInXML) {
        super(entityName, uniqueKeyPropertyName, isEmbeddedInXML);
        this.foreignKeyType = foreignKeyType;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) {
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) {
    }

    public boolean isOneToOne() {
        return true;
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) {
        return false;
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) {
        return false;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return this.foreignKeyType;
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return session.getEntityIdentifier(owner);
    }

    protected Object resolveIdentifier(Serializable id, SessionImplementor session) throws HibernateException {
        String entityName = this.getAssociatedEntityName();
        return this.isNullable() ? session.internalLoadOneToOne(entityName, id) : session.internalLoad(entityName, id);
    }

    public boolean isNullable() {
        return this.foreignKeyType == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public boolean useLHSPrimaryKey() {
        return true;
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return null;
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(session.getEntityIdentifier(owner), session, owner);
    }
}

