/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class TypeFactory {
    private static final Map BASIC_TYPES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;
    static /* synthetic */ Class class$31;
    static /* synthetic */ Class class$32;
    static /* synthetic */ Class class$33;
    static /* synthetic */ Class class$34;
    static /* synthetic */ Class class$35;

    static {
        Class<?> clazz;
        HashMap<String, Type> basics = new HashMap<String, Type>();
        basics.put(Boolean.TYPE.getName(), Hibernate.BOOLEAN);
        basics.put(Long.TYPE.getName(), Hibernate.LONG);
        basics.put(Short.TYPE.getName(), Hibernate.SHORT);
        basics.put(Integer.TYPE.getName(), Hibernate.INTEGER);
        basics.put(Byte.TYPE.getName(), Hibernate.BYTE);
        basics.put(Float.TYPE.getName(), Hibernate.FLOAT);
        basics.put(Double.TYPE.getName(), Hibernate.DOUBLE);
        basics.put(Character.TYPE.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.CHARACTER.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.INTEGER.getName(), Hibernate.INTEGER);
        basics.put(Hibernate.STRING.getName(), Hibernate.STRING);
        basics.put(Hibernate.DATE.getName(), Hibernate.DATE);
        basics.put(Hibernate.TIME.getName(), Hibernate.TIME);
        basics.put(Hibernate.TIMESTAMP.getName(), Hibernate.TIMESTAMP);
        basics.put(Hibernate.LOCALE.getName(), Hibernate.LOCALE);
        basics.put(Hibernate.CALENDAR.getName(), Hibernate.CALENDAR);
        basics.put(Hibernate.CALENDAR_DATE.getName(), Hibernate.CALENDAR_DATE);
        basics.put(Hibernate.CURRENCY.getName(), Hibernate.CURRENCY);
        basics.put(Hibernate.TIMEZONE.getName(), Hibernate.TIMEZONE);
        basics.put(Hibernate.CLASS.getName(), Hibernate.CLASS);
        basics.put(Hibernate.TRUE_FALSE.getName(), Hibernate.TRUE_FALSE);
        basics.put(Hibernate.YES_NO.getName(), Hibernate.YES_NO);
        basics.put(Hibernate.BINARY.getName(), Hibernate.BINARY);
        basics.put(Hibernate.TEXT.getName(), Hibernate.TEXT);
        basics.put(Hibernate.BLOB.getName(), Hibernate.BLOB);
        basics.put(Hibernate.CLOB.getName(), Hibernate.CLOB);
        basics.put(Hibernate.BIG_DECIMAL.getName(), Hibernate.BIG_DECIMAL);
        basics.put(Hibernate.SERIALIZABLE.getName(), Hibernate.SERIALIZABLE);
        basics.put(Hibernate.OBJECT.getName(), Hibernate.OBJECT);
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz2.getName(), Hibernate.BOOLEAN);
        Class<?> clazz3 = class$9;
        if (clazz3 == null) {
            try {
                clazz3 = class$9 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz3.getName(), Hibernate.LONG);
        Class<?> clazz4 = class$10;
        if (clazz4 == null) {
            try {
                clazz4 = class$10 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz4.getName(), Hibernate.SHORT);
        Class<?> clazz5 = class$11;
        if (clazz5 == null) {
            try {
                clazz5 = class$11 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz5.getName(), Hibernate.INTEGER);
        Class<?> clazz6 = class$12;
        if (clazz6 == null) {
            try {
                clazz6 = class$12 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz6.getName(), Hibernate.BYTE);
        Class<?> clazz7 = class$13;
        if (clazz7 == null) {
            try {
                clazz7 = class$13 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz7.getName(), Hibernate.FLOAT);
        Class<?> clazz8 = class$14;
        if (clazz8 == null) {
            try {
                clazz8 = class$14 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz8.getName(), Hibernate.DOUBLE);
        Class<?> clazz9 = class$15;
        if (clazz9 == null) {
            try {
                clazz9 = class$15 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz9.getName(), Hibernate.CHARACTER);
        Class<?> clazz10 = class$16;
        if (clazz10 == null) {
            try {
                clazz10 = class$16 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz10.getName(), Hibernate.STRING);
        Class<?> clazz11 = class$17;
        if (clazz11 == null) {
            try {
                clazz11 = class$17 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz11.getName(), Hibernate.TIMESTAMP);
        Class<?> clazz12 = class$18;
        if (clazz12 == null) {
            try {
                clazz12 = class$18 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz12.getName(), Hibernate.TIME);
        Class<?> clazz13 = class$19;
        if (clazz13 == null) {
            try {
                clazz13 = class$19 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz13.getName(), Hibernate.TIMESTAMP);
        Class<?> clazz14 = class$20;
        if (clazz14 == null) {
            try {
                clazz14 = class$20 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz14.getName(), Hibernate.DATE);
        Class<?> clazz15 = class$21;
        if (clazz15 == null) {
            try {
                clazz15 = class$21 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz15.getName(), Hibernate.BIG_DECIMAL);
        Class<?> clazz16 = class$22;
        if (clazz16 == null) {
            try {
                clazz16 = class$22 = Class.forName("java.util.Locale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz16.getName(), Hibernate.LOCALE);
        Class<?> clazz17 = class$23;
        if (clazz17 == null) {
            try {
                clazz17 = class$23 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz17.getName(), Hibernate.CALENDAR);
        Class<?> clazz18 = class$24;
        if (clazz18 == null) {
            try {
                clazz18 = class$24 = Class.forName("java.util.GregorianCalendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz18.getName(), Hibernate.CALENDAR);
        if (CurrencyType.CURRENCY_CLASS != null) {
            basics.put(CurrencyType.CURRENCY_CLASS.getName(), Hibernate.CURRENCY);
        }
        if ((clazz = class$25) == null) {
            try {
                clazz = class$25 = Class.forName("java.util.TimeZone");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz.getName(), Hibernate.TIMEZONE);
        Class<?> clazz19 = class$26;
        if (clazz19 == null) {
            try {
                clazz19 = class$26 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz19.getName(), Hibernate.OBJECT);
        Class<?> clazz20 = class$27;
        if (clazz20 == null) {
            try {
                clazz20 = class$27 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz20.getName(), Hibernate.CLASS);
        Class<?> clazz21 = class$28;
        if (clazz21 == null) {
            try {
                clazz21 = class$28 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz21.getName(), Hibernate.BINARY);
        basics.put("byte[]", Hibernate.BINARY);
        Class<?> clazz22 = class$29;
        if (clazz22 == null) {
            try {
                clazz22 = class$29 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz22.getName(), Hibernate.BLOB);
        Class<?> clazz23 = class$30;
        if (clazz23 == null) {
            try {
                clazz23 = class$30 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz23.getName(), Hibernate.CLOB);
        Class<?> clazz24 = class$31;
        if (clazz24 == null) {
            try {
                clazz24 = class$31 = Class.forName("java.io.Serializable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        basics.put(clazz24.getName(), Hibernate.SERIALIZABLE);
        BASIC_TYPES = Collections.unmodifiableMap(basics);
    }

    private TypeFactory() {
        throw new UnsupportedOperationException();
    }

    public static Type oneToOne(String persistentClass, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean isEmbeddedInXML) {
        return new OneToOneType(persistentClass, foreignKeyType, uniqueKeyPropertyName, isEmbeddedInXML);
    }

    public static Type manyToOne(String persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static Type manyToOne(String persistentClass, String uniqueKeyPropertyName, boolean isEmbeddedInXML) {
        return new ManyToOneType(persistentClass, uniqueKeyPropertyName, isEmbeddedInXML);
    }

    public static Type basic(String name) {
        return (Type)BASIC_TYPES.get(name);
    }

    public static Type heuristicType(String typeName) throws MappingException {
        return TypeFactory.heuristicType(typeName, null);
    }

    public static Type heuristicType(String typeName, Properties parameters) throws MappingException {
        Type type = TypeFactory.basic(typeName);
        if (type == null) {
            Class typeClass;
            try {
                typeClass = ReflectHelper.classForName(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                typeClass = null;
            }
            if (typeClass != null) {
                Class<?> clazz = class$32;
                if (clazz == null) {
                    try {
                        clazz = class$32 = Class.forName("org.hibernate.type.Type");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(typeClass)) {
                    try {
                        type = (Type)typeClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new MappingException("Could not instantiate Type " + typeClass.getName() + ": " + e);
                    }
                }
                Class<?> clazz2 = class$33;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$33 = Class.forName("org.hibernate.usertype.CompositeUserType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(typeClass)) {
                    type = new CompositeCustomType(typeClass, parameters);
                } else {
                    Class<?> clazz3 = class$34;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$34 = Class.forName("org.hibernate.usertype.UserType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3.isAssignableFrom(typeClass)) {
                        type = new CustomType(typeClass, parameters);
                    } else {
                        Class<?> clazz4 = class$35;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$35 = Class.forName("org.hibernate.classic.Lifecycle");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz4.isAssignableFrom(typeClass)) {
                            type = Hibernate.entity(typeClass);
                        } else {
                            Class<?> clazz5 = class$31;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$31 = Class.forName("java.io.Serializable");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz5.isAssignableFrom(typeClass)) {
                                type = Hibernate.serializable(typeClass);
                            }
                        }
                    }
                }
            }
        }
        return type;
    }

    public static CollectionType customCollection(String typeName, String role, String propertyRef, boolean embedded) {
        Class typeClass;
        try {
            typeClass = ReflectHelper.classForName(typeName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("user colllection type class not found: " + typeName, cnfe);
        }
        return new CustomCollectionType(typeClass, role, propertyRef, embedded);
    }

    public static CollectionType array(String role, String propertyRef, boolean embedded, Class elementClass) {
        return new ArrayType(role, propertyRef, elementClass, embedded);
    }

    public static CollectionType list(String role, String propertyRef, boolean embedded) {
        return new ListType(role, propertyRef, embedded);
    }

    public static CollectionType bag(String role, String propertyRef, boolean embedded) {
        return new BagType(role, propertyRef, embedded);
    }

    public static CollectionType idbag(String role, String propertyRef, boolean embedded) {
        return new IdentifierBagType(role, propertyRef, embedded);
    }

    public static CollectionType map(String role, String propertyRef, boolean embedded) {
        return new MapType(role, propertyRef, embedded);
    }

    public static CollectionType set(String role, String propertyRef, boolean embedded) {
        return new SetType(role, propertyRef, embedded);
    }

    public static CollectionType sortedMap(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedMapType(role, propertyRef, comparator, embedded);
    }

    public static CollectionType sortedSet(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedSetType(role, propertyRef, comparator, embedded);
    }

    public static void deepCopy(Object[] values, Type[] types, boolean[] copy, Object[] target, SessionImplementor session) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            if (copy[i]) {
                target[i] = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || values[i] == BackrefPropertyAccessor.UNKNOWN ? values[i] : types[i].deepCopy(values[i], session.getEntityMode(), session.getFactory());
            }
            ++i;
        }
    }

    public static int[] findDirty(Type[] types, Object[] x, Object[] y, boolean[] check, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int i = 0;
        while (i < types.length) {
            if (check[i] && types[i].isDirty(x[i], y[i], session)) {
                if (results == null) {
                    results = new int[types.length];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    public static int[] findModified(Type[] types, Object[] old, Object[] current, boolean[] check, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int i = 0;
        while (i < types.length) {
            if (check[i] && types[i].isModified(old[i], current[i], session)) {
                if (results == null) {
                    results = new int[types.length];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    public static Object[] assemble(Serializable[] row, Type[] types, SessionImplementor session, Object owner) throws HibernateException {
        Object[] assembled = new Object[row.length];
        int i = 0;
        while (i < types.length) {
            assembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? row[i] : types[i].assemble(row[i], session, owner);
            ++i;
        }
        return assembled;
    }

    public static Serializable[] disassemble(Object[] row, Type[] types, SessionImplementor session, Object owner) throws HibernateException {
        Serializable[] disassembled = new Serializable[row.length];
        int i = 0;
        while (i < row.length) {
            disassembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? (Serializable)row[i] : types[i].disassemble(row[i], session, owner);
            ++i;
        }
        return disassembled;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        Object[] copied = new Object[original.length];
        int i = 0;
        while (i < types.length) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == BackrefPropertyAccessor.UNKNOWN ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache);
            ++i;
        }
        return copied;
    }

    public static int[] findDirty(StandardProperty[] properties, Object[] x, Object[] y, boolean anyUninitializedProperties, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        int i = 0;
        while (i < span) {
            boolean dirty;
            boolean bl = dirty = TypeFactory.isCheckable(properties[i], anyUninitializedProperties) && properties[i].getType().isDirty(x[i], y[i], session);
            if (dirty) {
                if (results == null) {
                    results = new int[span];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    public static int[] findModified(StandardProperty[] properties, Object[] x, Object[] y, boolean anyUninitializedProperties, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        int i = 0;
        while (i < span) {
            boolean modified;
            boolean bl = modified = TypeFactory.isCheckable(properties[i], anyUninitializedProperties) && properties[i].getType().isModified(x[i], y[i], session);
            if (modified) {
                if (results == null) {
                    results = new int[span];
                }
                results[count++] = i;
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    private static boolean isCheckable(StandardProperty property, boolean anyUninitializedProperties) {
        return anyUninitializedProperties ? property.isCheckable() : property.isUpdateable();
    }
}

