/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public final class ReflectHelper {
    private static final Log log;
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR;
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    private static final Class[] NO_PARAM;
    private static final Method OBJECT_HASHCODE;
    public static final String PROPERTY_GET_EXCEPTION = "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)";
    public static final String PROPERTY_SET_EXCEPTION = "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Method hash;
        Method eq;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.util.ReflectHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
        NO_CLASSES = new Class[0];
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        OBJECT = classArray;
        NO_PARAM = new Class[0];
        try {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            eq = clazz3.getMethod("equals", OBJECT);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            hash = clazz4.getMethod("hashCode", NO_PARAM);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", e);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
    }

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method hashCode;
        try {
            hashCode = clazz.getMethod("hashCode", NO_PARAM);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static Class reflectedPropertyClass(String className, String name) throws MappingException {
        try {
            Class clazz = ReflectHelper.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnType();
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, cnfe);
        }
    }

    private static Getter getter(Class clazz, String name) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return DIRECT_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
    }

    public static Getter getGetter(Class theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name);
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (Exception exception) {
            return Class.forName(name);
        }
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static FastClass getFastClass(Class clazz) {
        try {
            return FastClass.create((Class)clazz);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BulkBean getBulkBean(Class clazz, String[] getterNames, String[] setterNames, Class[] types, FastClass fastClass) {
        try {
            BulkBean optimizer = BulkBean.create((Class)clazz, (String[])getterNames, (String[])setterNames, (Class[])types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    return null;
                }
                Object instance = fastClass.newInstance();
                optimizer.setPropertyValues(instance, optimizer.getPropertyValues(instance));
            }
            return optimizer;
        }
        catch (Throwable t) {
            int index;
            String message = "reflection optimizer disabled for: " + clazz.getName() + ", " + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkBeanException && (index = ((BulkBeanException)t).getIndex()) >= 0) {
                message = String.valueOf(message) + " (property " + setterNames[index] + ")";
            }
            log.debug((Object)message);
            return null;
        }
    }

    public static Constructor getConstructor(Class clazz, Type[] types) throws PropertyNotFoundException {
        Constructor<?>[] candidates = clazz.getConstructors();
        int i = 0;
        while (i < candidates.length) {
            Constructor<?> constructor = candidates[i];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == types.length) {
                boolean found = true;
                int j = 0;
                while (j < params.length) {
                    boolean ok;
                    boolean bl = ok = params[j].isAssignableFrom(types[j].getReturnedClass()) || types[j] instanceof PrimitiveType && params[j] == ((PrimitiveType)types[j]).getPrimitiveClass();
                    if (!ok) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    if (!ReflectHelper.isPublic(clazz, constructor)) {
                        constructor.setAccessible(true);
                    }
                    return constructor;
                }
            }
            ++i;
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static String getPropertyName(Throwable t, BulkBean optimizer) {
        if (t instanceof BulkBeanException) {
            return optimizer.getSetters()[((BulkBeanException)t).getIndex()];
        }
        return "?";
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ReflectHelper() {
    }
}

