/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.util.ResourceClosedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadPoolAsynchronousRunner
implements AsynchronousRunner {
    static final int POLL_FOR_STOP_INTERVAL = 5000;
    static final int DEADLOCK_DETECTOR_INTERVAL = 10000;
    Timer deadlockDetectorTimer;
    HashSet managed = new HashSet();
    HashSet available = new HashSet();
    LinkedList pendingTasks = new LinkedList();

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, Timer deadlockDetectorTimer) {
        this.deadlockDetectorTimer = deadlockDetectorTimer;
        for (int i = 0; i < num_threads; ++i) {
            PoolThread t = new PoolThread(i, daemon);
            this.managed.add(t);
            this.available.add(t);
            t.start();
        }
        deadlockDetectorTimer.schedule((TimerTask)new DeadlockDetector(), 10000L, 10000L);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon) {
        this(num_threads, daemon, new Timer());
    }

    public synchronized void postRunnable(Runnable r) {
        try {
            this.pendingTasks.add(r);
            this.notifyAll();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new ResourceClosedException("Attempted to use a ThreadPoolAsynchronousRunner in a closed or broken state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean skip_remaining_tasks) {
        HashSet managedCopy;
        ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            if (this.managed == null) {
                return;
            }
            managedCopy = (HashSet)this.managed.clone();
            this.managed = null;
            this.deadlockDetectorTimer.cancel();
            this.deadlockDetectorTimer = null;
        }
        Iterator ii = managedCopy.iterator();
        while (ii.hasNext()) {
            PoolThread stopMe = (PoolThread)ii.next();
            stopMe.gentleStop();
            if (!skip_remaining_tasks) continue;
            stopMe.interrupt();
        }
        threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            if (!skip_remaining_tasks) {
                Iterator ii2 = this.pendingTasks.iterator();
                while (ii2.hasNext()) {
                    Runnable r = (Runnable)ii2.next();
                    new Thread(r).start();
                    ii2.remove();
                }
            }
            this.available = null;
            this.pendingTasks = null;
        }
    }

    public void close() {
        this.close(true);
    }

    class DeadlockDetector
    extends TimerTask {
        LinkedList last = null;
        LinkedList current = null;

        DeadlockDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean run_tasks = false;
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                if (ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                    this.last = null;
                    return;
                }
                this.current = (LinkedList)ThreadPoolAsynchronousRunner.this.pendingTasks.clone();
                if (this.current.equals(this.last)) {
                    System.err.println(this + " -- APPARENT DEADLOCK!!! Creating emergency threads for unassigned pending tasks!");
                    ThreadPoolAsynchronousRunner.this.pendingTasks.clear();
                    run_tasks = true;
                }
            }
            if (run_tasks) {
                Iterator ii = this.current.iterator();
                while (ii.hasNext()) {
                    new Thread((Runnable)ii.next()).start();
                }
                this.last = null;
            } else {
                this.last = this.current;
            }
        }
    }

    class PoolThread
    extends Thread {
        boolean should_stop;

        PoolThread(int index, boolean daemon) {
            this.setName(this.getClass().getName() + "-#" + index);
            this.setDaemon(daemon);
        }

        private synchronized boolean shouldStop() {
            return this.should_stop;
        }

        private synchronized void gentleStop() {
            this.should_stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner;
                    Object var6_6;
                    Runnable myTask;
                    ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner2 = ThreadPoolAsynchronousRunner.this;
                    synchronized (threadPoolAsynchronousRunner2) {
                        boolean stop;
                        while (!(stop = this.shouldStop()) && ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                            ThreadPoolAsynchronousRunner.this.wait(5000L);
                        }
                        if (stop) {
                            return;
                        }
                        if (!ThreadPoolAsynchronousRunner.this.available.remove(this)) {
                            throw new InternalError("An unavailable PoolThread tried to check itself out!!!");
                        }
                        myTask = (Runnable)ThreadPoolAsynchronousRunner.this.pendingTasks.remove(0);
                    }
                    try {
                        try {
                            myTask.run();
                        }
                        catch (RuntimeException e) {
                            System.err.println(this + " -- caught unexpected Exception while executing posted task.");
                            e.printStackTrace();
                            var6_6 = null;
                            threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                            synchronized (threadPoolAsynchronousRunner) {
                                if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                                    throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                                }
                                continue;
                            }
                        }
                        var6_6 = null;
                        threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                        synchronized (threadPoolAsynchronousRunner) {
                            if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                                throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                            }
                            throw throwable;
                        }
                    }
                    synchronized (threadPoolAsynchronousRunner) {
                        if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                            throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

