/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PoolConfig {
    public static final String INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    public static final String MIN_POOL_SIZE = "c3p0.minPoolSize";
    public static final String MAX_POOL_SIZE = "c3p0.maxPoolSize";
    public static final String IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    public static final String MAX_IDLE_TIME = "c3p0.maxIdleTime";
    public static final String PROPERTY_CYCLE = "c3p0.propertyCycle";
    public static final String MAX_STATEMENTS = "c3p0.maxStatements";
    public static final String ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    public static final String TEST_CONNECTION_ON_CHECKOUT = "c3p0.testConnectionOnCheckout";
    public static final String CONNECTION_TESTER_CLASS_NAME = "c3p0.connectionTesterClassName";
    public static final String AUTO_COMMIT_ON_CLOSE = "c3p0.autoCommitOnClose";
    public static final String FORCE_IGNORE_UNRESOLVED_TRANSACTIONS = "c3p0.forceIgnoreUnresolvedTransactions";
    public static final String NUM_HELPER_THREADS = "c3p0.numHelperThreads";
    public static final String FACTORY_CLASS_LOCATION = "c3p0.factoryClassLocation";
    public static final String DEFAULT_CONFIG_RSRC_PATH = "/c3p0.properties";
    static final PoolConfig DEFAULTS;
    int maxStatements;
    int initialPoolSize;
    int minPoolSize;
    int maxPoolSize;
    int idleConnectionTestPeriod;
    int maxIdleTime;
    int propertyCycle;
    int acquireIncrement;
    boolean testConnectionOnCheckout;
    boolean autoCommitOnClose;
    boolean forceIgnoreUnresolvedTransactions;
    String connectionTesterClassName;
    int numHelperThreads;
    String factoryClassLocation;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$PoolConfig;

    public static int defaultNumHelperThreads() {
        return DEFAULTS.getNumHelperThreads();
    }

    public static String defaultFactoryClassLocation() {
        return DEFAULTS.getFactoryClassLocation();
    }

    public static int defaultMaxStatements() {
        return DEFAULTS.getMaxStatements();
    }

    public static int defaultInitialPoolSize() {
        return DEFAULTS.getInitialPoolSize();
    }

    public static int defaultMinPoolSize() {
        return DEFAULTS.getMinPoolSize();
    }

    public static int defaultMaxPoolSize() {
        return DEFAULTS.getMaxPoolSize();
    }

    public static int defaultIdleConnectionTestPeriod() {
        return DEFAULTS.getIdleConnectionTestPeriod();
    }

    public static int defaultMaxIdleTime() {
        return DEFAULTS.getMaxIdleTime();
    }

    public static int defaultPropertyCycle() {
        return DEFAULTS.getPropertyCycle();
    }

    public static int defaultAcquireIncrement() {
        return DEFAULTS.getAcquireIncrement();
    }

    public static String defaultConnectionTesterClassName() {
        return DEFAULTS.getConnectionTesterClassName();
    }

    public static boolean defaultTestConnectionOnCheckout() {
        return DEFAULTS.isTestConnectionOnCheckout();
    }

    public static boolean defaultAutoCommitOnClose() {
        return DEFAULTS.isAutoCommitOnClose();
    }

    public static boolean defaultForceIgnoreUnresolvedTransactions() {
        return DEFAULTS.isAutoCommitOnClose();
    }

    private PoolConfig(Properties props, boolean init) throws NumberFormatException {
        if (init) {
            PoolConfig.extractConfig(this, props, DEFAULTS);
        }
    }

    public PoolConfig(Properties props) throws NumberFormatException {
        this(props, true);
    }

    public PoolConfig() throws NumberFormatException {
        this(null, true);
    }

    public int getNumHelperThreads() {
        return this.numHelperThreads;
    }

    public String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public String getConnectionTesterClassName() {
        return this.connectionTesterClassName;
    }

    public boolean getTestConnectionOnCheckout() {
        return this.testConnectionOnCheckout;
    }

    public boolean isTestConnectionOnCheckout() {
        return this.getTestConnectionOnCheckout();
    }

    public boolean isAutoCommitOnClose() {
        return this.autoCommitOnClose;
    }

    public boolean isForceIgnoreUnresolvedTransactions() {
        return this.forceIgnoreUnresolvedTransactions;
    }

    public void setNumHelperThreads(int numHelperThreads) {
        this.numHelperThreads = numHelperThreads;
    }

    public void setFactoryClassLocation(String factoryClassLocation) {
        this.factoryClassLocation = factoryClassLocation;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setPropertyCycle(int propertyCycle) {
        this.propertyCycle = propertyCycle;
    }

    public void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }

    public void setConnectionTesterClassName(String connectionTesterClassName) {
        this.connectionTesterClassName = connectionTesterClassName;
    }

    public void setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
        this.testConnectionOnCheckout = testConnectionOnCheckout;
    }

    public void setAutoCommitOnClose(boolean autoCommitOnClose) {
        this.autoCommitOnClose = autoCommitOnClose;
    }

    public void setForceIgnoreUnresolvedTransactions(boolean forceIgnoreUnresolvedTransactions) {
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
    }

    private static PoolConfig extractConfig(Properties props, PoolConfig defaults) throws NumberFormatException {
        PoolConfig pcfg = new PoolConfig(null, false);
        PoolConfig.extractConfig(pcfg, props, defaults);
        return pcfg;
    }

    private static void extractConfig(PoolConfig pcfg, Properties props, PoolConfig defaults) throws NumberFormatException {
        String maxStatementsStr = null;
        String initialPoolSizeStr = null;
        String minPoolSizeStr = null;
        String maxPoolSizeStr = null;
        String idleConnectionTestPeriodStr = null;
        String maxIdleTimeStr = null;
        String propertyCycleStr = null;
        String acquireIncrementStr = null;
        String testConnectionOnCheckoutStr = null;
        String autoCommitOnCloseStr = null;
        String forceIgnoreUnresolvedTransactionsStr = null;
        String connectionTesterClassName = null;
        String numHelperThreadsStr = null;
        String factoryClassLocation = null;
        if (props != null) {
            maxStatementsStr = props.getProperty(MAX_STATEMENTS);
            initialPoolSizeStr = props.getProperty(INITIAL_POOL_SIZE);
            minPoolSizeStr = props.getProperty(MIN_POOL_SIZE);
            maxPoolSizeStr = props.getProperty(MAX_POOL_SIZE);
            idleConnectionTestPeriodStr = props.getProperty(IDLE_CONNECTION_TEST_PERIOD);
            maxIdleTimeStr = props.getProperty(MAX_IDLE_TIME);
            propertyCycleStr = props.getProperty(PROPERTY_CYCLE);
            acquireIncrementStr = props.getProperty(ACQUIRE_INCREMENT);
            testConnectionOnCheckoutStr = props.getProperty(TEST_CONNECTION_ON_CHECKOUT);
            autoCommitOnCloseStr = props.getProperty(AUTO_COMMIT_ON_CLOSE);
            forceIgnoreUnresolvedTransactionsStr = props.getProperty(FORCE_IGNORE_UNRESOLVED_TRANSACTIONS);
            connectionTesterClassName = props.getProperty(CONNECTION_TESTER_CLASS_NAME);
            numHelperThreadsStr = props.getProperty(NUM_HELPER_THREADS);
            factoryClassLocation = props.getProperty(FACTORY_CLASS_LOCATION);
        }
        if (maxStatementsStr != null) {
            pcfg.setMaxStatements(Integer.parseInt(maxStatementsStr));
        } else if (defaults != null) {
            pcfg.setMaxStatements(defaults.getMaxStatements());
        } else {
            pcfg.setMaxStatements(C3P0Defaults.maxStatements());
        }
        if (initialPoolSizeStr != null) {
            pcfg.setInitialPoolSize(Integer.parseInt(initialPoolSizeStr));
        } else if (defaults != null) {
            pcfg.setInitialPoolSize(defaults.getInitialPoolSize());
        } else {
            pcfg.setInitialPoolSize(C3P0Defaults.initialPoolSize());
        }
        if (minPoolSizeStr != null) {
            pcfg.setMinPoolSize(Integer.parseInt(minPoolSizeStr));
        } else if (defaults != null) {
            pcfg.setMinPoolSize(defaults.getMinPoolSize());
        } else {
            pcfg.setMinPoolSize(C3P0Defaults.minPoolSize());
        }
        if (maxPoolSizeStr != null) {
            pcfg.setMaxPoolSize(Integer.parseInt(maxPoolSizeStr));
        } else if (defaults != null) {
            pcfg.setMaxPoolSize(defaults.getMaxPoolSize());
        } else {
            pcfg.setMaxPoolSize(C3P0Defaults.maxPoolSize());
        }
        if (idleConnectionTestPeriodStr != null) {
            pcfg.setIdleConnectionTestPeriod(Integer.parseInt(idleConnectionTestPeriodStr));
        } else if (defaults != null) {
            pcfg.setIdleConnectionTestPeriod(defaults.getIdleConnectionTestPeriod());
        } else {
            pcfg.setIdleConnectionTestPeriod(C3P0Defaults.idleConnectionTestPeriod());
        }
        if (maxIdleTimeStr != null) {
            pcfg.setMaxIdleTime(Integer.parseInt(maxIdleTimeStr));
        } else if (defaults != null) {
            pcfg.setMaxIdleTime(defaults.getMaxIdleTime());
        } else {
            pcfg.setMaxIdleTime(C3P0Defaults.maxIdleTime());
        }
        if (propertyCycleStr != null) {
            pcfg.setPropertyCycle(Integer.parseInt(propertyCycleStr));
        } else if (defaults != null) {
            pcfg.setPropertyCycle(defaults.getPropertyCycle());
        } else {
            pcfg.setPropertyCycle(C3P0Defaults.propertyCycle());
        }
        if (acquireIncrementStr != null) {
            pcfg.setAcquireIncrement(Integer.parseInt(acquireIncrementStr));
        } else if (defaults != null) {
            pcfg.setAcquireIncrement(defaults.getAcquireIncrement());
        } else {
            pcfg.setAcquireIncrement(C3P0Defaults.acquireIncrement());
        }
        if (testConnectionOnCheckoutStr != null) {
            pcfg.setTestConnectionOnCheckout(Boolean.valueOf(testConnectionOnCheckoutStr));
        } else if (defaults != null) {
            pcfg.setTestConnectionOnCheckout(defaults.isTestConnectionOnCheckout());
        } else {
            pcfg.setTestConnectionOnCheckout(C3P0Defaults.testConnectionOnCheckout());
        }
        if (autoCommitOnCloseStr != null) {
            pcfg.setAutoCommitOnClose(Boolean.valueOf(autoCommitOnCloseStr));
        } else if (defaults != null) {
            pcfg.setAutoCommitOnClose(defaults.isAutoCommitOnClose());
        } else {
            pcfg.setAutoCommitOnClose(C3P0Defaults.autoCommitOnClose());
        }
        if (forceIgnoreUnresolvedTransactionsStr != null) {
            pcfg.setForceIgnoreUnresolvedTransactions(Boolean.valueOf(forceIgnoreUnresolvedTransactionsStr));
        } else if (defaults != null) {
            pcfg.setForceIgnoreUnresolvedTransactions(defaults.isForceIgnoreUnresolvedTransactions());
        } else {
            pcfg.setForceIgnoreUnresolvedTransactions(C3P0Defaults.forceIgnoreUnresolvedTransactions());
        }
        if (connectionTesterClassName != null) {
            pcfg.setConnectionTesterClassName(connectionTesterClassName);
        } else if (defaults != null) {
            pcfg.setConnectionTesterClassName(defaults.getConnectionTesterClassName());
        } else {
            pcfg.setConnectionTesterClassName(C3P0Defaults.connectionTesterClassName());
        }
        if (numHelperThreadsStr != null) {
            pcfg.setNumHelperThreads(Integer.parseInt(numHelperThreadsStr));
        } else if (defaults != null) {
            pcfg.setNumHelperThreads(defaults.getNumHelperThreads());
        } else {
            pcfg.setNumHelperThreads(C3P0Defaults.numHelperThreads());
        }
        if (factoryClassLocation != null) {
            pcfg.setFactoryClassLocation(factoryClassLocation);
        } else if (defaults != null) {
            pcfg.setFactoryClassLocation(defaults.getFactoryClassLocation());
        } else {
            pcfg.setFactoryClassLocation(C3P0Defaults.factoryClassLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties findResourceProperties() {
        InputStream is;
        Properties props;
        block4: {
            props = new Properties();
            is = null;
            try {
                is = (class$com$mchange$v2$c3p0$PoolConfig == null ? (class$com$mchange$v2$c3p0$PoolConfig = PoolConfig.class$("com.mchange.v2.c3p0.PoolConfig")) : class$com$mchange$v2$c3p0$PoolConfig).getResourceAsStream(DEFAULT_CONFIG_RSRC_PATH);
                if (is == null) break block4;
                props.load(is);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    props = new Properties();
                }
                catch (Throwable throwable) {
                    InputStreamUtils.attemptClose(is);
                    throw throwable;
                }
                InputStreamUtils.attemptClose(is);
            }
        }
        InputStreamUtils.attemptClose(is);
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Properties rsrcProps = PoolConfig.findResourceProperties();
        PoolConfig rsrcDefaults = PoolConfig.extractConfig(rsrcProps, null);
        DEFAULTS = PoolConfig.extractConfig(System.getProperties(), rsrcDefaults);
    }
}

