/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;

public final class C3P0PooledConnectionPoolManager {
    private static final CoalesceChecker COALESCE_CHECKER = new CoalesceChecker(){

        public boolean checkCoalesce(Object a, Object b) {
            C3P0PooledConnectionPoolManager aa = (C3P0PooledConnectionPoolManager)a;
            C3P0PooledConnectionPoolManager bb = (C3P0PooledConnectionPoolManager)b;
            return aa.cpds.equals(bb.cpds) && aa.num_task_threads == bb.num_task_threads && aa.maxStatements == bb.maxStatements && aa.minPoolSize == bb.minPoolSize && aa.idleConnectionTestPeriod == bb.idleConnectionTestPeriod && aa.maxIdleTime == bb.maxIdleTime && aa.acquireIncrement == bb.acquireIncrement && aa.testConnectionOnCheckout == bb.testConnectionOnCheckout && aa.autoCommitOnClose == bb.autoCommitOnClose && aa.forceIgnoreUnresolvedTransactions == bb.forceIgnoreUnresolvedTransactions && aa.defaultAuth.equals(bb.defaultAuth) && aa.connectionTester.getClass().equals(bb.connectionTester.getClass());
        }

        public int coalesceHash(Object a) {
            C3P0PooledConnectionPoolManager aa = (C3P0PooledConnectionPoolManager)a;
            return aa.cpds.hashCode() ^ aa.num_task_threads ^ aa.maxStatements ^ aa.minPoolSize ^ aa.idleConnectionTestPeriod ^ aa.maxIdleTime ^ aa.acquireIncrement ^ (aa.testConnectionOnCheckout ? 1 : 0) ^ (aa.autoCommitOnClose ? 2 : 0) ^ (aa.forceIgnoreUnresolvedTransactions ? 4 : 0) ^ aa.defaultAuth.hashCode() ^ aa.connectionTester.getClass().hashCode();
        }
    };
    static final Coalescer COALESCER = CoalescerFactory.createCoalescer(COALESCE_CHECKER, true, false);
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    Set activeClients = new HashSet();
    ThreadPoolAsynchronousRunner taskRunner;
    Timer timer;
    ResourcePoolFactory rpfact;
    GooGooStatementCache scache;
    Map authsToPools;
    final ConnectionPoolDataSource cpds;
    int num_task_threads = 3;
    int maxStatements = PoolConfig.defaultMaxStatements();
    int minPoolSize = PoolConfig.defaultMinPoolSize();
    int maxPoolSize = PoolConfig.defaultMaxPoolSize();
    int idleConnectionTestPeriod = PoolConfig.defaultIdleConnectionTestPeriod();
    int maxIdleTime = PoolConfig.defaultMaxIdleTime();
    int acquireIncrement = PoolConfig.defaultAcquireIncrement();
    boolean testConnectionOnCheckout = PoolConfig.defaultTestConnectionOnCheckout();
    boolean autoCommitOnClose = PoolConfig.defaultAutoCommitOnClose();
    boolean forceIgnoreUnresolvedTransactions = PoolConfig.defaultForceIgnoreUnresolvedTransactions();
    DbAuth defaultAuth = C3P0ImplUtils.NULL_AUTH;
    ConnectionTester connectionTester;
    static /* synthetic */ Class class$java$lang$String;

    private synchronized void poolsInit() {
        this.timer = new Timer(true);
        this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, this.timer);
        this.rpfact = ResourcePoolFactory.createInstance(this.taskRunner, null, this.timer);
        if (this.maxStatements > 0) {
            this.scache = new GooGooStatementCache(this.taskRunner, this.maxStatements);
        }
        this.authsToPools = new HashMap();
    }

    private synchronized void poolsDestroy() {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)ii.next()).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        this.scache = null;
        this.taskRunner = null;
        this.timer = null;
        this.rpfact = null;
        this.authsToPools = null;
    }

    public static synchronized C3P0PooledConnectionPoolManager find(ConnectionPoolDataSource cpds, int num_task_threads) throws SQLException {
        C3P0PooledConnectionPoolManager nascent = new C3P0PooledConnectionPoolManager(cpds, num_task_threads);
        C3P0PooledConnectionPoolManager out = (C3P0PooledConnectionPoolManager)COALESCER.coalesce(nascent);
        if (out == nascent) {
            out.poolsInit();
        }
        return out;
    }

    private C3P0PooledConnectionPoolManager(ConnectionPoolDataSource cpds, int num_task_threads) throws SQLException {
        try {
            this.connectionTester = (ConnectionTester)Class.forName(PoolConfig.defaultConnectionTesterClassName()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionTester = C3P0Defaults.connectionTester();
        }
        try {
            this.cpds = cpds;
            this.num_task_threads = num_task_threads;
            this.defaultAuth = C3P0ImplUtils.findAuth(cpds);
            BeanInfo bi = Introspector.getBeanInfo(cpds.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                int value;
                Object propVal;
                PropertyDescriptor pd = pds[i];
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                Method readMethod = pd.getReadMethod();
                if (propCl == Integer.TYPE) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    value = (Integer)propVal;
                    if ("maxStatements".equals(propName)) {
                        this.maxStatements = value;
                        continue;
                    }
                    if ("minPoolSize".equals(propName)) {
                        this.minPoolSize = value;
                        continue;
                    }
                    if ("maxPoolSize".equals(propName)) {
                        this.maxPoolSize = value;
                        continue;
                    }
                    if ("idleConnectionTestPeriod".equals(propName)) {
                        this.idleConnectionTestPeriod = value;
                        continue;
                    }
                    if ("maxIdleTime".equals(propName)) {
                        this.maxIdleTime = value;
                        continue;
                    }
                    if (!"acquireIncrement".equals(propName)) continue;
                    this.acquireIncrement = value;
                    continue;
                }
                if (propCl == (class$java$lang$String == null ? C3P0PooledConnectionPoolManager.class$("java.lang.String") : class$java$lang$String)) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    String value2 = (String)propVal;
                    if (!"connectionTesterClassName".equals(propName)) continue;
                    this.connectionTester = (ConnectionTester)Class.forName(value2).newInstance();
                    continue;
                }
                if (propCl != Boolean.TYPE) continue;
                propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                value = ((Boolean)propVal).booleanValue() ? 1 : 0;
                if ("testConnectionOnCheckout".equals(propName)) {
                    this.testConnectionOnCheckout = value;
                    continue;
                }
                if ("autoCommitOnClose".equals(propName)) {
                    this.autoCommitOnClose = value;
                    continue;
                }
                if (!"forceIgnoreUnresolvedTransactions".equals(propName)) continue;
                this.forceIgnoreUnresolvedTransactions = value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(String username, String password) throws SQLException {
        return this.getPool(new DbAuth(username, password));
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth auth) throws SQLException {
        C3P0PooledConnectionPool out = (C3P0PooledConnectionPool)this.authsToPools.get(auth);
        if (out == null) {
            out = this.createPooledConnectionPool(auth);
            this.authsToPools.put(auth, out);
        }
        return out;
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized int getNumConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumConnections();
        }
        return out;
    }

    public synchronized void close() {
        if (this.authsToPools != null) {
            this.poolsDestroy();
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth auth) throws SQLException {
        return new C3P0PooledConnectionPool(this.cpds, auth, this.minPoolSize, this.maxPoolSize, this.acquireIncrement, this.idleConnectionTestPeriod, this.maxIdleTime, this.testConnectionOnCheckout, this.scache, this.connectionTester, this.rpfact);
    }

    public synchronized void registerActiveClient(Object o) {
        this.activeClients.add(o);
        if (this.authsToPools == null) {
            this.poolsInit();
        }
    }

    public synchronized void unregisterActiveClient(Object o) {
        this.activeClients.remove(o);
        if (this.activeClients.size() == 0) {
            this.close();
        }
    }

    public synchronized void forceDestroy() {
        if (this.activeClients.size() > 0) {
            this.activeClients.clear();
            this.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

