/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DINameSpace;
import org.hsqldb.DITableInfo;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Database;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.store.ValuePool;

class DatabaseInformationMain
extends DatabaseInformation {
    protected static final HsqlNameManager.HsqlName[] sysTableHsqlNames;
    protected final int[] sysTableSessions = new int[sysTableNames.length];
    protected final boolean[] sysTableSessionDependent = new boolean[sysTableNames.length];
    protected final Table[] sysTables = new Table[sysTableNames.length];
    protected static final HashSet nonCachedTablesSet;
    protected static final HashMap columnNameMap;
    protected static final HashMap indexNameMap;
    protected Session session;
    protected static final String[] tableTypes;
    protected DINameSpace ns;

    DatabaseInformationMain(Database database) throws HsqlException {
        super(database);
        Trace.doAssert(database != null, "db != null");
        Trace.doAssert(database.getTables() != null, "db.getTables() != null");
        Trace.doAssert(database.getUserManager() != null, "db.getUserManager() != null");
        this.init();
    }

    protected final void addColumn(Table table, String string, int n, int n2, boolean bl) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName = this.ns.findOrCreateHsqlName(string, columnNameMap);
        Column column = new Column(hsqlName, bl, n, n2, 0, false, 0L, 0L, false, null);
        table.addColumn(column);
    }

    protected final void addColumn(Table table, String string, int n, boolean bl) throws HsqlException {
        this.addColumn(table, string, n, 0, bl);
    }

    protected final void addColumn(Table table, String string, int n) throws HsqlException {
        this.addColumn(table, string, n, true);
    }

    protected final Iterator allTables() {
        return new WrapperIterator(this.database.getTables().iterator(), new WrapperIterator(this.sysTables, true));
    }

    protected final void cacheClear() throws HsqlException {
        int n = this.sysTables.length;
        while (n-- > 0) {
            Table table = this.sysTables[n];
            if (table != null) {
                table.clearAllRows();
            }
            this.sysTableSessions[n] = -1;
        }
        this.isDirty = false;
    }

    protected Table generateTable(int n) throws HsqlException {
        Table table = this.sysTables[n];
        switch (n) {
            case 0: {
                return this.SYSTEM_BESTROWIDENTIFIER();
            }
            case 1: {
                return this.SYSTEM_CATALOGS();
            }
            case 2: {
                return this.SYSTEM_COLUMNPRIVILEGES();
            }
            case 3: {
                return this.SYSTEM_COLUMNS();
            }
            case 4: {
                return this.SYSTEM_CROSSREFERENCE();
            }
            case 5: {
                return this.SYSTEM_INDEXINFO();
            }
            case 6: {
                return this.SYSTEM_PRIMARYKEYS();
            }
            case 7: {
                return this.SYSTEM_PROCEDURECOLUMNS();
            }
            case 8: {
                return this.SYSTEM_PROCEDURES();
            }
            case 9: {
                return this.SYSTEM_SCHEMAS();
            }
            case 12: {
                return this.SYSTEM_TABLEPRIVILEGES();
            }
            case 13: {
                return this.SYSTEM_TABLES();
            }
            case 14: {
                return this.SYSTEM_TABLETYPES();
            }
            case 15: {
                return this.SYSTEM_TYPEINFO();
            }
            case 18: {
                return this.SYSTEM_USERS();
            }
            case 29: {
                return this.SYSTEM_ALLTYPEINFO();
            }
            case 34: {
                return this.SYSTEM_CHECK_CONSTRAINTS();
            }
            case 32: {
                return this.SYSTEM_SEQUENCES();
            }
        }
        return null;
    }

    protected final void init() throws HsqlException {
        this.ns = new DINameSpace(this.database);
        this.sysTableSessionDependent[41] = true;
        this.sysTableSessionDependent[40] = true;
        this.sysTableSessionDependent[39] = true;
        this.sysTableSessionDependent[38] = true;
        this.sysTableSessionDependent[37] = true;
        this.sysTableSessionDependent[36] = true;
        this.sysTableSessionDependent[35] = true;
        this.sysTableSessionDependent[33] = true;
        this.sysTableSessionDependent[32] = true;
        this.sysTableSessionDependent[34] = true;
        this.sysTableSessionDependent[31] = true;
        this.sysTableSessionDependent[30] = true;
        this.sysTableSessionDependent[28] = true;
        this.sysTableSessionDependent[27] = true;
        this.sysTableSessionDependent[13] = true;
        this.sysTableSessionDependent[12] = true;
        this.sysTableSessionDependent[7] = true;
        this.sysTableSessionDependent[8] = true;
        this.sysTableSessionDependent[6] = true;
        this.sysTableSessionDependent[5] = true;
        this.sysTableSessionDependent[4] = true;
        this.sysTableSessionDependent[3] = true;
        this.sysTableSessionDependent[2] = true;
        this.sysTableSessionDependent[0] = true;
        this.sysTableSessionDependent[23] = true;
        this.sysTableSessionDependent[20] = true;
        Session session = this.session;
        this.session = this.database.sessionManager.getSysSession();
        Trace.check(this.session != null, 37, "SYS");
        for (int i = 0; i < this.sysTables.length; ++i) {
            this.sysTables[i] = this.generateTable(i);
            Table table = this.sysTables[i];
            if (table == null) continue;
            table.setDataReadOnly(true);
        }
        UserManager userManager = this.database.getUserManager();
        for (int i = 0; i < sysTableHsqlNames.length; ++i) {
            if (this.sysTables[i] == null) continue;
            userManager.grant("PUBLIC", sysTableHsqlNames[i], 1);
        }
        this.session = session;
    }

    protected final boolean isAccessibleTable(Table table) throws HsqlException {
        if (!this.session.isAccessible(table.getName())) {
            return false;
        }
        return table.isTemp() && table.tableType != 0 ? table.getOwnerSessionId() == this.session.getId() : true;
    }

    protected final Table createBlankTable(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        return new Table(this.database, hsqlName, 0, 0);
    }

    final Table getSystemTable(Session session, String string) throws HsqlException {
        int n;
        boolean bl;
        Trace.doAssert(string != null, "name is null");
        Trace.doAssert(session != null, "session is null");
        this.session = session;
        Table table = this.ns.findPubSchemaTable(string);
        if (table != null) {
            return table;
        }
        table = this.ns.findUserSchemaTable(string, session);
        if (table != null) {
            return table;
        }
        if (!this.isSystemTable(string = this.ns.withoutDefnSchema(string))) {
            return null;
        }
        int n2 = DatabaseInformationMain.getSysTableID(string);
        table = this.sysTables[n2];
        if (table == null) {
            return table;
        }
        if (!this.withContent) {
            return table;
        }
        if (this.isDirty) {
            this.cacheClear();
        }
        boolean bl2 = bl = (n = this.sysTableSessions[n2]) != -1;
        if (session.getId() != n && this.sysTableSessionDependent[n2]) {
            bl = false;
        }
        if (nonCachedTablesSet.contains(string)) {
            bl = false;
        }
        if (bl) {
            return table;
        }
        table.clearAllRows();
        this.sysTableSessions[n2] = session.getId();
        table = this.generateTable(n2);
        return table;
    }

    final Table SYSTEM_BESTROWIDENTIFIER() throws HsqlException {
        Iterator iterator;
        Table table = this.sysTables[0];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[0]);
            this.addColumn(table, "SCOPE", 5, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "TYPE_NAME", 12, 32, false);
            this.addColumn(table, "COLUMN_SIZE", 4);
            this.addColumn(table, "BUFFER_LENGTH", 4);
            this.addColumn(table, "DECIMAL_DIGITS", 5);
            this.addColumn(table, "PSEUDO_COLUMN", 5, false);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "NULLABLE", 5, false);
            this.addColumn(table, "IN_KEY", 16, false);
            table.createPrimaryKey(null, new int[]{0, 8, 9, 10, 1}, false);
            return table;
        }
        DITableInfo dITableInfo = new DITableInfo();
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        Iterator iterator2 = iterator = hsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_bri") ? this.allTables() : this.database.getTables().iterator();
        while (iterator.hasNext()) {
            int[] nArray;
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(table2) || (nArray = table2.getBestRowIdentifiers()) == null) continue;
            dITableInfo.setTable(table2);
            Boolean bl = ValuePool.getBoolean(table2.isBestRowIdentifiersStrict());
            String string = this.ns.getCatalogName(table2);
            String string2 = this.ns.getSchemaName(table2);
            String string3 = dITableInfo.getName();
            Integer n = dITableInfo.getBRIScope();
            Integer n2 = dITableInfo.getBRIPseudo();
            for (int i = 0; i < nArray.length; ++i) {
                Object[] objectArray = table.getNewRow();
                objectArray[0] = n;
                objectArray[1] = dITableInfo.getColName(i);
                objectArray[2] = dITableInfo.getColDataType(i);
                objectArray[3] = dITableInfo.getColDataTypeName(i);
                objectArray[4] = dITableInfo.getColSize(i);
                objectArray[5] = dITableInfo.getColBufLen(i);
                objectArray[6] = dITableInfo.getColScale(i);
                objectArray[7] = n2;
                objectArray[8] = string;
                objectArray[9] = string2;
                objectArray[10] = string3;
                objectArray[11] = dITableInfo.getColNullability(i);
                objectArray[12] = bl;
                table.insert(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_CATALOGS() throws HsqlException {
        Table table = this.sysTables[1];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[1]);
            this.addColumn(table, "TABLE_CAT", 12, false);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        Iterator iterator = this.ns.iterateCatalogNames();
        while (iterator.hasNext()) {
            Object[] objectArray = table.getNewRow();
            objectArray[0] = (String)iterator.next();
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_COLUMNPRIVILEGES() throws HsqlException {
        Table table = this.sysTables[2];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[2]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "GRANTOR", 12, false);
            this.addColumn(table, "GRANTEE", 12, false);
            this.addColumn(table, "PRIVILEGE", 12, 10, false);
            this.addColumn(table, "IS_GRANTABLE", 12, 3, false);
            table.createPrimaryKey(null, new int[]{3, 6, 5, 4, 2, 1, 0}, false);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("select a.TABLE_CAT, a.TABLE_SCHEM, a.TABLE_NAME, b.COLUMN_NAME, a.GRANTOR, a.GRANTEE, a.PRIVILEGE, a.IS_GRANTABLE from  SYSTEM_TABLEPRIVILEGES a, SYSTEM_COLUMNS b where a.TABLE_NAME = b.TABLE_NAME;");
        table.insert(result);
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_COLUMNS() throws HsqlException {
        Table table = this.sysTables[3];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[3]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "TYPE_NAME", 12, 32, false);
            this.addColumn(table, "COLUMN_SIZE", 4);
            this.addColumn(table, "BUFFER_LENGTH", 4);
            this.addColumn(table, "DECIMAL_DIGITS", 4);
            this.addColumn(table, "NUM_PREC_RADIX", 4);
            this.addColumn(table, "NULLABLE", 4, false);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "COLUMN_DEF", 12);
            this.addColumn(table, "SQL_DATA_TYPE", 4);
            this.addColumn(table, "SQL_DATETIME_SUB", 4);
            this.addColumn(table, "CHAR_OCTET_LENGTH", 4);
            this.addColumn(table, "ORDINAL_POSITION", 4, false);
            this.addColumn(table, "IS_NULLABLE", 12, 3, false);
            this.addColumn(table, "SCOPE_CATLOG", 12);
            this.addColumn(table, "SCOPE_SCHEMA", 12);
            this.addColumn(table, "SCOPE_TABLE", 12);
            this.addColumn(table, "SOURCE_DATA_TYPE", 12);
            this.addColumn(table, "TYPE_SUB", 4, false);
            table.createPrimaryKey(null, new int[]{1, 2, 16, 0}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        DITableInfo dITableInfo = new DITableInfo();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(table2)) continue;
            dITableInfo.setTable(table2);
            String string = this.ns.getCatalogName(table2);
            String string2 = this.ns.getSchemaName(table2);
            String string3 = dITableInfo.getName();
            int n = table2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = table.getNewRow();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = dITableInfo.getColName(i);
                objectArray[4] = dITableInfo.getColDataType(i);
                objectArray[5] = dITableInfo.getColDataTypeName(i);
                objectArray[6] = dITableInfo.getColSize(i);
                objectArray[7] = dITableInfo.getColBufLen(i);
                objectArray[8] = dITableInfo.getColScale(i);
                objectArray[9] = dITableInfo.getColPrecRadix(i);
                objectArray[10] = dITableInfo.getColNullability(i);
                objectArray[11] = dITableInfo.getColRemarks(i);
                objectArray[12] = dITableInfo.getColDefault(i);
                objectArray[13] = dITableInfo.getColSqlDataType(i);
                objectArray[14] = dITableInfo.getColSqlDateTimeSub(i);
                objectArray[15] = dITableInfo.getColCharOctLen(i);
                objectArray[16] = ValuePool.getInt(i + 1);
                objectArray[17] = dITableInfo.getColIsNullable(i);
                objectArray[22] = dITableInfo.getColDataTypeSub(i);
                table.insert(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_CROSSREFERENCE() throws HsqlException {
        Constraint constraint;
        int n;
        Table table = this.sysTables[4];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[4]);
            this.addColumn(table, "PKTABLE_CAT", 12);
            this.addColumn(table, "PKTABLE_SCHEM", 12);
            this.addColumn(table, "PKTABLE_NAME", 12, false);
            this.addColumn(table, "PKCOLUMN_NAME", 12, false);
            this.addColumn(table, "FKTABLE_CAT", 12);
            this.addColumn(table, "FKTABLE_SCHEM", 12);
            this.addColumn(table, "FKTABLE_NAME", 12, false);
            this.addColumn(table, "FKCOLUMN_NAME", 12, false);
            this.addColumn(table, "KEY_SEQ", 5, false);
            this.addColumn(table, "UPDATE_RULE", 5, false);
            this.addColumn(table, "DELETE_RULE", 5, false);
            this.addColumn(table, "FK_NAME", 12);
            this.addColumn(table, "PK_NAME", 12);
            this.addColumn(table, "DEFERRABILITY", 5, false);
            table.createPrimaryKey(null, new int[]{4, 5, 6, 8, 11}, false);
            return table;
        }
        Iterator iterator = this.database.getTables().iterator();
        DITableInfo dITableInfo = new DITableInfo();
        DITableInfo dITableInfo2 = new DITableInfo();
        Integer n2 = ValuePool.getInt(7);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(table2)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n3 = constraintArray.length;
            for (n = 0; n < n3; ++n) {
                constraint = constraintArray[n];
                if (constraint.getType() != 0 || !this.isAccessibleTable(constraint.getRef())) continue;
                hsqlArrayList.add(constraint);
            }
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            Integer n4;
            Integer n5;
            constraint = (Constraint)hsqlArrayList.get(n);
            Table table3 = constraint.getMain();
            dITableInfo.setTable(table3);
            String string = dITableInfo.getName();
            Table table4 = constraint.getRef();
            dITableInfo2.setTable(table4);
            String string2 = dITableInfo2.getName();
            String string3 = this.ns.getCatalogName(table3);
            String string4 = this.ns.getSchemaName(table3);
            String string5 = this.ns.getCatalogName(table4);
            String string6 = this.ns.getSchemaName(table4);
            int[] nArray = constraint.getMainColumns();
            int[] nArray2 = constraint.getRefColumns();
            int n6 = nArray2.length;
            String string7 = constraint.getFkName();
            String string8 = constraint.getMainIndex().getName().name;
            switch (constraint.getDeleteAction()) {
                case 0: {
                    n5 = ValuePool.getInt(0);
                    break;
                }
                case 4: {
                    n5 = ValuePool.getInt(4);
                    break;
                }
                case 2: {
                    n5 = ValuePool.getInt(2);
                    break;
                }
                default: {
                    n5 = ValuePool.getInt(3);
                }
            }
            switch (constraint.getUpdateAction()) {
                case 0: {
                    n4 = ValuePool.getInt(0);
                    break;
                }
                case 4: {
                    n4 = ValuePool.getInt(4);
                    break;
                }
                case 2: {
                    n4 = ValuePool.getInt(2);
                    break;
                }
                default: {
                    n4 = ValuePool.getInt(3);
                }
            }
            for (int i = 0; i < n6; ++i) {
                Integer n7 = ValuePool.getInt(i + 1);
                String string9 = dITableInfo.getColName(nArray[i]);
                String string10 = dITableInfo2.getColName(nArray2[i]);
                Object[] objectArray = table.getNewRow();
                objectArray[0] = string3;
                objectArray[1] = string4;
                objectArray[2] = string;
                objectArray[3] = string9;
                objectArray[4] = string5;
                objectArray[5] = string6;
                objectArray[6] = string2;
                objectArray[7] = string10;
                objectArray[8] = n7;
                objectArray[9] = n4;
                objectArray[10] = n5;
                objectArray[11] = string7;
                objectArray[12] = string8;
                objectArray[13] = n2;
                table.insert(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_INDEXINFO() throws HsqlException {
        Iterator iterator;
        Table table = this.sysTables[5];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[5]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "NON_UNIQUE", 16, false);
            this.addColumn(table, "INDEX_QUALIFIER", 12);
            this.addColumn(table, "INDEX_NAME", 12);
            this.addColumn(table, "TYPE", 5, false);
            this.addColumn(table, "ORDINAL_POSITION", 5, false);
            this.addColumn(table, "COLUMN_NAME", 12);
            this.addColumn(table, "ASC_OR_DESC", 12, 1, true);
            this.addColumn(table, "CARDINALITY", 4);
            this.addColumn(table, "PAGES", 4);
            this.addColumn(table, "FILTER_CONDITION", 12);
            table.createPrimaryKey(null, new int[]{3, 6, 5, 7, 4, 2}, false);
            return table;
        }
        DITableInfo dITableInfo = new DITableInfo();
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        Iterator iterator2 = iterator = hsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_indexinfo") ? this.allTables() : this.database.getTables().iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(table2)) continue;
            dITableInfo.setTable(table2);
            String string = this.ns.getCatalogName(table2);
            String string2 = this.ns.getSchemaName(table2);
            String string3 = dITableInfo.getName();
            Object var11_16 = null;
            String string4 = string;
            int n = table2.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = dITableInfo.getIndexVisibleColumns(i);
                if (n2 < 1) continue;
                String string5 = dITableInfo.getIndexName(i);
                Boolean bl = dITableInfo.isIndexNonUnique(i);
                Integer n3 = dITableInfo.getIndexCardinality(i);
                Integer n4 = dITableInfo.getIndexPages(i);
                int[] nArray = dITableInfo.getIndexColumns(i);
                Integer n5 = dITableInfo.getIndexType(i);
                for (int j = 0; j < n2; ++j) {
                    int n6 = nArray[j];
                    Object[] objectArray = table.getNewRow();
                    objectArray[0] = string;
                    objectArray[1] = string2;
                    objectArray[2] = string3;
                    objectArray[3] = bl;
                    objectArray[4] = string4;
                    objectArray[5] = string5;
                    objectArray[6] = n5;
                    objectArray[7] = ValuePool.getInt(j + 1);
                    objectArray[8] = dITableInfo.getColName(n6);
                    objectArray[9] = dITableInfo.getIndexColDirection(i, n6);
                    objectArray[10] = n3;
                    objectArray[11] = n4;
                    objectArray[12] = var11_16;
                    table.insert(objectArray);
                }
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_PRIMARYKEYS() throws HsqlException {
        Iterator iterator;
        Table table = this.sysTables[6];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[6]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "KEY_SEQ", 5, false);
            this.addColumn(table, "PK_NAME", 12);
            table.createPrimaryKey(null, new int[]{3, 2, 1, 0}, false);
            return table;
        }
        DITableInfo dITableInfo = new DITableInfo();
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        Iterator iterator2 = iterator = hsqlDatabaseProperties.isPropertyTrue("hsqldb.system_table_primarykeys") ? this.allTables() : this.database.getTables().iterator();
        while (iterator.hasNext()) {
            Index index;
            Table table2 = (Table)iterator.next();
            if (table2.isView() || (index = table2.getPrimaryIndex()) == null) continue;
            dITableInfo.setTable(table2);
            if (!this.isAccessibleTable(table2) || table2.getPrimaryKey() == null) continue;
            String string = this.ns.getCatalogName(table2);
            String string2 = this.ns.getSchemaName(table2);
            String string3 = dITableInfo.getName();
            String string4 = index.getName().name;
            int[] nArray = index.getColumns();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = table.getNewRow();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = dITableInfo.getColName(nArray[i]);
                objectArray[4] = ValuePool.getInt(i + 1);
                objectArray[5] = string4;
                table.insert(objectArray);
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_PROCEDURECOLUMNS() throws HsqlException {
        Table table = this.sysTables[7];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[7]);
            this.addColumn(table, "PROCEDURE_CAT", 12);
            this.addColumn(table, "PROCEDURE_SCHEM", 12);
            this.addColumn(table, "PROCEDURE_NAME", 12, false);
            this.addColumn(table, "COLUMN_NAME", 12, false);
            this.addColumn(table, "COLUMN_TYPE", 5, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "TYPE_NAME", 12, 32, false);
            this.addColumn(table, "PRECISION", 4);
            this.addColumn(table, "LENGTH", 4);
            this.addColumn(table, "SCALE", 5);
            this.addColumn(table, "RADIX", 5);
            this.addColumn(table, "NULLABLE", 5, false);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "SPECIFIC_NAME", 12, false);
            this.addColumn(table, "SEQ", 4, false);
            table.createPrimaryKey(null, new int[]{1, 2, 13, 14, 0}, false);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_PROCEDURES() throws HsqlException {
        Table table = this.sysTables[8];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[8]);
            this.addColumn(table, "PROCEDURE_CAT", 12);
            this.addColumn(table, "PROCEDURE_SCHEM", 12);
            this.addColumn(table, "PROCEDURE_NAME", 12, false);
            this.addColumn(table, "NUM_INPUT_PARAMS", 4);
            this.addColumn(table, "NUM_OUTPUT_PARAMS", 4);
            this.addColumn(table, "NUM_RESULT_SETS", 4);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "PROCEDURE_TYPE", 5, false);
            this.addColumn(table, "ORIGIN", 12, 32, false);
            this.addColumn(table, "SPECIFIC_NAME", 12, false);
            table.createPrimaryKey(null, new int[]{1, 2, 9, 0}, false);
            return table;
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_SCHEMAS() throws HsqlException {
        Table table = this.sysTables[9];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[9]);
            this.addColumn(table, "TABLE_SCHEM", 12, false);
            this.addColumn(table, "TABLE_CATALOG", 12);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        Iterator iterator = this.ns.iterateVisibleSchemaNames(this.session);
        while (iterator.hasNext()) {
            Object[] objectArray = table.getNewRow();
            objectArray[0] = iterator.next();
            objectArray[1] = this.ns.getCatalogName(objectArray[0]);
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_TABLEPRIVILEGES() throws HsqlException {
        Table table = this.sysTables[12];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[12]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "GRANTOR", 12, false);
            this.addColumn(table, "GRANTEE", 12, false);
            this.addColumn(table, "PRIVILEGE", 12, 10, false);
            this.addColumn(table, "IS_GRANTABLE", 12, 3, false);
            table.createPrimaryKey(null, new int[]{1, 2, 5, 4, 3, 0}, false);
            return table;
        }
        String string = "SYS";
        HsqlArrayList hsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, true);
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            HsqlNameManager.HsqlName hsqlName = table2.getName();
            if (!this.isAccessibleTable(table2)) continue;
            String string2 = table2.getName().name;
            String string3 = this.ns.getCatalogName(table2);
            String string4 = this.ns.getSchemaName(table2);
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                User user = (User)hsqlArrayList.get(i);
                String string5 = user.getName();
                String[] stringArray = user.listGrantedTablePrivileges(hsqlName);
                String string6 = user.isAdmin() ? "YES" : "NO";
                for (int j = 0; j < stringArray.length; ++j) {
                    String string7 = stringArray[j];
                    Object[] objectArray = table.getNewRow();
                    objectArray[0] = string3;
                    objectArray[1] = string4;
                    objectArray[2] = string2;
                    objectArray[3] = string;
                    objectArray[4] = string5;
                    objectArray[5] = string7;
                    objectArray[6] = string6;
                    table.insert(objectArray);
                }
            }
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_TABLES() throws HsqlException {
        Table table = this.sysTables[13];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[13]);
            this.addColumn(table, "TABLE_CAT", 12);
            this.addColumn(table, "TABLE_SCHEM", 12);
            this.addColumn(table, "TABLE_NAME", 12, false);
            this.addColumn(table, "TABLE_TYPE", 12, 16, false);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "TYPE_CAT", 12);
            this.addColumn(table, "TYPE_SCHEM", 12);
            this.addColumn(table, "TYPE_NAME", 12);
            this.addColumn(table, "SELF_REFERENCING_COL_NAME", 12);
            this.addColumn(table, "REF_GENERATION", 12);
            this.addColumn(table, "HSQLDB_TYPE", 12, 6, true);
            this.addColumn(table, "READ_ONLY", 16, false);
            table.createPrimaryKey(null, new int[]{3, 1, 2, 0}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        DITableInfo dITableInfo = new DITableInfo();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(table2)) continue;
            dITableInfo.setTable(table2);
            Object[] objectArray = table.getNewRow();
            objectArray[0] = this.ns.getCatalogName(table2);
            objectArray[1] = this.ns.getSchemaName(table2);
            objectArray[2] = dITableInfo.getName();
            objectArray[3] = dITableInfo.getStandardType();
            objectArray[4] = dITableInfo.getRemark();
            objectArray[10] = dITableInfo.getHsqlType();
            objectArray[11] = dITableInfo.isReadOnly();
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_TABLETYPES() throws HsqlException {
        Table table = this.sysTables[14];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[14]);
            this.addColumn(table, "TABLE_TYPE", 12, 16, false);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        for (int i = 0; i < tableTypes.length; ++i) {
            Object[] objectArray = table.getNewRow();
            objectArray[0] = tableTypes[i];
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_TYPEINFO() throws HsqlException {
        Table table = this.sysTables[15];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[15]);
            this.addColumn(table, "TYPE_NAME", 12, 32, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "PRECISION", 4);
            this.addColumn(table, "LITERAL_PREFIX", 12, 2, true);
            this.addColumn(table, "LITERAL_SUFFIX", 12, 2, true);
            this.addColumn(table, "CREATE_PARAMS", 12);
            this.addColumn(table, "NULLABLE", 5);
            this.addColumn(table, "CASE_SENSITIVE", 16);
            this.addColumn(table, "SEARCHABLE", 5);
            this.addColumn(table, "UNSIGNED_ATTRIBUTE", 16);
            this.addColumn(table, "FIXED_PREC_SCALE", 16);
            this.addColumn(table, "AUTO_INCREMENT", 16);
            this.addColumn(table, "LOCAL_TYPE_NAME", 12);
            this.addColumn(table, "MINIMUM_SCALE", 5);
            this.addColumn(table, "MAXIMUM_SCALE", 5);
            this.addColumn(table, "SQL_DATA_TYPE", 4);
            this.addColumn(table, "SQL_DATETIME_SUB", 4);
            this.addColumn(table, "NUM_PREC_RADIX", 4);
            this.addColumn(table, "TYPE_SUB", 4);
            table.createPrimaryKey(null, new int[]{1, 18}, true);
            return table;
        }
        Result result = this.session.sqlExecuteDirectNoPreChecks("select TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE,UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE, AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX, TYPE_SUB from SYSTEM_ALLTYPEINFO  where AS_TAB_COL = true;");
        table.insert(result);
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_ALLTYPEINFO() throws HsqlException {
        Table table = this.sysTables[29];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[29]);
            this.addColumn(table, "TYPE_NAME", 12, 32, false);
            this.addColumn(table, "DATA_TYPE", 5, false);
            this.addColumn(table, "PRECISION", 4);
            this.addColumn(table, "LITERAL_PREFIX", 12, 2, true);
            this.addColumn(table, "LITERAL_SUFFIX", 12, 2, true);
            this.addColumn(table, "CREATE_PARAMS", 12);
            this.addColumn(table, "NULLABLE", 5);
            this.addColumn(table, "CASE_SENSITIVE", 16);
            this.addColumn(table, "SEARCHABLE", 5);
            this.addColumn(table, "UNSIGNED_ATTRIBUTE", 16);
            this.addColumn(table, "FIXED_PREC_SCALE", 16);
            this.addColumn(table, "AUTO_INCREMENT", 16);
            this.addColumn(table, "LOCAL_TYPE_NAME", 12);
            this.addColumn(table, "MINIMUM_SCALE", 5);
            this.addColumn(table, "MAXIMUM_SCALE", 5);
            this.addColumn(table, "SQL_DATA_TYPE", 4);
            this.addColumn(table, "SQL_DATETIME_SUB", 4);
            this.addColumn(table, "NUM_PREC_RADIX", 4);
            this.addColumn(table, "INTERVAL_PRECISION", 4);
            this.addColumn(table, "AS_TAB_COL", 16);
            this.addColumn(table, "AS_PROC_COL", 16);
            this.addColumn(table, "MAX_PREC_ACT", -5);
            this.addColumn(table, "MIN_SCALE_ACT", 4);
            this.addColumn(table, "MAX_SCALE_ACT", 4);
            this.addColumn(table, "COL_ST_CLS_NAME", 12);
            this.addColumn(table, "COL_ST_IS_SUP", 16);
            this.addColumn(table, "STD_MAP_CLS_NAME", 12);
            this.addColumn(table, "STD_MAP_IS_SUP", 16);
            this.addColumn(table, "CST_MAP_CLS_NAME", 12);
            this.addColumn(table, "CST_MAP_IS_SUP", 16);
            this.addColumn(table, "MCOL_JDBC", 4);
            this.addColumn(table, "MCOL_ACT", -5);
            this.addColumn(table, "DEF_OR_FIXED_SCALE", 4);
            this.addColumn(table, "REMARKS", 12);
            this.addColumn(table, "TYPE_SUB", 4);
            table.createPrimaryKey(null, new int[]{1, 34}, true);
            return table;
        }
        DITypeInfo dITypeInfo = new DITypeInfo();
        for (int i = 0; i < Types.ALL_TYPES.length; ++i) {
            dITypeInfo.setTypeCode(Types.ALL_TYPES[i][0]);
            dITypeInfo.setTypeSub(Types.ALL_TYPES[i][1]);
            Object[] objectArray = table.getNewRow();
            objectArray[0] = dITypeInfo.getTypeName();
            objectArray[1] = dITypeInfo.getDataType();
            objectArray[2] = dITypeInfo.getPrecision();
            objectArray[3] = dITypeInfo.getLiteralPrefix();
            objectArray[4] = dITypeInfo.getLiteralSuffix();
            objectArray[5] = dITypeInfo.getCreateParams();
            objectArray[6] = dITypeInfo.getNullability();
            objectArray[7] = dITypeInfo.isCaseSensitive();
            objectArray[8] = dITypeInfo.getSearchability();
            objectArray[9] = dITypeInfo.isUnsignedAttribute();
            objectArray[10] = dITypeInfo.isFixedPrecisionScale();
            objectArray[11] = dITypeInfo.isAutoIncrement();
            objectArray[12] = dITypeInfo.getLocalName();
            objectArray[13] = dITypeInfo.getMinScale();
            objectArray[14] = dITypeInfo.getMaxScale();
            objectArray[15] = dITypeInfo.getSqlDataType();
            objectArray[16] = dITypeInfo.getSqlDateTimeSub();
            objectArray[17] = dITypeInfo.getNumPrecRadix();
            objectArray[18] = dITypeInfo.getIntervalPrecision();
            objectArray[19] = dITypeInfo.isSupportedAsTCol();
            objectArray[20] = dITypeInfo.isSupportedAsPCol();
            objectArray[21] = dITypeInfo.getPrecisionAct();
            objectArray[22] = dITypeInfo.getMinScaleAct();
            objectArray[23] = dITypeInfo.getMaxScaleAct();
            objectArray[24] = dITypeInfo.getColStClsName();
            objectArray[25] = dITypeInfo.isColStClsSupported();
            objectArray[26] = dITypeInfo.getStdMapClsName();
            objectArray[27] = dITypeInfo.isStdMapClsSupported();
            objectArray[28] = dITypeInfo.getCstMapClsName();
            try {
                this.ns.classForName((String)objectArray[28]);
                objectArray[29] = Boolean.TRUE;
            }
            catch (Exception exception) {
                objectArray[29] = Boolean.FALSE;
            }
            objectArray[30] = dITypeInfo.getCharOctLen();
            objectArray[31] = dITypeInfo.getCharOctLenAct();
            objectArray[32] = dITypeInfo.getDefaultScale();
            objectArray[33] = dITypeInfo.getRemarks();
            objectArray[34] = dITypeInfo.getDataTypeSub();
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    Table SYSTEM_USERS() throws HsqlException {
        Table table = this.sysTables[18];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[18]);
            this.addColumn(table, "USER", 12, false);
            this.addColumn(table, "ADMIN", 16, false);
            table.createPrimaryKey(null, new int[]{0}, true);
            return table;
        }
        HsqlArrayList hsqlArrayList = this.database.getUserManager().listVisibleUsers(this.session, false);
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Object[] objectArray = table.getNewRow();
            User user = (User)hsqlArrayList.get(i);
            objectArray[0] = user.getName();
            objectArray[1] = ValuePool.getBoolean(user.isAdmin());
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    final Table SYSTEM_CHECK_CONSTRAINTS() throws HsqlException {
        Constraint constraint;
        int n;
        Table table;
        Table table2 = this.sysTables[34];
        if (table2 == null) {
            table2 = this.createBlankTable(sysTableHsqlNames[34]);
            this.addColumn(table2, "CONSTRAINT_CATALOG", 12);
            this.addColumn(table2, "CONSTRAINT_SCHEMA", 12);
            this.addColumn(table2, "CONSTRAINT_NAME", 12, false);
            this.addColumn(table2, "CHECK_CLAUSE", 12, false);
            table2.createPrimaryKey(null, new int[]{0, 1, 2}, false);
            return table2;
        }
        Iterator iterator = this.database.getTables().iterator();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (iterator.hasNext()) {
            table = (Table)iterator.next();
            if (!this.isAccessibleTable(table)) continue;
            Constraint[] constraintArray = table.getConstraints();
            int n2 = constraintArray.length;
            for (n = 0; n < n2; ++n) {
                constraint = constraintArray[n];
                if (constraint.getType() != 3) continue;
                hsqlArrayList.add(constraint);
            }
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            Object[] objectArray = table2.getNewRow();
            constraint = (Constraint)hsqlArrayList.get(n);
            table = constraint.getMain();
            objectArray[0] = this.ns.getCatalogName(table);
            objectArray[1] = this.ns.getSchemaName(table);
            objectArray[2] = constraint.constName.name;
            try {
                objectArray[3] = constraint.core.check.getDDL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            table2.insert(objectArray);
        }
        table2.setDataReadOnly(true);
        return table2;
    }

    final Table SYSTEM_SEQUENCES() throws HsqlException {
        Table table = this.sysTables[32];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[32]);
            this.addColumn(table, "SEQUENCE_CATALOG", 12);
            this.addColumn(table, "SEQUENCE_SCHEMA", 12);
            this.addColumn(table, "SEQUENCE_NAME", 12, true);
            this.addColumn(table, "DTD_IDENTIFIER", 12, true);
            this.addColumn(table, "MAXIMUM_VALUE", 12, 20, true);
            this.addColumn(table, "MINIMUM_VALUE", 12, 20, true);
            this.addColumn(table, "INCREMENT", 12, 20, true);
            this.addColumn(table, "CYCLE_OPTION", 12, 3, true);
            this.addColumn(table, "START_WITH", 12, 20, true);
            table.createPrimaryKey(null, new int[]{0, 1, 2}, false);
            return table;
        }
        String string = ValuePool.getString("0");
        String string2 = ValuePool.getString(String.valueOf(Integer.MAX_VALUE));
        String string3 = String.valueOf(Long.MAX_VALUE);
        String string4 = ValuePool.getString("NO");
        Iterator iterator = this.database.sequenceManager.sequenceMap.values().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = table.getNewRow();
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            int n = numberSequence.getType();
            String string5 = numberSequence.getName().name;
            objectArray[0] = this.ns.getCatalogName(numberSequence);
            objectArray[1] = this.ns.getSchemaName(numberSequence);
            objectArray[2] = string5;
            objectArray[3] = Types.getTypeString(n);
            objectArray[5] = string;
            objectArray[6] = String.valueOf(numberSequence.getIncrement());
            objectArray[7] = string4;
            objectArray[8] = String.valueOf(numberSequence.peek());
            switch (n) {
                case 4: {
                    objectArray[4] = string2;
                    break;
                }
                default: {
                    objectArray[4] = string3;
                }
            }
            table.insert(objectArray);
        }
        table.setDataReadOnly(true);
        return table;
    }

    static {
        tableTypes = new String[]{"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"};
        columnNameMap = new HashMap();
        indexNameMap = new HashMap();
        nonCachedTablesSet = new HashSet();
        sysTableHsqlNames = new HsqlNameManager.HsqlName[sysTableNames.length];
        for (int i = 0; i < sysTableNames.length; ++i) {
            DatabaseInformationMain.sysTableHsqlNames[i] = HsqlNameManager.newHsqlSystemTableName(sysTableNames[i]);
        }
        nonCachedTablesSet.add("SYSTEM_CACHEINFO");
        nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
        nonCachedTablesSet.add("SYSTEM_SESSIONS");
        nonCachedTablesSet.add("SYSTEM_PROPERTIES");
        nonCachedTablesSet.add("SYSTEM_SEQUENCES");
    }
}

