/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.MemoryNode;
import org.hsqldb.PointerNode;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

abstract class Node {
    static final int NO_POS = -1;
    protected int iBalance;
    Node nNext;

    Node() {
    }

    static final Node newNode(Row row, int n, Table table) {
        switch (table.getIndexType()) {
            case 0: {
                return new MemoryNode(row);
            }
            case 2: {
                return new PointerNode((CachedRow)row, n);
            }
        }
        return new DiskNode((CachedRow)row, n);
    }

    static final Node newNode(Row row, RowInputInterface rowInputInterface, int n, Table table) throws IOException, HsqlException {
        switch (table.getIndexType()) {
            case 0: {
                return new MemoryNode(row);
            }
            case 2: {
                return new PointerNode((CachedRow)row, n);
            }
        }
        return new DiskNode((CachedRow)row, rowInputInterface, n);
    }

    abstract void delete();

    abstract int getKey();

    abstract Row getRow() throws HsqlException;

    abstract Node getLeft() throws HsqlException;

    abstract void setLeft(Node var1) throws HsqlException;

    abstract Node getRight() throws HsqlException;

    abstract void setRight(Node var1) throws HsqlException;

    abstract Node getParent() throws HsqlException;

    abstract void setParent(Node var1) throws HsqlException;

    final int getBalance() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return this.iBalance;
    }

    abstract void setBalance(int var1) throws HsqlException;

    abstract boolean isRoot();

    abstract boolean isFromLeft() throws HsqlException;

    abstract Object[] getData() throws HsqlException;

    abstract boolean equals(Node var1) throws HsqlException;

    Node getUpdatedNode() throws HsqlException {
        return this;
    }

    abstract void write(RowOutputInterface var1) throws IOException, HsqlException;

    boolean isDeleted() {
        return this.iBalance == -2;
    }
}

