/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.WebServer;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class WebServerConnection
implements Runnable {
    static final String ENCODING = "8859_1";
    private Socket socket;
    private WebServer server;
    private static final int REQUEST_TYPE_BAD = 0;
    private static final int REQUEST_TYPE_GET = 1;
    private static final int REQUEST_TYPE_HEAD = 2;
    private static final int REQUEST_TYPE_POST = 3;
    private static final String HEADER_OK = "HTTP/1.0 200 OK";
    private static final String HEADER_BAD_REQUEST = "HTTP/1.0 400 Bad Request";
    private static final String HEADER_NOT_FOUND = "HTTP/1.0 404 Not Found";
    private static final String HEADER_FORBIDDEN = "HTTP/1.0 403 Forbidden";
    static final int BUFFER_SIZE = 256;
    RowOutputBinary rowOut = new RowOutputBinary(256);
    RowInputBinary rowIn = new RowInputBinary(this.rowOut);
    static final byte[] BYTES_GET = "GET".getBytes();
    static final byte[] BYTES_HEAD = "HEAD".getBytes();
    static final byte[] BYTES_POST = "POST".getBytes();
    static final byte[] BYTES_CONTENT = "Content-Length: ".getBytes();
    static final byte[] BYTES_WHITESPACE = new byte[]{32, 9};
    private static final int hnd_content_types = BundleHandler.getBundleHandle("content_types", null);

    WebServerConnection(Socket socket, WebServer webServer) {
        this.server = webServer;
        this.socket = socket;
    }

    private String getMimeTypeString(String string) {
        if (string == null) {
            return "text/html";
        }
        int n = string.lastIndexOf(46);
        String string2 = null;
        String string3 = null;
        if (n >= 0) {
            string2 = string.substring(n).toLowerCase();
            string3 = this.server.serverProperties.getProperty(string2);
        }
        if (string3 == null && string2.length() > 1) {
            string3 = BundleHandler.getString(hnd_content_types, string2.substring(1));
        }
        return string3 == null ? "text/html" : string3;
    }

    public void run() {
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(this.socket.getInputStream());
            String string = null;
            int n3 = 0;
            int n4 = -1;
            do {
                if ((n2 = InOutUtil.readLine(dataInputStream, this.rowOut)) != 0) continue;
                throw new Exception();
            } while (n2 < 2);
            byte[] byArray = this.rowOut.getBuffer();
            if (ArrayUtil.containsAt(byArray, n = this.rowOut.size() - n2, BYTES_POST)) {
                n3 = 3;
                n += BYTES_POST.length;
            } else if (ArrayUtil.containsAt(byArray, n, BYTES_GET)) {
                n3 = 1;
                n += BYTES_GET.length;
            } else if (ArrayUtil.containsAt(byArray, n, BYTES_HEAD)) {
                n3 = 2;
                n += BYTES_HEAD.length;
            } else {
                throw new Exception();
            }
            n2 = ArrayUtil.countStartElementsAt(byArray, n, BYTES_WHITESPACE);
            if (n2 == 0) {
                throw new Exception();
            }
            n += n2;
            n2 = ArrayUtil.countNonStartElementsAt(byArray, n, BYTES_WHITESPACE);
            string = new String(byArray, n, n2, ENCODING);
            switch (n3) {
                case 0: {
                    this.processError(0);
                    break;
                }
                case 1: {
                    this.processGet(string, true);
                    break;
                }
                case 2: {
                    this.processGet(string, false);
                    break;
                }
                case 3: {
                    this.processPost(dataInputStream, string);
                }
            }
            dataInputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {
            this.server.printStackTrace(exception);
        }
    }

    private void processPost(InputStream inputStream, String string) throws HsqlException, IOException {
        try {
            InOutUtil.readLine(inputStream, this.rowOut);
            int n = InOutUtil.readLine(inputStream, this.rowOut);
            int n2 = this.rowOut.size() - n;
            byte[] byArray = this.rowOut.getBuffer();
            if (!ArrayUtil.containsAt(byArray, n2, BYTES_CONTENT)) {
                throw new Exception();
            }
            String string2 = new String(byArray, n2 += BYTES_CONTENT.length, (n -= BYTES_CONTENT.length) - 2);
            int n3 = Integer.parseInt(string2);
            InOutUtil.readLine(inputStream, this.rowOut);
        }
        catch (Exception exception) {
            this.processError(400);
            return;
        }
        this.processQuery(inputStream);
    }

    void processQuery(InputStream inputStream) {
        try {
            Result result;
            Result result2 = Result.read(this.rowIn, new BufferedInputStream(inputStream));
            if (result2.iMode == 65543) {
                try {
                    int n = ArrayUtil.find(this.server.dbAlias, result2.subSubString);
                    int n2 = this.server.dbID[n];
                    Session session = DatabaseManager.newSession(n2, result2.getMainString(), result2.getSubString());
                    result = new Result(1);
                    result.databaseID = n2;
                    result.sessionID = session.getId();
                }
                catch (HsqlException hsqlException) {
                    result = new Result(hsqlException, null);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    result = new Result(Trace.error(94), result2.subSubString);
                }
            } else {
                int n = result2.databaseID;
                Session session = DatabaseManager.getSession(this.server.dbType[n], this.server.dbPath[n], result2.sessionID);
                result = session.execute(result2);
            }
            this.rowOut.reset();
            result.write(this.rowOut);
            OutputStream outputStream = this.socket.getOutputStream();
            String string = this.getHead(HEADER_OK, false, "application/octet-stream", this.rowOut.size());
            outputStream.write(string.getBytes(ENCODING));
            outputStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            this.server.printStackTrace(exception);
        }
    }

    private void processGet(String string, boolean bl) {
        try {
            String string2;
            if (string.endsWith("/")) {
                string = string + this.server.getDefaultWebPage();
            }
            if (string.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            string = this.server.getWebRoot() + string;
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            BufferedInputStream bufferedInputStream = null;
            this.server.printWithThread("GET " + string);
            try {
                File file = new File(string);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                string2 = this.getHead(HEADER_OK, true, this.getMimeTypeString(string), (int)file.length());
            }
            catch (IOException iOException) {
                this.processError(404);
                return;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(string2.getBytes(ENCODING));
            if (bl) {
                int n;
                while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                    ((OutputStream)bufferedOutputStream).write(n);
                }
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            this.server.printError("processGet: " + exception.getMessage());
            this.server.printStackTrace(exception);
        }
    }

    String getHead(String string, boolean bl, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string).append("\r\n");
        if (bl) {
            stringBuffer.append("Allow: GET, HEAD, POST\nMIME-Version: 1.0\r\n");
            stringBuffer.append("Server: ").append("HSQLDB/1.7.2").append("\r\n");
        }
        if (string2 != null) {
            stringBuffer.append("Content-Type: ").append(string2).append("\r\n");
            stringBuffer.append("Content-Length: ").append(n).append("\r\n");
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    private void processError(int n) {
        String string;
        this.server.printWithThread("processError " + n);
        switch (n) {
            case 400: {
                string = this.getHead(HEADER_BAD_REQUEST, false, null, 0);
                string = string + BundleHandler.getString(WebServer.webBundleHandle, "BAD_REQUEST");
                break;
            }
            case 404: {
                string = this.getHead(HEADER_NOT_FOUND, false, null, 0);
                string = string + BundleHandler.getString(WebServer.webBundleHandle, "NOT_FOUND");
                break;
            }
            case 403: {
                string = this.getHead(HEADER_FORBIDDEN, false, null, 0);
                string = string + BundleHandler.getString(WebServer.webBundleHandle, "FORBIDDEN");
                break;
            }
            default: {
                string = null;
            }
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
            ((OutputStream)bufferedOutputStream).write(string.getBytes(ENCODING));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            this.server.printError("processError: " + exception.getMessage());
            this.server.printStackTrace(exception);
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB HTTP Connection @" + Integer.toString(this.hashCode(), 16);
    }
}

