/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.type.Type;

public class CacheKey
implements Serializable {
    private final Serializable key;
    private final Type type;
    private final String entityOrRoleName;
    private EntityMode entityMode;

    public CacheKey(Serializable id, Type type, String entityOrRoleName, EntityMode entityMode) {
        this.key = id;
        this.type = type;
        this.entityOrRoleName = entityOrRoleName;
        this.entityMode = entityMode;
    }

    public String toString() {
        return String.valueOf(this.entityOrRoleName) + '#' + this.key.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CacheKey)) {
            return false;
        }
        CacheKey that = (CacheKey)other;
        return this.type.isEqual(this.key, that.key, this.entityMode) && this.entityOrRoleName.equals(that.entityOrRoleName);
    }

    public int hashCode() {
        return this.type.getHashCode(this.key, this.entityMode);
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getEntityOrRoleName() {
        return this.entityOrRoleName;
    }
}

