/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.DefaultNamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.SessionEventListenerConfig;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.SerializationHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Configuration
implements Serializable {
    private static Log log;
    protected Map classes;
    protected Map imports;
    protected Map collections;
    protected Map tables;
    protected Map namedQueries;
    protected Map namedSqlQueries;
    protected Map filterDefinitions;
    protected List secondPasses;
    protected List propertyReferences;
    protected Map extendsQueue;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private Map eventListeners;
    private transient XMLHelper xmlHelper;
    protected transient Map typeDefs;
    protected NamingStrategy namingStrategy = DefaultNamingStrategy.INSTANCE;
    private final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private static final Interceptor EMPTY_INTERCEPTOR;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cfg.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        EMPTY_INTERCEPTOR = new EmptyInterceptor();
    }

    protected void reset() {
        this.classes = new HashMap();
        this.imports = new HashMap();
        this.collections = new HashMap();
        this.tables = new TreeMap();
        this.namedQueries = new HashMap();
        this.namedSqlQueries = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.typeDefs = new HashMap();
        this.propertyReferences = new ArrayList();
        this.secondPasses = new ArrayList();
        this.interceptor = EMPTY_INTERCEPTOR;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.eventListeners = new HashMap();
        this.filterDefinitions = new HashMap();
        this.extendsQueue = new HashMap();
    }

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    public Iterator getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator getTableMappings() {
        return this.tables.values().iterator();
    }

    public PersistentClass getClassMapping(String persistentClass) {
        return (PersistentClass)this.classes.get(persistentClass);
    }

    public Collection getCollectionMapping(String role) {
        return (Collection)this.collections.get(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile));
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader(xmlFile, errors, this.entityResolver).read(new File(xmlFile));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
            return this;
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile), (Throwable)e);
            throw new MappingException(e);
        }
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        try {
            boolean useCachedFile;
            File lazyfile = new File(String.valueOf(xmlFile.getAbsolutePath()) + ".bin");
            Document doc = null;
            ArrayList errors = new ArrayList();
            boolean bl = useCachedFile = xmlFile.exists() && lazyfile.exists() && xmlFile.lastModified() < lazyfile.lastModified();
            if (useCachedFile) {
                try {
                    log.info((Object)("Mapping cached file: " + lazyfile));
                    doc = (Document)SerializationHelper.deserialize(new FileInputStream(lazyfile));
                }
                catch (SerializationException e) {
                    log.warn((Object)("Could not deserialize cached file: " + lazyfile.getPath()), (Throwable)e);
                }
            }
            if (doc == null) {
                doc = this.xmlHelper.createSAXReader(xmlFile.getAbsolutePath(), errors, this.entityResolver).read(xmlFile);
                try {
                    log.info((Object)("Writing cached file of " + xmlFile + " to " + lazyfile));
                    SerializationHelper.serialize((Serializable)doc, new FileOutputStream(lazyfile));
                }
                catch (SerializationException e) {
                    log.warn((Object)("Could not write cached file: " + lazyfile), (Throwable)e);
                }
            }
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
            return this;
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile), (Throwable)e);
            throw new MappingException(e);
        }
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        return this.addCacheableFile(new File(xmlFile));
    }

    public Configuration addXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + xml));
        }
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader("XML String", errors, this.entityResolver).read((Reader)new StringReader(xml));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping URL:\n" + url));
        }
        try {
            this.addInputStream(url.openStream());
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from URL", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addDocument(org.w3c.dom.Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + doc));
        }
        try {
            this.add(this.xmlHelper.createDOMReader().read(doc));
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML document", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    protected void add(Document doc) throws MappingException {
        try {
            HbmBinder.bindRoot(doc, this.createMappings(), CollectionHelper.EMPTY_MAP);
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping document", (Throwable)me);
            throw me;
        }
    }

    public Mappings createMappings() {
        return new Mappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.extendsQueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            try {
                ArrayList errors = new ArrayList();
                Document doc = this.xmlHelper.createSAXReader("XML InputStream", errors, this.entityResolver).read(new InputSource(xmlInputStream));
                if (errors.size() != 0) {
                    throw new MappingException("invalid mapping", (Throwable)errors.get(0));
                }
                this.add(doc);
                Configuration configuration = this;
                Object var4_7 = null;
                try {
                    xmlInputStream.close();
                    return configuration;
                }
                catch (IOException ioe) {
                    log.error((Object)"could not close input stream", (Throwable)ioe);
                }
                return configuration;
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from input stream", (Throwable)e);
                throw new MappingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {}
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
                throw throwable;
            }
            xmlInputStream.close();
            throw throwable;
        }
    }

    public Configuration addResource(String path, ClassLoader classLoader) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = classLoader.getResourceAsStream(path);
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, me);
        }
    }

    public Configuration addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.hibernate.cfg.Environment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rsrc = clazz.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, me);
        }
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String fileName = String.valueOf(persistentClass.getName().replace('.', '/')) + ".hbm.xml";
        log.info((Object)("Mapping resource: " + fileName));
        InputStream rsrc = persistentClass.getClassLoader().getResourceAsStream(fileName);
        if (rsrc == null) {
            throw new MappingException("Resource: " + fileName + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + fileName, me);
        }
    }

    public Configuration addJar(File jar) throws MappingException {
        JarFile jarFile;
        log.info((Object)("Searching for mapping documents in jar: " + jar.getName()));
        try {
            jarFile = new JarFile(jar);
        }
        catch (IOException ioe) {
            log.error((Object)("Could not configure datastore from jar: " + jar.getName()), (Throwable)ioe);
            throw new MappingException("Could not configure datastore from jar: " + jar.getName(), ioe);
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            ZipEntry ze = jarEntries.nextElement();
            if (!ze.getName().endsWith(".hbm.xml")) continue;
            log.info((Object)("Found mapping documents in jar: " + ze.getName()));
            try {
                this.addInputStream(jarFile.getInputStream(ze));
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from jar", (Throwable)e);
                throw new MappingException(e);
            }
        }
        return this;
    }

    public Configuration addDirectory(File dir) throws MappingException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.addDirectory(files[i]);
            } else if (files[i].getName().endsWith(".hbm.xml")) {
                this.addFile(files[i]);
            }
            ++i;
        }
        return this;
    }

    private Iterator iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            PersistentClass pc = (PersistentClass)iter.next();
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator(dialect, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema"), pc.getEntityName())) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            Collection collection = (Collection)iter.next();
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(dialect, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema"), null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        Iterator iter;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        if (dialect.dropConstraints()) {
            iter = this.getTableMappings();
            while (iter.hasNext()) {
                table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
                }
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlDropStrings(dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    script.add(uk.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        TableMetadata tableInfo;
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
                continue;
            }
            Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema"));
            while (subiter.hasNext()) {
                script.add((String)subiter.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema(), table.getCatalog());
            if (!dialect.hasAlterTable()) continue;
            Iterator subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                boolean create;
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                boolean bl = create = tableInfo == null || tableInfo.getForeignKeyMetadata(fk.getName()) == null && (!(dialect instanceof MySQLDialect) || tableInfo.getIndexMetadata(fk.getName()) == null);
                if (!create) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping, this.properties.getProperty("hibernate.default_catalog"), this.properties.getProperty("hibernate.default_schema")));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private void validate() throws MappingException {
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            ((PersistentClass)iter.next()).validate(this.mapping);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected Document findPossibleExtends() {
        Iterator iter = this.extendsQueue.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String superclass = (String)entry.getKey();
            if (this.getClassMapping(superclass) == null) continue;
            List queue = (List)entry.getValue();
            if (queue.isEmpty()) {
                iter.remove();
                continue;
            }
            return (Document)queue.remove(0);
        }
        return null;
    }

    protected void secondPassCompile() throws MappingException {
        log.info((Object)"processing extends queue");
        this.processExtendsQueue();
        log.info((Object)"processing collection mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            HbmBinder.SecondPass sp = (HbmBinder.SecondPass)iter.next();
            sp.doSecondPass(this.classes, CollectionHelper.EMPTY_MAP);
            iter.remove();
        }
        log.info((Object)"processing association property references");
        iter = this.propertyReferences.iterator();
        while (iter.hasNext()) {
            Mappings.PropertyReference upr = (Mappings.PropertyReference)iter.next();
            PersistentClass clazz = this.getClassMapping(upr.referencedClass);
            if (clazz == null) {
                throw new MappingException("property-ref to unmapped class: " + upr.referencedClass);
            }
            boolean found = false;
            Iterator propIter = clazz.isJoinedSubclass() ? clazz.getPropertyIterator() : clazz.getPropertyClosureIterator();
            while (propIter.hasNext()) {
                Property prop = (Property)propIter.next();
                if (!upr.propertyName.equals(prop.getName())) continue;
                if (upr.unique) {
                    ((SimpleValue)prop.getValue()).setAlternateUniqueKey(true);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new MappingException("property-ref not found: " + upr.propertyName + " in class: " + upr.referencedClass);
        }
        log.info((Object)"processing foreign key constraints");
        iter = this.getTableMappings();
        HashSet done = new HashSet();
        while (iter.hasNext()) {
            this.secondPassCompileForeignKeys((Table)iter.next(), done);
        }
    }

    private void processExtendsQueue() {
        Document document = this.findPossibleExtends();
        while (document != null) {
            this.add(document);
            document = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator iterator = this.extendsQueue.keySet().iterator();
            StringBuffer buf = new StringBuffer("Following superclasses referenced in extends not found: ");
            while (iterator.hasNext()) {
                String element = (String)iterator.next();
                buf.append(element);
                if (!iterator.hasNext()) continue;
                buf.append(",");
            }
            throw new MappingException(buf.toString());
        }
    }

    protected void secondPassCompileForeignKeys(Table table, Set done) throws MappingException {
        table.createForeignKeys();
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            PersistentClass referencedClass;
            ForeignKey fk = (ForeignKey)iter.next();
            if (done.contains(fk)) continue;
            done.add(fk);
            String referencedEntityName = fk.getReferencedEntityName();
            if (referencedEntityName == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " does not specify the referenced entity");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolving reference to class: " + referencedEntityName));
            }
            if ((referencedClass = (PersistentClass)this.classes.get(referencedEntityName)) == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + referencedEntityName);
            }
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done);
            }
            fk.setReferencedTable(referencedClass.getTable());
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug((Object)("Preparing to build session factory with filters : " + this.filterDefinitions));
        this.secondPassCompile();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        Settings settings = this.buildSettings();
        SessionEventListenerConfig listeners = this.buildListenerConfig();
        return new SessionFactoryImpl(this, this.mapping, settings, listeners);
    }

    private SessionEventListenerConfig buildListenerConfig() {
        SessionEventListenerConfig sessionEventListenerConfig = new SessionEventListenerConfig();
        Iterator itr = this.eventListeners.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String type = (String)entry.getKey();
            Object listener = entry.getValue();
            if ("auto-flush".equals(type)) {
                sessionEventListenerConfig.setAutoFlushEventListener((AutoFlushEventListener)listener);
                continue;
            }
            if ("merge".equals(type)) {
                sessionEventListenerConfig.setMergeEventListener((MergeEventListener)listener);
                continue;
            }
            if ("create".equals(type)) {
                sessionEventListenerConfig.setCreateEventListener((PersistEventListener)listener);
                continue;
            }
            if ("delete".equals(type)) {
                sessionEventListenerConfig.setDeleteEventListener((DeleteEventListener)listener);
                continue;
            }
            if ("dirty-check".equals(type)) {
                sessionEventListenerConfig.setDirtyCheckEventListener((DirtyCheckEventListener)listener);
                continue;
            }
            if ("evict".equals(type)) {
                sessionEventListenerConfig.setEvictEventListener((EvictEventListener)listener);
                continue;
            }
            if ("flush".equals(type)) {
                sessionEventListenerConfig.setFlushEventListener((FlushEventListener)listener);
                continue;
            }
            if ("flush-entity".equals(type)) {
                sessionEventListenerConfig.setFlushEntityEventListener((FlushEntityEventListener)listener);
                continue;
            }
            if ("load".equals(type)) {
                sessionEventListenerConfig.setLoadEventListener((LoadEventListener)listener);
                continue;
            }
            if ("load-collection".equals(type)) {
                sessionEventListenerConfig.setInitializeCollectionEventListener((InitializeCollectionEventListener)listener);
                continue;
            }
            if ("lock".equals(type)) {
                sessionEventListenerConfig.setLockEventListener((LockEventListener)listener);
                continue;
            }
            if ("refresh".equals(type)) {
                sessionEventListenerConfig.setRefreshEventListener((RefreshEventListener)listener);
                continue;
            }
            if ("replicate".equals(type)) {
                sessionEventListenerConfig.setReplicateEventListener((ReplicateEventListener)listener);
                continue;
            }
            if ("save-update".equals(type)) {
                sessionEventListenerConfig.setSaveOrUpdateEventListener((SaveOrUpdateEventListener)listener);
                continue;
            }
            if ("pre-load".equals(type)) {
                sessionEventListenerConfig.setPreLoadEventListener((PreLoadEventListener)listener);
                continue;
            }
            if ("pre-update".equals(type)) {
                sessionEventListenerConfig.setPreUpdateEventListener((PreUpdateEventListener)listener);
                continue;
            }
            if ("pre-delete".equals(type)) {
                sessionEventListenerConfig.setPreDeleteEventListener((PreDeleteEventListener)listener);
                continue;
            }
            if ("pre-insert".equals(type)) {
                sessionEventListenerConfig.setPreInsertEventListener((PreInsertEventListener)listener);
                continue;
            }
            if ("post-load".equals(type)) {
                sessionEventListenerConfig.setPostLoadEventListener((PostLoadEventListener)listener);
                continue;
            }
            if ("post-update".equals(type)) {
                sessionEventListenerConfig.setPostUpdateEventListener((PostUpdateEventListener)listener);
                continue;
            }
            if ("post-delete".equals(type)) {
                sessionEventListenerConfig.setPostDeleteEventListener((PostDeleteEventListener)listener);
                continue;
            }
            if ("post-insert".equals(type)) {
                sessionEventListenerConfig.setPostInsertEventListener((PostInsertEventListener)listener);
                continue;
            }
            log.warn((Object)("Unrecognized listener type [" + type + "]"));
        }
        return sessionEventListenerConfig;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    private void addProperties(Element parent) {
        Iterator iter = parent.elementIterator("property");
        while (iter.hasNext()) {
            Element node = (Element)iter.next();
            String name = node.attributeValue("name");
            String value = node.getText().trim();
            log.debug((Object)(String.valueOf(name) + "=" + value));
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        InputStream stream;
        log.info((Object)("Configuration resource: " + resource));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.hibernate.cfg.Environment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        if (stream == null) {
            log.warn((Object)(String.valueOf(resource) + " not found"));
            throw new HibernateException(String.valueOf(resource) + " not found");
        }
        return stream;
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        log.info((Object)("configuring from resource: " + resource));
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.doConfigure(stream, resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        log.info((Object)("configuring from url: " + url.toString()));
        try {
            return this.doConfigure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        log.info((Object)("configuring from file: " + configFile.getName()));
        try {
            return this.doConfigure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        Document doc;
        try {
            try {
                ArrayList errors = new ArrayList();
                doc = this.xmlHelper.createSAXReader(resourceName, errors, this.entityResolver).read(new InputSource(stream));
                if (errors.size() != 0) {
                    throw new MappingException("invalid configuration", (Throwable)errors.get(0));
                }
            }
            catch (Exception e) {
                log.error((Object)("problem parsing configuration" + resourceName), (Throwable)e);
                throw new HibernateException("problem parsing configuration" + resourceName, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                log.error((Object)("could not close stream on: " + resourceName), (Throwable)ioe);
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException ioe) {
            log.error((Object)("could not close stream on: " + resourceName), (Throwable)ioe);
            return this.doConfigure(doc);
        }
        stream.close();
        return this.doConfigure(doc);
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        Document doc;
        log.info((Object)"configuring from XML document");
        try {
            doc = this.xmlHelper.createDOMReader().read(document);
        }
        catch (Exception e) {
            log.error((Object)"problem parsing document", (Throwable)e);
            throw new HibernateException("problem parsing document", e);
        }
        return this.doConfigure(doc);
    }

    protected Configuration doConfigure(Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        this.parseSessionFactory(sfNode, name);
        Element secNode = doc.getRootElement().element("security");
        if (secNode != null) {
            this.parseSecurity(secNode);
        }
        log.info((Object)("Configured SessionFactory: " + name));
        log.debug((Object)("properties: " + this.properties));
        return this;
    }

    private void parseSessionFactory(Element sfNode, String name) {
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            String region;
            Attribute regionNode;
            Element subelement = (Element)elements.next();
            String subelementName = subelement.getName();
            if ("mapping".equals(subelementName)) {
                this.parseMappingElement(subelement, name);
                continue;
            }
            if ("class-cache".equals(subelementName)) {
                String className = subelement.attributeValue("class");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? className : regionNode.getValue();
                this.setCacheConcurrencyStrategy(className, subelement.attributeValue("usage"), region);
                continue;
            }
            if ("collection-cache".equals(subelementName)) {
                String role = subelement.attributeValue("collection");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? role : regionNode.getValue();
                this.setCollectionCacheConcurrencyStrategy(role, subelement.attributeValue("usage"), region);
                continue;
            }
            if (!"listener".equals(subelementName)) continue;
            this.parseListener(subelement);
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pkg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug((Object)(String.valueOf(name) + "<-" + rsrc));
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug((Object)(String.valueOf(name) + "<-" + jar));
            this.addJar(new File(jar.getValue()));
        } else {
            if (pkg != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping package=\"" + pkg.getValue() + "\"/>");
            }
            if (clazz != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping clazz=\"" + clazz.getValue() + "\"/>");
            }
            if (file == null) {
                throw new MappingException("<mapping> element in configuration specifies no attributes");
            }
            log.debug((Object)(String.valueOf(name) + "<-" + file));
            this.addFile(file.getValue());
        }
    }

    private void parseSecurity(Element secNode) {
        String contextId = secNode.attributeValue("context");
        log.info((Object)("JACC contextID: " + contextId));
        JACCConfiguration jcfg = new JACCConfiguration(contextId);
        Iterator grantElements = secNode.elementIterator();
        while (grantElements.hasNext()) {
            Element grantElement = (Element)grantElements.next();
            String elementName = grantElement.getName();
            if (!"grant".equals(elementName)) continue;
            jcfg.addPermission(grantElement.attributeValue("role"), grantElement.attributeValue("entity-name"), grantElement.attributeValue("actions"));
        }
    }

    private void parseListener(Element element) {
        String type = element.attributeValue("type");
        String impl = element.attributeValue("class");
        log.debug((Object)("Encountered configured listener : " + type + "=" + impl));
        try {
            Object listener = Class.forName(impl).newInstance();
            this.setListener(type, listener);
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to parsed specified listener config; using default", t);
        }
    }

    public void setListener(String type, Object listener) {
        this.eventListeners.put(type, listener);
    }

    RootClass getRootClassMapping(String clazz) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(clazz);
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy) throws MappingException {
        this.setCacheConcurrencyStrategy(clazz, concurrencyStrategy, clazz);
        return this;
    }

    void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region) throws MappingException {
        RootClass rootClass = this.getRootClassMapping(clazz);
        rootClass.setCacheConcurrencyStrategy(concurrencyStrategy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy) throws MappingException {
        this.setCollectionCacheConcurrencyStrategy(collectionRole, concurrencyStrategy, collectionRole);
        return this;
    }

    void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        Collection collection = this.getCollectionMapping(collectionRole);
        collection.setCacheConcurrencyStrategy(concurrencyStrategy);
    }

    public Map getImports() {
        return this.imports;
    }

    public Settings buildSettings() throws HibernateException {
        return this.settingsFactory.buildSettings(this.properties);
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    private Mapping buildMapping() {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = (PersistentClass)Configuration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    static final class EmptyInterceptor
    implements Interceptor,
    Serializable {
        EmptyInterceptor() {
        }

        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        }

        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public void postFlush(Iterator entities) {
        }

        public void preFlush(Iterator entities) {
        }

        public Boolean isTransient(Object entity) {
            return null;
        }

        public Object instantiate(String entityName, EntityMode entityMode, Serializable id) {
            return null;
        }

        public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return null;
        }

        public String getEntityName(Object object) {
            return null;
        }

        public Object getEntity(String entityName, Serializable id) {
            return null;
        }

        public void afterTransactionBegin(Transaction tx) {
        }

        public void afterTransactionCompletion(Transaction tx) {
        }

        public void beforeTransactionCompletion(Transaction tx) {
        }
    }
}

