/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.util.StringHelper;

public class Mappings
implements Serializable {
    private static final Log log;
    private final Map classes;
    private final Map collections;
    private final Map tables;
    private final Map queries;
    private final Map sqlqueries;
    private final Map typeDefs;
    private final List secondPasses;
    private final Map imports;
    private String schemaName;
    private String catalogName;
    private String defaultCascade;
    private String defaultPackage;
    private String defaultAccess;
    private boolean autoImport;
    private boolean defaultLazy;
    private final List propertyReferences;
    private final NamingStrategy namingStrategy;
    private final Map filterDefinitions;
    private final Map extendsQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cfg.Mappings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    Mappings(Map classes, Map collections, Map tables, Map queries, Map sqlqueries, Map imports, List secondPasses, List propertyReferences, NamingStrategy namingStrategy, Map typeDefs, Map filterDefinitions, Map extendsQueue) {
        this.classes = classes;
        this.collections = collections;
        this.queries = queries;
        this.sqlqueries = sqlqueries;
        this.tables = tables;
        this.imports = imports;
        this.secondPasses = secondPasses;
        this.propertyReferences = propertyReferences;
        this.namingStrategy = namingStrategy;
        this.typeDefs = typeDefs;
        this.filterDefinitions = filterDefinitions;
        this.extendsQueue = extendsQueue;
    }

    public void addClass(PersistentClass persistentClass) throws MappingException {
        PersistentClass old = this.classes.put(persistentClass.getEntityName(), persistentClass);
        if (old != null) {
            log.warn((Object)("duplicate class mapping: " + persistentClass.getEntityName()));
        }
    }

    public void addCollection(Collection collection) throws MappingException {
        Collection old = this.collections.put(collection.getRole(), collection);
        if (old != null) {
            log.warn((Object)("duplicate collection role: " + collection.getRole()));
        }
    }

    public PersistentClass getClass(String className) {
        return (PersistentClass)this.classes.get(className);
    }

    public Collection getCollection(String role) {
        return (Collection)this.collections.get(role);
    }

    public void addImport(String className, String rename) throws MappingException {
        if (this.imports.put(rename, className) != null) {
            throw new MappingException("duplicate import: " + rename);
        }
    }

    public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract) {
        String key = subselect == null ? Table.qualify(catalog, schema, name, '.') : subselect;
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setAbstract(isAbstract);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            table.setSubselect(subselect);
            this.tables.put(key, table);
        } else if (!isAbstract) {
            table.setAbstract(false);
        }
        return table;
    }

    public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable) throws MappingException {
        String key;
        String string = key = subselect == null ? Table.qualify(catalog, schema, name, '.') : subselect;
        if (this.tables.containsKey(key)) {
            throw new MappingException("duplicate table: " + name);
        }
        DenormalizedTable table = new DenormalizedTable(includedTable);
        table.setAbstract(isAbstract);
        table.setName(name);
        table.setSchema(schema);
        table.setCatalog(catalog);
        table.setSubselect(subselect);
        this.tables.put(key, table);
        return table;
    }

    public Table getTable(String schema, String catalog, String name) {
        String key = Table.qualify(catalog, schema, name, '.');
        return (Table)this.tables.get(key);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setDefaultCascade(String defaultCascade) {
        this.defaultCascade = defaultCascade;
    }

    public void setDefaultAccess(String defaultAccess) {
        this.defaultAccess = defaultAccess;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public void addQuery(String name, NamedQueryDefinition query) throws MappingException {
        this.checkQueryExist(name);
        this.queries.put(name.intern(), query);
    }

    public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws MappingException {
        this.checkQueryExist(name);
        this.sqlqueries.put(name.intern(), query);
    }

    private void checkQueryExist(String name) throws MappingException {
        if (this.sqlqueries.containsKey(name) || this.queries.containsKey(name)) {
            throw new MappingException("Duplicate query named: " + name);
        }
    }

    public NamedQueryDefinition getQuery(String name) {
        return (NamedQueryDefinition)this.queries.get(name);
    }

    void addSecondPass(HbmBinder.SecondPass sp) {
        this.secondPasses.add(sp);
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    void addUniquePropertyReference(String referencedClass, String propertyName) {
        PropertyReference upr = new PropertyReference();
        upr.referencedClass = referencedClass;
        upr.propertyName = propertyName;
        upr.unique = true;
        this.propertyReferences.add(upr);
    }

    void addPropertyReference(String referencedClass, String propertyName) {
        PropertyReference upr = new PropertyReference();
        upr.referencedClass = referencedClass;
        upr.propertyName = propertyName;
        this.propertyReferences.add(upr);
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void addTypeDef(String typeName, String typeClass, Properties paramMap) {
        TypeDef def = new TypeDef(typeClass, paramMap);
        this.typeDefs.put(typeName, def);
        log.debug((Object)("Added " + typeName + " with class " + typeClass));
    }

    public TypeDef getTypeDef(String typeName) {
        return (TypeDef)this.typeDefs.get(typeName);
    }

    public Iterator iterateCollections() {
        return this.collections.values().iterator();
    }

    public Iterator iterateTables() {
        return this.tables.values().iterator();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    public FilterDefinition getFilterDefinition(String name) {
        return (FilterDefinition)this.filterDefinitions.get(name);
    }

    public boolean isDefaultLazy() {
        return this.defaultLazy;
    }

    public void setDefaultLazy(boolean defaultLazy) {
        this.defaultLazy = defaultLazy;
    }

    public void addToExtendsQueue(String className, Document doc) {
        ArrayList<Document> existingQueue = (ArrayList<Document>)this.extendsQueue.get(className);
        if (existingQueue == null) {
            existingQueue = new ArrayList<Document>();
        }
        existingQueue.add(doc);
        this.extendsQueue.put(className, existingQueue);
    }

    public PersistentClass locatePersistentClassByEntityName(String entityName) {
        String actualEntityName;
        PersistentClass persistentClass = (PersistentClass)this.classes.get(entityName);
        if (persistentClass == null && StringHelper.isNotEmpty(actualEntityName = (String)this.imports.get(entityName))) {
            persistentClass = (PersistentClass)this.classes.get(actualEntityName);
        }
        return persistentClass;
    }

    static final class PropertyReference
    implements Serializable {
        String referencedClass;
        String propertyName;
        boolean unique;

        PropertyReference() {
        }
    }
}

