/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.persister.PropertyMapping;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class CollectionPropertyMapping
implements PropertyMapping {
    private final QueryableCollection memberPersister;

    public CollectionPropertyMapping(QueryableCollection memberPersister) {
        this.memberPersister = memberPersister;
    }

    public Type toType(String propertyName) throws QueryException {
        if (propertyName.equals("elements")) {
            return this.memberPersister.getElementType();
        }
        if (propertyName.equals("indices")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .indices");
            }
            return this.memberPersister.getIndexType();
        }
        if (propertyName.equals("size")) {
            return Hibernate.INTEGER;
        }
        if (propertyName.equals("maxIndex")) {
            return this.memberPersister.getIndexType();
        }
        if (propertyName.equals("minIndex")) {
            return this.memberPersister.getIndexType();
        }
        if (propertyName.equals("maxElement")) {
            return this.memberPersister.getElementType();
        }
        if (propertyName.equals("minElement")) {
            return this.memberPersister.getElementType();
        }
        throw new QueryException("expecting 'elements' or 'indices' after: " + propertyName);
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        if (propertyName.equals("elements")) {
            String[] cols = this.memberPersister.getElementColumnNames();
            return StringHelper.qualify(alias, cols);
        }
        if (propertyName.equals("indices")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .indices");
            }
            String[] cols = this.memberPersister.getIndexColumnNames();
            return StringHelper.qualify(alias, cols);
        }
        if (propertyName.equals("size")) {
            return new String[]{"count(*)"};
        }
        if (propertyName.equals("maxIndex")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .maxIndex");
            }
            String[] cols = this.memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in maxIndex");
            }
            return new String[]{"max(" + cols[0] + ')'};
        }
        if (propertyName.equals("minIndex")) {
            if (!this.memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .minIndex");
            }
            String[] cols = this.memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in minIndex");
            }
            return new String[]{"min(" + cols[0] + ')'};
        }
        if (propertyName.equals("maxElement")) {
            String[] cols = this.memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in maxElement");
            }
            return new String[]{"max(" + cols[0] + ')'};
        }
        if (propertyName.equals("minElement")) {
            String[] cols = this.memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in minElement");
            }
            return new String[]{"min(" + cols[0] + ')'};
        }
        throw new QueryException("expecting 'elements' or 'indices' after: " + propertyName);
    }

    public Type getType() {
        return this.memberPersister.getCollectionType();
    }
}

