/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.AbstractCollectionPersister;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Subquery;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.loader.BatchingCollectionInitializer;
import org.hibernate.loader.CollectionInitializer;
import org.hibernate.loader.SubqueryOneToManyLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.Joinable;
import org.hibernate.persister.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.hibernate.util.ArrayHelper;

public class OneToManyPersister
extends AbstractCollectionPersister {
    private final boolean cascadeDeleteEnabled;

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public OneToManyPersister(Collection collection, CacheConcurrencyStrategy cache, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cache, cfg, factory);
        this.cascadeDeleteEnabled = collection.getKey().isCascadeDeleteEnabled() && factory.getDialect().supportsCascadeDelete();
    }

    protected String generateDeleteString() {
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.hasWhere) {
            update.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateInsertRowString() {
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("create one-to-many row " + this.getRole());
        }
        return update.setPrimaryKeyColumnNames(this.elementColumnNames).toStatementString();
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateDeleteRowString() {
        String[] pkColumns = this.hasIdentifier ? this.rowSelectColumnNames : ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames);
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many row " + this.getRole());
        }
        return update.setPrimaryKeyColumnNames(pkColumns).toStatementString();
    }

    public boolean consumesAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return true;
    }

    public boolean isManyToMany() {
        return false;
    }

    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        try {
            Iterator entries;
            int i;
            PreparedStatement st;
            int count = 0;
            try {
                st = null;
                i = 0;
                entries = collection.entries();
                int offset = 1;
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            if (this.isDeleteCallable()) {
                                CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLDeleteRowString());
                                callstatement.registerOutParameter(offset++, 2);
                                st = callstatement;
                            } else {
                                st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                            }
                        }
                        this.writeKey(st, id, offset, false, session);
                        this.writeIndex(st, collection.getIndex(entry, i), offset, false, session);
                        session.getBatcher().addToBatch(-1);
                        ++count;
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
            try {
                st = null;
                i = 0;
                entries = collection.entries();
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    int offset = 1;
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                        }
                        this.writeKey(st, id, offset, false, session);
                        collection.writeTo(st, this, entry, i, offset, false);
                        session.getBatcher().addToBatch(1);
                        ++count;
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
            return count;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getSQLExceptionConverter(), sqle, "could not update collection rows: " + MessageHelper.infoString((CollectionPersister)this, (Serializable)id), this.getSQLInsertRowString());
        }
    }

    public String selectFragment(String alias, String suffix, boolean includeCollectionColumns) {
        StringBuffer buf = new StringBuffer();
        if (includeCollectionColumns) {
            buf.append(this.selectFragment(alias)).append(", ");
        }
        OuterJoinLoadable ojl = (OuterJoinLoadable)this.getElementPersister();
        return buf.append(ojl.selectFragment(alias, suffix)).toString();
    }

    protected CollectionInitializer createCollectionInitializer(Map enabledFilters) throws MappingException {
        return BatchingCollectionInitializer.createBatchingOneToManyInitializer(this, this.batchSize, this.getFactory(), enabledFilters);
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)((Object)this.getElementPersister())).fromJoinFragment(alias, innerJoin, includeSubclasses);
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)((Object)this.getElementPersister())).whereJoinFragment(alias, innerJoin, includeSubclasses);
    }

    public String getTableName() {
        return ((Joinable)((Object)this.getElementPersister())).getTableName();
    }

    public String filterFragment(String alias) throws MappingException {
        String result = super.filterFragment(alias);
        if (this.getElementPersister() instanceof Joinable) {
            result = result + ((Joinable)((Object)this.getElementPersister())).oneToManyFilterFragment(alias);
        }
        return result;
    }

    protected CollectionInitializer getSubqueryInitializer(Subquery subquery, SessionImplementor session) {
        return new SubqueryOneToManyLoader(this, subquery.toSubqueryString(), subquery.getResult(), subquery.getQueryParameters(), session.getFactory(), session.getEnabledFilters());
    }
}

