/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    private Object array;
    private static final Log log;
    private transient Class elementClass;
    private transient List tempList;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.collection.PersistentArrayHolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public PersistentArrayHolder(SessionImplementor session, Object array) {
        super(session);
        this.array = array;
        this.setInitialized();
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        int i = 0;
        while (i < length) {
            Object elt = Array.get(this.array, i);
            try {
                Array.set(result, i, persister.getElementType().deepCopy(elt, entityMode, persister.getFactory()));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"Array element type error", (Throwable)iae);
                throw new HibernateException("Array element type error", iae);
            }
            ++i;
        }
        return result;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < sn.length) {
            result.add(sn[i]);
            ++i;
        }
        i = 0;
        while (i < sn.length) {
            AbstractPersistentCollection.identityRemove(result, arr[i], entityName, this.getSession());
            ++i;
        }
        return result;
    }

    public PersistentArrayHolder(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        int i = 0;
        while (i < xlen) {
            if (elementType.isDirty(Array.get(snapshot, i), Array.get(this.array, i), this.getSession())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            list.add(Array.get(this.array, i));
            ++i;
        }
        return list.iterator();
    }

    public boolean empty() {
        return false;
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        int index = (Integer)persister.readIndex(rs, this.getSession());
        int i = this.tempList.size();
        while (i <= index) {
            this.tempList.add(i, null);
            ++i;
        }
        this.tempList.set(index, element);
        return element;
    }

    public Iterator entries(CollectionPersister persister) {
        return this.elements();
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        int i = 0;
        while (i < this.tempList.size()) {
            Array.set(this.array, i, this.tempList.get(i));
            ++i;
        }
        this.tempList = null;
        return true;
    }

    public void beforeInitialize(CollectionPersister persister) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        int i = 0;
        while (i < cached.length) {
            Array.set(this.array, i, persister.getElementType().assemble(cached[i], this.getSession(), owner));
            ++i;
        }
        this.setInitialized();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        int i = 0;
        while (i < length) {
            result[i] = persister.getElementType().disassemble(Array.get(this.array, i), this.getSession(), null);
            ++i;
        }
        return result;
    }

    public Object getValue() {
        return this.array;
    }

    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        int end;
        int i;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            i = arraySize;
            while (i < snSize) {
                deletes.add(new Integer(i));
                ++i;
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        i = 0;
        while (i < end) {
            if (Array.get(this.array, i) == null && Array.get(sn, i) != null) {
                deletes.add(new Integer(i));
            }
            ++i;
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i) != null && (i >= Array.getLength(sn) || Array.get(sn, i) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i < Array.getLength(sn) && Array.get(sn, i) != null && Array.get(this.array, i) != null && elemType.isDirty(Array.get(this.array, i), Array.get(sn, i), this.getSession());
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        return new Integer(i);
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i) {
        Serializable sn = this.getSnapshot();
        return Array.get(sn, i);
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

